;  INIT.ASM - This code illustrates the recommended technique
;             for changing modes (text or graphics) on the Hercules Graphics
;             Card. Pay particular attention to the two tables - ttable, and
;             gtable - which contain the suggested 6845 values for text and
;             graphics modes.
;
;             NOTE: Be sure that the Configuration Port (03BF) is set to your
;             requirements (03BF = 1 for HALF, 03BF = 3 for FULL) before
;             attempting to set graphics mode.


;		port address
index		equ		03b4h
cntrl 	       	equ		03b8h

;		control	codes
scrn_on        	equ		8
grph	       	equ		2
text	       	equ		20h


xdata	segment public 'data'
	
gtable		db	35h,2dh,2eh,07h
		db	5bh,02h,57h,57h
		db	02h,03h,00h,00h

ttable		db	61h,50h,52h,0fh
		db	19h,06h,19h,19h
		db	02h,0dh,0bh,0ch


xdata 	ends
xcode	segment public 'code'
		assume cs:xcode,ds:xdata

;*********************************************************************
;GRAPHICS MODE - Programs the 6845 CRT controller for the 720 x 348 graphics
;mode. The active page for both writing and display is set to the default value
;of page 0.
;ON ENTRY - no parameters.
;*********************************************************************

gmode	proc	near

	push	es
	push	ds

	mov	ax,xdata
	mov	ds,ax	

	mov	al,grph
	lea	si,gtable
	mov	bx,0
	mov	cx,4000h
	call	setmd

	pop	ds
	pop	es

	ret

gmode	endp

;**********************************************************************
;TEXT MODE - Programs the 6845 and control register to produce text mode.
;
;ON ENTRY - no parameters.
;***********************************************************************
tmode	proc	near

	push	es
	push	ds

	mov	ax,xdata
	mov	ds,ax

	mov	al,text
	lea	si,ttable
	mov	bx,720h
	mov	cx,2000
	call	setmd

	pop	ds
	pop	es

	ret

tmode	endp

setmd	proc	near

;     sets mode to graphics or text
;     depending on al
;     si = parameter table
;     cx = number of words to be cleared
;     bx = blank value
	push	ds
	push	es
	push	ax
	push	bx
	push	cx

;     change mode but without scrn_on
	mov	dx,cntrl
	out	dx,al

;     intialize the 6845

	mov	dx,index
	mov	cx,12		;12 parameters to
				;be output
	xor	ah,ah		;starting from
				;reg. 0
parms:	mov	al,ah
	out	dx,al		;output register
				;number
	cld

	inc	dx
	lodsb
	out	dx,al		;output data

	inc	ah		;next value
	dec	dx
	loop	parms

	pop	cx		;clear the buffer
	mov	ax,0b000h

	mov	es,ax
	xor	di,di
	pop	ax
	rep	stosw

;     scrn_on, page 0

	mov	dx,cntrl
	pop	ax
	add	al,scrn_on
	out	dx,al

	pop	es
	pop	ds

	ret

setmd	endp
xcode	ends

