
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the UCPIO12_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// UCPIO12_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef UCPIO12_EXPORTS
#define UCPIO12_API __declspec(dllexport)
#else
#define UCPIO12_API __declspec(dllimport)
#endif

// Pass in the board number you wish to open
// 0 = first board, 1 = second board, ect..
// A device HANDLE is returned, use this HANDLE in all other calls
// If an error occurs, INVALID_HANDLE_VALUE is returned
UCPIO12_API HANDLE uCPIO12_OpenBoard(int id);

// Pass in the HANDLE to the device you want to close
UCPIO12_API int uCPIO12_CloseBoard(HANDLE dev);

UCPIO12_API UCHAR uCPIO12_ReadDigitalPort(HANDLE dev, UCHAR port);

UCPIO12_API BOOL uCPIO12_WriteDigitalPort(HANDLE dev, UCHAR port, UCHAR val);

UCPIO12_API BOOL uCPIO12_SetDirection(HANDLE dev, UCHAR dir);

UCPIO12_API uCPIO12_BOARD_INFO uCPIO12_GetBoardInfo(HANDLE dev);

USHORT uCPIO12_FindBoardIndex(HANDLE dev);

BOOL uCPIO12_VerifyPortIsOutput(USHORT id, UCHAR port);