;
; SMTPARA
; Configuration File Entries
; 02-Nov-1994
;
; Entries may appear in any order within the config file, one per line.
;
;
; SMT Parameters
; --------------
;
; SMT	PmfPasswd password		(optional)
;
; This keyword defines the password that all remote PMF (Parameter Management
; Frame) requests must provide to change FDDI attributes within the adapter.
;
; The value for PmfPasswd is 8 ASCII characters long and not case sensitive
; since lower case letters will be converted to upper cases. Password
; protection can be disabled by setting this keyword to all zeros (default), or
; by not specifying a PMFPASSWD.
;
;
; SMT	UserData data			(optional)
;
; This keyword provides local write access to the User Data attribute,
; registered as fddiSMT 17 in the SMT Standard.
;
; The User Data must be an ASCII string for compliance with the FDDI SMT
; Standard.
;
;
; SMT	LerCutoffA value		(optional)
; SMT	LerCutoffB value		(optional)
;
; These keywords provide local write access to the LER Cutoff attributes,
; registered as fddiPORT 58 in the SMT Standard.
;
; These attributes indentify the excessive Link Error Rate that removes Port
; A/B (or Port S).
;
; These keywords are specified as absolute values of the base 10 logarithm of
; the LER Cutoff value.
;
; The valid range reaches from 1E-4 to 1E-15 for both keywords. If a value is
; specified which lies outside the limits, the upper/lower limit will be taken.
; If no value is specified, the default value for LerCutoffA/LerCutoffB (1E-7)
; will be used.
;
;
; SMT	LerAlarmA value			(optional)
; SMT	LerAlarmB value			(optional)
;
; These keywords provide local write access to the LER Alarm attributes,
; registered as fddiPORT 59 in the SMT Standard.
;
; These attributes identify the excessive Link Error Rate that siganls an alarm
; at Port A/B (or Port S).
;
; These keywords are specified as absolute values of the base 10 logarithm of
; the LER Alarm value.
;
; The valid range reaches from 1E-4 to 1E-15 for both keywords. If a value is
; specified which lies outside the limits, the upper/lower limit will be taken.
; If no value is specified, the default value for LerAlarmA/LerAlarmB (1E-8)
; will be used.
;
;
; SMT	TMin value			(optional)
;
; This keyword provides local write access to the 2's complement T-Min
; attribute, registered as fddiMAC 55 in the SMT Standard.
;
; The value for TMin is specified in milliseconds.
;
; The valid range reaches from 5 ms to 165 ms. If a value is specified which
; lies outside the limits, the upper/lower limit will be taken. If no value is
; specified, the default value for TMin (5 ms) will be used.
;
;
; SMT	TMax value			(optional)
;
; This keyword provides local write access to the 2's complement T-Max
; attribute, registered as fddiMAC 53 in the SMT Standard.
;
; The value for TMax is specified in milliseconds.
;
; The valid range reaches from 5 ms to 165 ms. If a value is specified which
; lies outside the limits, the upper/lower limit will be taken. If no value is
; specified, the default value for TMax (165 ms) will be used.
;
;
; SMT	TReq value			(optional)
;
; This keyword provides local write access to the 2's complement T-Req
; attribute, registered as fddiMAC 51 in the SMT Standard.
;
; The value for TReq is specified in milliseconds.
;
; The valid range reaches from 5 ms to 165 ms. If a value is specified which
; lies outside the limits, the upper/lower limit will be taken. If no value is
; specified, the default value for TReq (165 ms) will be used.
;
;
; SMT	Tvx value			(optional)
;
; This keyword provides local write access to the Tvx attribute, registered as
; fddiMAC 54 in the SMT Standard.
;
; This attribute provides local control of the recovery time from transient
; ring errors.
;
; The value for Tvx is specified in microseconds.
;
; The valid range reaches from 2500 us to 10000 us. If a value is specified
; which lies outside the limits, the upper/lower limit will be taken. If no
; value is specified, the default value for Tvx (2700 us) will be used.
;
;
; SBA Parameters
; --------------
;
; SMT	SbaCommand START or STOP	(optional)
;
; This keyword is an SBA local action to start or stop the SBA application. The
; default value is 'STOP'.
;
; Note: There should be only one active SBA application in the same ring.
;
;
; SMT	SbaAvailable value		(optional)
;
; This keyword defines the maximum synchronous bandwidth in percent available
; for the primary path.
;
; The valid range reaches from 0 - 100 percent. The default value is 50 percent
; (6.25 MBytes/s). If a value is specified which lies outside the limits, the
; upper/lower limit will be taken. This value remains zero until the SBA
; application is enabled and active.
;
;
; ESS Parameters
; --------------
;
; SMT	SbaPayLoad value		(optional)
;
; This keyword defines the requested synchronous bandwidth for manual static
; allocations.
;
; The valid range reaches from 0 - 1562 bytes per 125 microseconds. For
; example, if the required bandwidth is 1 MBit/s (125,000 Bytes/s) the value of
; the payload is 125,000 * 125E-6 = 15.625 round up to 16. If a value is
; specified which lies outside the limits, the upper/lower limit will be taken.
; The default value is zero - no synchronous bandwidth is used.
;
; The user is required to define the amount of bandwidth to be able to send
; synchronous frames. If the keyword SbaPayLoad is not specified, the keywords
; SbaOverHead, MaxTNeg, MinSegmentSize and SbaCategory have no effect.
;
; The end station supports either the static allocation model, where the
; requested payload is specified by the keyword SbaPayload, or the dynamic
; allocation model, where the required synchronous bandwidth is allocated
; directly by the multimedia application. Therefore, if a multimedia
; application is used which can dynamically allocate the bandwidth, the keyword
; SbaPayLoad should not be specified.
;
;
; SMT	SbaOverHead value		(optional)
;
; This keyword defines the requested overhead for static allocations.
;
; The valid range reaches from 50 to 5000 bytes. If a value is specified which
; lies outside the limits, the upper/lower limit will be taken. The default
; value is 50 bytes.
;
; This keyword has only an effect, if the keyword SbaPayLoad is specified.
;
;
; SMT	MaxTNeg value			(optional)
;
; This keyword defines the maximum token rotation delay acceptable to the
; application(s) using synchronous bandwidth.
;
; The valid range reaches from 5 ms to 165 ms. If a value is specified which
; lies outside the limits, the upper/lower limit will be taken. The default
; value is 25 ms.
;
; This keyword has only an effect, if the keyword SbaPayLoad is specified.
;
;
; SMT	MinSegmentSize value		(optional)
;
; This keyword defines the minimum synchronous segmentation size.
;
; This value corresponds to the amount of bytes to be transmitted on a per
; token opportunity. The valid range reaches from 1 to 4478 bytes.
;
; If a value is specified which lies outside the limits, the upper/lower limit
; will be taken.
;
; This keyword has only an effect, if the keyword SbaPayLoad is specified.
;
;
; SMT	SbaCategory value		(optional)
;
; This keyword defines the session ID of the SBA_Category for the static
; allocation.
;
; The valid range reaches from 0 to 65535. If a value is specified which lies
; outside the limits, the upper/lower limit will be taken.
;
; This parameter has only an effect, if the keyword SbaPayLoad is specified.
;
;
; SMT	SynchTxMode ALL or SPLIT	(optional)
;
; This keyword defines the synchronous transmission mode.
;
; The default value is 'SPLIT', where only packets identified as synchronous
; packets shall be transmitted by the synchronous queue. The other value is
; 'ALL', where all LLC packets received from upper layers are transmitted via
; the synchronous queue.
;
; This keyword has only an effect, if the end station support was able to get
; the required synchronous bandwidth from the SBA.
;
