/** REXX *************************************************************/
/* BLDCPMAP EXEC - User Sample REXX EXEC                             */
/*                                                                   */
/* This EXEC is a sample for customer use.  It is not maintained.    */
/* This EXEC is used to create a Code Page Map file for use by the   */
/* AFP WorkBench Viewer.  A Code Page Map file maps the character    */
/* ids in an AFP code page to the corresponding characters in an     */
/* MS Windows' character set for displaying on the PC screen.        */
/* (See Appendix C of the "Using the Viewer" publication for more    */
/* information.)   This EXEC takes as input the following:           */
/*    1) a user's AFP codepage   (in EBCDIC format)                  */
/*    2) a Windows character set file supplied with the Viewer       */
/*       (ANSI.WCP or SYMBOL.WCP in the \FONT\SAMPLES subdirectory)  */
/*                                                                   */
/* This EXEC will run in the MVS(TSO/E), VM(CMS) or OS/2 Version 2   */
/* environments with REstructured eXtended eXecutor (REXX) language. */
/* If you run this exec in the MVS TSO/E or VM CMS host environment, */
/*                                                                   */
/*  ** upload this exec and the Windows charset files, ANSI.WCP and  */
/*     SYMBOL.WCP from the Viewer \FONT\SAMPLES subdirectory.  When  */
/*     you upload these files to the host, ASCII/EBCDIC translation  */
/*     must occur and CR/LF must indicate a new line.  All the       */
/*     uploaded files should be human-readable.                      */
/*  ** On MVS, the exec may be run explicitly with the EXEC  command */
/*     or implicitly by member name if the partitioned data set con- */
/*     taining BLDCPMAP was previously allocated to your system file */
/*     that contains execs (often SYSEXEC or SYSPROC).               */
/*  ** On VM, the BLDCPMAP filetype must be EXEC.                    */
/*                                                                   */
/* If you run this exec in the OS/2 Version 2 environment,           */
/*                                                                   */
/*  ** download your AFP code page(s) to OS/2, specify Binary file   */
/*     transfer (EBCDIC/ASCII translation must not take place). The  */
/*     AFP code page will not be human-readable.                     */
/*  ** Make sure that REXX is installed.                             */
/*  ** Rename the BLDCPMAP.REX to BLDCPMAP.CMD before executing.     */
/*                                                                   */
/* In all environments, if the exec is correctly named, you can      */
/* execute it without parameters to get the correct syntax of the    */
/* command:                                                          */
/*   For MVS,  EXEC bldcpmap  EXEC                                   */
/*              (if the low-level qualifier is ".exec" )             */
/*   For VM,  bldcpmap                                               */
/*   For OS/2, bldcpmap                                              */
/*                                                                   */
/* ----------------------------------------------------------------- */
/* For the OS/2 V2 environment, the invocation syntax is  ************/
/*                                                                   */
/*         BLDCPMAP AFP_codepage  Windows_charset  output            */
/*                                                                   */
/*           where all parameters specify fully-qualified files      */
/*           if not in the directory where you are running BLDCPMAP  */
/*                                                                   */
/*    An example:                                                    */
/*      BLDCPMAP T1000395.CP  C:\FLD\FONT\SAMPLES\ANSI.WCP  395.CP   */
/*                                                                   */
/* ----------------------------------------------------------------- */
/* For the MVS TSO/E environment, the explicit invocation syntax is  */
/*                                                                   */
/*  EXEC bldcpmap.exec 'AFP.codepage Windows.charset output.ds' EXEC */
/*                                                                   */
/*       where all parameters specify Not fully-qualified data sets  */
/*            (enclosed by one pair of single quotes) and            */
/*            "bldcpmap.exec" is the data set name that contains     */
/*            this BLDCPMAP program.                                 */
/*                                                                   */
/*       If a fully-qualified data set name is used within the single*/
/*          quotes, surround it with 2 Single quotes on either side  */
/*          of the data set name.  The invocation syntax is:         */
/*                                                                   */
/*  EXEC bldcpmap 'AFP.codepg ''hi.Windows.charset'' output.ds' EXEC */
/*                                                                   */
/*    An example:                                                    */
/*    EXEC BLDCPMAP '''FONTLIB.T1000395.CP'' ANSI.WCP  395.CP' EXEC  */
/*                                                                   */
/* ----------------------------------------------------------------- */
/* For the VM CMS environment, the invocation syntax is  *************/
/*                                                                   */
/*         BLDCPMAP hfn hft hfm  wfn wft wfm  ofn oft ofm'           */
/*           where                                                   */
/*             hfn is the AFP host codepage filename                 */
/*             hft is the AFP codepage filetype                      */
/*             hfm is the AFP codepage filemode                      */
/*             wfn is the Windows character set filename             */
/*             wft is the Windows character set filetype             */
/*             wfm is the Windows character set filemode             */
/*           and optionally:                                         */
/*             ofn -- output filename, should be a codepage global   */
/*                  ID (cpgid) for the codepage                      */
/*             oft is the output filetype                            */
/*             ofm is the output filemode                            */
/*                                                                   */
/*    If the output file is not specified, it will default to:       */
/*            "AFP-codepage-filename" CP_xxx A                       */
/*      where xxx is ANSI or SYMBO, depending on the Windows filename*/
/*                                                                   */
/*    An example:                                                    */
/*      BLDCPMAP T1000395 FONT3820 *  ANSI WCP A  395 CP A           */
/*                                                                   */
/* ----------------------------------------------------------------- */
/*                                                                   */
/* Written: 12/92                                                    */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/* Initialize some handy constants.                                  */
/*********************************************************************/
system = ADDRESS()
error_return = 12
cpi_entry_size = 10
hex_code_pos_in_cpi_entry = 9
id_pos_in_sf = 2
flags_pos_in_sf = 5
ext_pos_in_sf = 8
sfi_normal_len = 8

/*********************************************************************/
/* Parse the parameters.  These specify the input and output files.  */
/* The number of parameters and specific meaning of each depends     */
/* upon the operating system in which this is executing.             */
/*********************************************************************/
ARG arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
/*********************************************************************/
/* Interpret the parameters and make sure all the files are ready    */
/* to go.                                                            */
/*********************************************************************/
/* TRACE ?R */
Call CHECK_FILES
If RESULT <> 0 Then Exit error_return

/*********************************************************************/
/* Prepare the host codepage for processing.                         */
/*********************************************************************/
Call PREPARE_HOST_CODEPAGE
If RESULT <> 0 Then  Call CLEAN_UP RESULT

/*********************************************************************/
/* Prepare the windows codepage for processing.                      */
/*********************************************************************/
Call PREPARE_WINDOWS_CP_FILE
If RESULT <> 0 Then  Call CLEAN_UP RESULT

/*********************************************************************/
/* Process the host graphic identifiers and begin the output file.   */
/*********************************************************************/
Call PROCESS_HOST_GRAPH_IDS
If RESULT <> 0 Then  Call CLEAN_UP RESULT

/*********************************************************************/
/* Process the unmatched windows graphic identifiers and complete    */
/* the output file.                                                  */
/*********************************************************************/
Call PROCESS_UNMATCHED_WINDOWS_GRAPH_IDS
If RESULT <> 0 Then  Call CLEAN_UP RESULT

/*********************************************************************/
/* Display the results to the user.                                  */
/*********************************************************************/
Call REPORT_RESULTS
If RESULT <> 0 Then  Call CLEAN_UP RESULT

/*********************************************************************/
/* Clean up and Exit.                                                */
/*********************************************************************/
Call CLEAN_UP 0

Exit


/*********************************************************************/
/* CHECK_FILES:                                                      */
/*   This routine validates the parameters, verifies the existence   */
/*   of the input files, opens the files, and writes a header to the */
/*   output file.                                                    */
/*********************************************************************/
CHECK_FILES:

  Select

    /*****************************************************************/
    /* For MVS (TSO/E),                                              */
    /*****************************************************************/
    When system = 'TSO' Then
      Do
       /*************************************************************/
       /* Three parameters are required.  If lacking, show the user */
       /* the correct syntax and get out.                           */
       /*************************************************************/
       If arg3 = '' | arg1 = '?' Then
          Do
           Say ' '
           Say 'Command syntax is:'
           Say ' '
           Say ' EXEC bldcpmap.exec',
               '''AFP.codepage  Windows.charset  output.ds'' EXEC'
           Say ' '
           Say '     where all parameters specify Not fully-qualified',
                           'data set names'
           Say '      and "bldcpmap.exec" is the data set name of the',
                         'BLDCPMAP program.'
           Say ' '
           Say '  If a fully-qualified data set name is used within',
                   'the single quotes,'
           Say '   surround it with 2 Single quotes on either side',
                  'of the data set name.'
           Say '   For example,'
           Say ' '
           Say " EXEC bldcpmap '''hi.AFP.cp''",
                     " ''hi.Windows.charset''  output.ds' EXEC "
           Say ' '
           Return error_return
          End

       /*************************************************************/
       /* Build the dataset names from the parameters.              */
       /*************************************************************/
       host_codepage_file = arg1
       windows_codepage_file = arg2
       output_file = arg3

  /*   MSG('OFF')  */

       /*************************************************************/
       /* Check if the input data sets exist and allocate them      */
       /* for input, otherwise give an error and exit.              */
       /*************************************************************/
       data_set = host_codepage_file
       ddnam = 'AFPIN'
       call DS_ALLOC
       If RESULT <> 0 Then Return RESULT

       data_set = windows_codepage_file
       ddnam = 'WININ'
       call DS_ALLOC
       If RESULT <> 0 Then Return error_return

       /*************************************************************/
       /* Determine if the output ds is sequential or a PDS and     */
       /* allocate it accordingly. If it already exists, empty it.  */
       /*************************************************************/
       data_set = output_file
       member_pos = POS('(', output_file)
       If member_pos \= 0  Then
         data_set = SUBSTR(output_file,1,member_pos-1)

       If SYSDSN(data_set) = 'OK' Then
         Do
         "ALLOC DA("output_file") FILE(MAPOUT) SHR REUSE"
         "EXECIO 0 DISKW MAPOUT (FINIS)"
         End
       Else
         If member_pos = 0  Then        /* no member specified */
           "ALLOC DA("output_file") F(MAPOUT) NEW CATALOG DSORG(PS)"
         Else
           "ALLOC DA("output_file") F(MAPOUT) NEW DIR(2) DSORG(PO)",
              " BLOCK(800) SPACE(10,5) CATALOG"

       If RC <> 0 Then
         Do
           Say 'Error when allocating' output_file 'to File MAPOUT'
           Return RC
         End

       /*************************************************************/
       /* Prepare names for header in output file.                  */
       /*************************************************************/
       cpstr = LASTPOS('T1',arg1)
       If cpstr = 0  Then
         host_file_name = arg1
       Else
         host_file_name = SUBSTR(arg1,cpstr,8);

       Select
         When POS('ANSI', arg2) \= 0  Then
            windows_file_name = 'ANSI'
         When POS('SYMBOL', arg2) \= 0  Then
            windows_file_name = 'SYMBOL'
         Otherwise
            windows_file_name = arg2
       End

    /* MSG('ON')  */

      End    /*  When system = 'TSO'   */

    /*****************************************************************/
    /* For VM (CMS),                                                 */
    /*****************************************************************/
    When system = 'CMS' Then
      Do
       /*************************************************************/
       /* Nine parameters are required.  If lacking, show the user  */
       /* the correct syntax and get out.                           */
       /*************************************************************/
       If arg6 = '' | arg1 = '?' Then
         Do
           Say ' '
           Say 'Command syntax is:'
           Say ' '
           Say '  BLDCPMAP hfn hft hfm  wfn wft wfm  ofn oft ofm'
           Say ' '
           Say '    where,'
           Say '      hfn is the AFP host codepage filename'
           Say '      hft is the AFP codepage filetype'
           Say '      hfm is the AFP codepage filemode'
           Say '      wfn is the Windows character set filename'
           Say '      wft is the Windows character set filetype'
           Say '      wfm is the Windows character set filemode'
           Say '   and optionally:           '
           Say '      ofn -- output filename, should be the codepage',
                           'global ID for the codepage'
           Say '      oft is the output filetype'
           Say '      ofm is the output filemode'
           Say ' '
           Return error_return
         End

       /*************************************************************/
       /* Build the file names from the parameters.                 */
       /*************************************************************/
       If arg9 = ' ' Then  arg9 = 'A';
       If arg7 = ' ' Then
         Do
          arg7 = arg1;
          arg8 = 'CP_'||arg4;
         End;
       host_codepage_file = arg1 arg2 arg3
       windows_codepage_file = arg4 arg5 arg6
       output_file = arg7 arg8 arg9

       'SET EMSG OFF'

       /*************************************************************/
       /* If either of the input files can't be found, so indicate  */
       /* and get out.                                              */
       /*************************************************************/
       'STATE' host_codepage_file
       If RC <> 0 Then
         Do
           Say 'File' host_codepage_file 'cannot be found'
           Return RC
         End

       'STATE' windows_codepage_file
       If RC <> 0 Then
         Do
           Say 'File' windows_codepage_file 'cannot be found'
           Return RC
         End

       /*************************************************************/
       /* If the output file already exists, erase it.              */
       /*************************************************************/
       'STATE' output_file
       If RC = 0 Then
         'ERASE' output_file

       /*************************************************************/
       /* Prepare names for output file header.                     */
       /*************************************************************/
       host_file_name = arg1
       windows_file_name = arg4

       'SET EMSG ON'

      End    /*  When system = 'CMS'   */

    /*****************************************************************/
    /* For OS/2,                                                     */
    /*****************************************************************/
    When system = 'CMD' Then
      Do
        /*************************************************************/
        /* Three parameters are required.  If lacking, show the user */
        /* the correct syntax and get out.                           */
        /*************************************************************/
        If arg3 = '' Then
          Do
            Say ' '
            Say 'Command syntax is:'
            Say ' '
            Say '  BLDCPMAP AFP_codepage  Windows_charset  output'
            Say ' '
            Say '    where all parameters specify fully-qualified files'
            Say ' '
            Return error_return
          End

        /*************************************************************/
        /* Build the file names from the parameters.                 */
        /*************************************************************/
        host_codepage_file = arg1
        windows_codepage_file = arg2
        output_file = arg3

        /*************************************************************/
        /* If either of the input files can't be found, so indicate  */
        /* and get out.                                              */
        /*************************************************************/
        file_status = STREAM( host_codepage_file, 'C', 'OPEN READ' )
        If file_status <> 'READY:' Then
          Do
            Say 'File' host_codepage_file 'cannot be found'
            Return error_return
          End

        file_status = STREAM( windows_codepage_file, 'C', 'OPEN READ' )
        If file_status <> 'READY:' Then
          Do
            Say 'File' windows_codepage_file 'cannot be found'
            Return error_return
          End

        /*************************************************************/
        /* If the output file already exists, erase it.              */
        /*************************************************************/
        file_size = STREAM( output_file, 'C', 'QUERY SIZE' )
        If file_size > 0 Then
          '@ERASE' output_file

        /*************************************************************/
        /* Prepare names for output file header.                     */
        /*************************************************************/
        host_file_name = EXTRACT_FILENAME( arg1 )
        windows_file_name = EXTRACT_FILENAME( arg2 )

        /*************************************************************/
        /* For OS/2, the host codepage is recorded in EBCDIC and the */
        /* windows codepage is recorded in ASCII.  A conversion will */
        /* be necessary, so initialize the translate tables.         */
        /*************************************************************/
        Call PREPARE_XLATE_TABLES
        If RESULT <> 0 Then Return error_return

      End    /*  When system = 'CMD' -  OS/2  */

    /*****************************************************************/
    /* If this exec has not been coded for the operating system, tell*/
    /* the user and get out.                                         */
    /*****************************************************************/
    Otherwise
      Do
        Say 'Command not implemented for this operating environment'
        Return error_return
      End
  End

  /*******************************************************************/
  /* Build and write the header to the output file.                  */
  /*******************************************************************/
  output_header = ';' || host_file_name '  to  ' windows_file_name
  Call PUT_LINE output_header
  If RESULT <> 0 Then Return error_return

  Return 0

/*********************************************************************/
/* PREPARE_HOST_CODEPAGE:                                            */
/*   This routine reads the entire AFP codepage into a variable.     */
/*********************************************************************/
PREPARE_HOST_CODEPAGE:

  host_codepage = ''

  Do Forever
    line = GET_LINE( host_codepage_file )
    If line = '' Then Leave
    host_codepage = host_codepage || line
  End

  Return 0

/*********************************************************************/
/* PREPARE_WINDOWS_CP_FILE:                                          */
/*   This routine scans the windows codepage file and creates a set  */
/*   of variables to record each codepoint having an associated      */
/*   graphic identifier.                                             */
/*********************************************************************/
PREPARE_WINDOWS_CP_FILE:

  /*******************************************************************/
  /* For each line of the windows codepage,                          */
  /*******************************************************************/
  Do Forever

    /*****************************************************************/
    /* Extract the codepoint and associated graphic id.              */
    /*****************************************************************/
    line = GET_LINE( windows_codepage_file )
    If line = '' Then Leave
    parse VAR line hex_code graphic_id rest

    /*****************************************************************/
    /* If the line is not a comment and there is an associated       */
    /* graphic id, create a set of variables for the codepoint and   */
    /* graphic id.                                                   */
    /*****************************************************************/
    If hex_code <> ';' & hex_code <> '/*' & graphic_id <> '' Then
      Do
        w_c_graph.graphic_id = hex_code
        w_c_hex.hex_code = graphic_id
      End
  End

  Return 0

/*********************************************************************/
/* PROCESS_HOST_GRAPH_IDS:                                           */
/*   This routine scans all of the graphic identifiers within the    */
/*   CPI structured field of the host codepage.  For each such       */
/*   graphic id, if a match is found with a windows graphic id,      */
/*   write a line to the output file indicating the codepoint for    */
/*   the host and the windows codepages; if not, write a line to     */
/*   the output file indicating that there is no match for the host  */
/*   graphic id.                                                     */
/*********************************************************************/
PROCESS_HOST_GRAPH_IDS:

  /*******************************************************************/
  /* Parse the host codepage and locate the first and last graphic   */
  /* ids within the CPI structured field.                            */
  /*******************************************************************/
  Call FIND_1ST_HOST_GRAPHIC_ID
  If RESULT <> 0 Then Return error_return

  /*******************************************************************/
  /* For each graphic id from the host codepage,                     */
  /*******************************************************************/
  no_matches = 0
  Do i = first_graph_id_pos To last_graph_id_pos By cpi_entry_size

    /*****************************************************************/
    /* When running in OS/2, the host codepage is EBCDIC and the     */
    /* Windows codepage is ASCII.  Translate the host graphic ids    */
    /* from EBCDIC to ASCII to allow comparison and recording in the */
    /* output file.                                                  */
    /*****************************************************************/
    graph_id = SUBSTR( host_codepage, i, 8 )
    If system = 'CMD' Then
      graph_id = TRANSLATE( graph_id, ascii, ebcdic )

    /*****************************************************************/
    /* Extract the codepoint associated with the host graphic id.    */
    /*****************************************************************/
    hex_code_pos = i + hex_code_pos_in_cpi_entry
    host_hex_code = SUBSTR( host_codepage, hex_code_pos, 1 )
    host_hex_code = C2X( host_hex_code )

    /*****************************************************************/
    /* If a 'host' graphic id has been assigned a hex codepoint in   */
    /* the Windows codepage file (means the graphic id exists in     */
    /* both codepages), build a line showing the match and the hex   */
    /* codepoints from the host and Windows, and destroy the         */
    /* variables (this will allow us to later determine which of the */
    /* windows graphic ids were unmatched).  If no variables have    */
    /* been created, build a line indicating no match for the host   */
    /* graphic id and keep track of the number of these unmatched    */
    /* host graphic ids.                                             */
    /*****************************************************************/
    windows_graph_id = w_c_graph.graph_id
    If SYMBOL( 'w_c_graph.graph_id' ) = 'VAR' Then
      Do
        output_line = graph_id host_hex_code ' ',
                      graph_id w_c_graph.graph_id
        Drop w_c_hex.windows_graph_id
      End
    Else
      Do
        output_line = graph_id host_hex_code ' NOMATCH 00'
        no_matches = no_matches + 1
      End

    /*****************************************************************/
    /* Write the line to the output file.                            */
    /*****************************************************************/
    Call PUT_LINE output_line
    If RESULT <> 0 Then Return error_return
  End

  Return 0

/*********************************************************************/
/* PROCESS_UNMATCHED_WINDOWS_GRAPH_IDS:                              */
/*   This routine scans all of the unmatched windows graphic iden-   */
/*   tifiers and writes a comment line to the output file for each.  */
/*********************************************************************/
PROCESS_UNMATCHED_WINDOWS_GRAPH_IDS:

  /*******************************************************************/
  /* For each possible windows codepoint,                            */
  /*******************************************************************/
  Do i = 0 To 255

    /*****************************************************************/
    /* If a set of variables was created for this codepoint (the     */
    /* windows codepage contains that codepoint and an associated    */
    /* graphic id) and those variables still exist (a match was not  */
    /* found with a host graphic id), write a comment line to the    */
    /* output file identifying the unmatched windows graphic id and  */
    /* codepoint.                                                    */
    /*****************************************************************/
    j = D2X( i, 2 )
    If SYMBOL( 'w_c_hex.j' ) = 'VAR' Then
      Do
        output_line = ';;;;;;;; ;   ' w_c_hex.j j
        Call PUT_LINE output_line
        If RESULT <> 0 Then Return error_return
      End
  End

  /*******************************************************************/
  /* Output final line to file to mark end of file                   */
  /*******************************************************************/
  output_line = '/* '
  Call PUT_LINE output_line               /* final line in file */

  Return 0

/*********************************************************************/
/* REPORT_RESULTS:                                                   */
/*   This routine displays a line to the user indicating the number  */
/*   of unmatched graphic identifiers from the host codepage.        */
/*********************************************************************/
REPORT_RESULTS:

  Say '     '
  Say '  ' no_matches ' unmatched' 'graphic character IDs'
  Say '     for the' host_file_name 'codepage to',
         windows_file_name 'character set comparison'
  Say '     '

  Return 0

/*********************************************************************/
/* FIND_1ST_HOST_GRAPHIC_ID:                                         */
/*   This routine parses the host codepage (previously read into a   */
/*   variable), locates the CPI structured field, and locates the    */
/*   first and last graphic identifiers within the CPI.              */
/*********************************************************************/
FIND_1ST_HOST_GRAPHIC_ID:

  /*******************************************************************/
  /* Locate the structured field identifier for a CPI within the     */
  /* host codepage.  If none is found, tell the user that the file   */
  /* is not a valid codepage and get out.                            */
  /*******************************************************************/
  sf_id_pos = POS( 'D38C87'x, host_codepage )

  If sf_id_pos = 0 Then
    Do
      Say 'CPI Structured Field not found'
      Say host_codepage_file 'is not a valid host codepage'
      Return error_return
    End

  /*******************************************************************/
  /* Locate the beginning of the CPI structured field and extract    */
  /* the structured field length and flags.                          */
  /*******************************************************************/
  sf_pos = sf_id_pos - id_pos_in_sf
  sf_len = SUBSTR( host_codepage, sf_pos, 2 )
  sf_len = C2D( sf_len )
  sf_flags_pos = sf_pos + flags_pos_in_sf
  sf_flags = SUBSTR( host_codepage, sf_flags_pos, 1 )
  sf_flags = C2D( sf_flags )

  /*******************************************************************/
  /* Locate the first byte of the data portion of the structured     */
  /* field (complicated by the possibility of a introducer exten-    */
  /* sion).  This will be the location of the first graphic id.      */
  /*******************************************************************/
  If sf_flags < 64 Then                 /* 64 = '40'x (extension flag*/
    ext_len = 0
  Else
    Do
      sf_ext_pos = sf_pos + ext_pos_in_sf
      ext_len = SUBSTR( host_codepage, sf_ext_pos, 1 )
      ext_len = C2D( ext_len )
      sf_flags = sf_flags - 64          /* 64 = '40'x (extension flag*/
    End
  first_graph_id_pos = sf_pos + sfi_normal_len + ext_len

  /*******************************************************************/
  /* Locate the first byte of the last graphic id within the CPI.    */
  /* This is complicated by the possibility of padding at the end of */
  /* the structured field.                                           */
  /*******************************************************************/
  If sf_flags < 8 Then                  /* 8 = '08'x (padding flag)  */
    pad_len = 0
  Else
    Do
      pad_len_pos = sf_pos + sf_len - 1
      pad_len = SUBSTR( host_codepage, pad_len_pos, 1 )
      pad_len = C2D( pad_len )
      If pad_len = 0 Then
        Do
          pad_len_pos = pad_len_pos - 2
          pad_len = SUBSTR( host_codepage, pad_len_pos, 2 )
          pad_len = C2D( pad_len )
        End
    End
  last_graph_id_pos = sf_pos + sf_len - pad_len - cpi_entry_size

  Return 0

/*********************************************************************/
/* GET_LINE:                                                         */
/*   This routine is used as a function.  The name of an input file  */
/*   is passed as a parameter.  It reads one line from that file and */
/*   returns the line to the invoker.                                */
/*********************************************************************/
GET_LINE:

  Select

    /*****************************************************************/
    /* For MVS(TSO/E), use EXECIO to read the line.                  */
    /*****************************************************************/
    When system = 'TSO' Then
      Do
        If arg(1) = host_codepage_file Then
          dsfile = 'AFPIN'
        If arg(1) = windows_codepage_file Then
          dsfile = 'WININ'
        'EXECIO 1 DISKR' dsfile '(STEM INREC.'
        If RC > 0 Then
          in_rec = ''
        Else
          in_rec = inrec.1
      End

    /*****************************************************************/
    /* For VM (CMS), use EXECIO to read the line.                    */
    /*****************************************************************/
    When system = 'CMS' Then
      Do
        'EXECIO 1 DISKR' arg(1) '(VAR IN_REC'
        If RC = 2 Then
          in_rec = ''
      End

    /*****************************************************************/
    /* For OS/2, use LINEIN to read the line except for Binary files */
    /*****************************************************************/
    When system = 'CMD' Then
      Do
        If arg(1) = host_codepage_file Then   /* won't interpret hex  */
          in_rec = CHARIN(arg(1), ,1000)      /*  as printer controls */
        Else
          in_rec = LINEIN( arg(1) )
      End
  End

  Return in_rec

/*********************************************************************/
/* PUT_LINE:                                                         */
/*   This routine writes one line to the output file.  The line is   */
/*   passed as a parameter.                                          */
/*********************************************************************/
PUT_LINE:

  Select

    /*****************************************************************/
    /* For MVS(TSO/E), use EXECIO to write the line.                 */
    /*****************************************************************/
    When system = 'TSO' Then
      Do
        OUTREC.1 = arg(1)
        'EXECIO 1 DISKW MAPOUT (STEM OUTREC.'
        If rc = 1 Then
          Say ' Data truncated during Write operation'.
        Else If rc <> 0 Then
          Say ' Write to' output_file 'not working.'
      End

    /*****************************************************************/
    /* For VM (CMS), use EXECIO to write the line.                   */
    /*****************************************************************/
    When system = 'CMS' Then
      Do
        'EXECIO 1 DISKW' output_file '(STRING' arg(1)
        If rc > 4 Then
          Return error_return
      End

    /*****************************************************************/
    /* OS/2, use LINEOUT to write the line.                          */
    /*****************************************************************/
    When system = 'CMD' Then
      Do
        Call LINEOUT output_file, arg(1)
        If RESULT <> 0 Then Return error_return
      End
  End

  Return 0

/*********************************************************************/
/* EXTRACT_FILENAME:                                                 */
/*   This routine is used only for OS/2.  It extracts the filename   */
/*   from a fully-qualified path.  That path is passed as a          */
/*   parameter.                                                      */
/*********************************************************************/
EXTRACT_FILENAME:

  /*******************************************************************/
  /* Set the fully-qualified path name.                              */
  /*******************************************************************/
  fully_qualified_name = arg(1)

  /*******************************************************************/
  /* If the path name contains a backslash, the filename begins      */
  /* immediately after; if not, if the path name contains a colon,   */
  /* the filename begins immediately after; if not, the filename     */
  /* begins with the first character of the path.                    */
  /*******************************************************************/
  i = LASTPOS( '\', fully_qualified_name )
  If i = 0 Then
    i = POS( ':', fully_qualified_name )
  i = i + 1

  /*******************************************************************/
  /* If the path name contains a period, the filename ends immed-    */
  /* iately before it; if not, the filename ends with the last char- */
  /* acter of the path.                                              */
  /*******************************************************************/
  j = POS( '.', fully_qualified_name, i )
  If j = 0 Then
    Do
      filename = SUBSTR( fully_qualified_name, i )
    End
  Else
    Do
      name_len = j - i
      filename = SUBSTR( fully_qualified_name, i, name_len )
    End

  Return filename

/*********************************************************************/
/* DS_ALLOC:                                                         */
/*   This routine is used only for MVS.  It checks to see if a data  */
/*   set exists.  If it does, it allocates it.                       */
/*********************************************************************/
DS_ALLOC:

  If SYSDSN(data_set) = 'OK' Then
    Do
     "ALLOC DA("data_set") FILE("ddnam") SHR REUSE"
      If RC <> 0 Then
        Do
          Say 'Allocation of data set' data_set 'failed, rc='rc
          Return error_return
        End
    End
  Else
    Do
      Say 'Data set' data_set 'cannot be found'
      Return error_return
    End

  Return 0

/*********************************************************************/
/* PREPARE_XLATE_TABLES:                                             */
/*   This routine is used only for OS/2.  It initializes ASCII and   */
/*   EBCDIC translation tables.                                      */
/*********************************************************************/
PREPARE_XLATE_TABLES:

  ascii  = 'abcdefghijklmnopqrstuvwxyz' ||,
           'ABCDEFGHIJKLMNOPQRSTUVWXYZ' ||,
           '1234567890' ||,
           ' @#$'

  ebcdic = '818283848586878889919293949596979899A2A3A4A5A6A7A8A9'x ||,
           'C1C2C3C4C5C6C7C8C9D1D2D3D4D5D6D7D8D9E2E3E4E5E6E7E8E9'x ||,
           'F1F2F3F4F5F6F7F8F9F0'x ||,
           '407C7B5B'x

  Return 0

/*********************************************************************/
/* Do any need clean up and exit the program.                        */
/*********************************************************************/
CLEAN_UP:

rc_out = arg(1)

If system = 'TSO' Then
  Do
    "EXECIO 0 DISKR AFPIN (FINIS"
    "EXECIO 0 DISKR WININ (FINIS"
    "EXECIO 0 DISKW MAPOUT (FINIS"
    "FREE FILE(AFPIN WININ MAPOUT)"
    If rc <> 0 Then
      Say ' Attempted to free data sets used -- RC=' rc
  End

If rc_out <> 0 Then
  Say ' Exiting with an error ' rc_out

Exit rc_out
