/*==========================================================================*/
/* EJREXIT.C           IBM BookManager Read for Windows                     */
/*                                                                          */    
/* USER EXIT ROUTINES - this "C" file is supplied as sample code for use    */
/* with BookManager Read for Windows.  This code was used in the creation of*/    
/* the user exit DLL - EJREXIT.DLL. As shipped this DLL will accept a call  */    
/* to the user exit and provide a valid return code.  There is NO FUNCTION  */    
/* provided.  Users that do not wish to use user exits must keep the        */    
/* EJREXIT.DLL as Read for Windows will call the exits, but do not need     */    
/* EJREXIT.H or EJREXIT.C which are only used to change the EJREXIT.DLL.    */    
/*                                                                          */    
/* Users wishing to make use of the supplied user exits must alter or       */    
/* replace this file and use EJREXIT.H to create a Windows DLL file.  The   */    
/* DLL MUST be named EJREXIT.DLL, must reside in the same directory as the  */
/* original EJREXIT.DLL, and must provide valid entry points and valid      */
/* return codes for each exit that exits in the original EJREXIT.DLL.       */
/* Also, each user exit may have specific restrictions and/or requirements  */
/* which should be fully understood before altering the code and rebuilding */
/* the DLL.  IBM does not support user created or user altered code.        */
/*                                                                          */    
/*                                                                          */    
/* See the documentation for complete information on creating and using     */    
/* user exits with Read for Windows.                                        */    
/*                                                                          */    
/* MDW94                                                                    */    
/*==========================================================================*/
#include <windows.h>
#include "ejrexit.h"

/* The WEP and LibMain functions below are required for DLL support and */
/* should be left in place unless they will provided for by some other  */
/* place unless the user intends to provide for these functions by some */
/* other method.                                                        */
int FAR PASCAL _export WEP (int);

int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, 
						WORD wHeapSize, LPSTR lpszCmdLine)
	{
	if (wHeapSize > 0)
		UnlockData (0);
	return 1;
	}

int FAR PASCAL _export WEP (int nParam)
	{
	return 1;
	}
		
/* User exits are defined below.  The entry points are required to remain */
/* as provided to insure compatibility with Read for Windows.  The        */
/* functional code is open to the user.  Please note the requirements     */
/* and see the user documentation for further information.                */

/* EJROpenBookExit - this exit is called whenever a book is opened for    */
/*                   reading.  This exit accepts an EJRBOOKINFO struct    */
/*                   as input, but provides only a return code to the     */
/*                   caller.  The contents of pBookDataParm are static.   */
/* NOTE: Though a valid value must be provided as a return, it will not   */
/*     be used for any significant processing in this release of Read for */
/*     Windows.                                                           */
short FAR PASCAL _export EJROpenBookExit (struct EJRBOOKINFO pBookDataParm)
{
 
    /* User Code is placed here */

	return 0;   /* A valid return value is required. */
}


/* EJRCloseBookExit - this exit is called whenever an open book is closed.*/
/*                   This exit accepts an EJRBOOKINFO struct as input,    */
/*                   but provides only a return code to the caller.       */
/*                   The contents of pBookDataParm are static.            */
/* NOTE: Though a valid value must be provided as a return, it will not   */
/*    be used for any significant processing in this release of Read for  */
/*    Windows.                                                            */
short FAR PASCAL _export EJRCloseBookExit (struct EJRBOOKINFO pBookDataParm)
{
    /* User Code is placed here */

	return 0;   /* A valid return value is required. */
}


/* EJRSearchExit - this exit is called whenever a search is executed from */
/*                 within a book.  It accepts an EJRSEARCHINFO struct     */
/*                 as input, the values of which CAN BE ALTERED by this   */
/*                 routine and are then returned to the caller along with */
/*                 a return code.  NOTE: Read will use the returned       */
/*                 search argument AS IS.  Only valid search strings      */
/*                 should be returned.  The user is responsible for       */
/*                 insuring the validity of the returned value.           */
/* NOTE: Though a valid value must be provided as a return, it will not   */
/*       used for any significant processing in this release of Read for  */
/*       Windows.                                                         */
short FAR PASCAL _export EJRSearchExit (struct EJRSEARCHINFO far * pSearchParm)
{
    /* User Code is placed here */

	return 0;   /* A valid return value is required. */
}
    
    
	   			