'
'   BBIB.BAS - BASIC portion of interface for BASIC applications using NI488.C
'
'   Contains calls to CBIC.C.
'

'  Status variables to be updated by CBIB.C

COMMON SHARED /nistatblk/ ibsta%, iberr%, ibcnt%

'  CBIB.C functions

DECLARE SUB cibstr(BYVAL ibfn%, ud%, BYVAL straddr%, ibsta%, iberr%, ibcnt%)
DECLARE SUB cib2 (BYVAL ibfn%,ud%,v%,ibsta%,iberr%,ibcnt%)
DECLARE SUB cib1 (BYVAL ibfn%,ud%,ibsta%,iberr%,ibcnt%)
DECLARE SUB cibbuf (BYVAL ibfn%, ud%, BYVAL nameaddr%,BYVAL cnt%,ibsta%,iberr%,ibcnt%)
DECLARE FUNCTION cibfind% (BYVAL nameaddr%, ibsta%,iberr%,ibcnt%)
DECLARE SUB cibpoll (BYVAL ibfn%,ud%,response%,ibsta%,iberr%,ibcnt%)

'  NI488 function codes

CONST NIBNA   = 0
CONST NICAC   = 1
CONST NICLR   = 2
CONST NICMD   = 3
CONST NICMDA  = 4
CONST NIDMA   = 5
CONST NIEOS   = 6
CONST NIEOT   = 7
CONST NIGTS   = 8
CONST NIIST   = 9
CONST NILOC   = 10
CONST NIONL   = 11
CONST NIPAD   = 12
CONST NIPCT   = 13
CONST NIPPC   = 14
CONST NIRD    = 15
CONST NIRDA   = 16
CONST NIRDF   = 17
CONST NIRPP   = 18
CONST NIRSC   = 19
CONST NIRSP   = 20
CONST NIRSV   = 21
CONST NISAD   = 22
CONST NISIC   = 23
CONST NISRE   = 24
CONST NITMO   = 25
CONST NITRG   = 26
CONST NIWAIT  = 27
CONST NIWRT   = 28
CONST NIWRTA  = 29
CONST NIWRTF  = 30

'  Calls to CBIB.C

SUB bibbna (ud%, name$)
	udname$ = name$ + CHR$(0)
	CALL cibstr(NIBNA, ud%, SADD(udname$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibcac( ud%, v%)
	CALL cib2(NICAC, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibclr( ud%)
	CALL cib1(NICLR, ud%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibcmd(ud%, cmd$)
	CALL cibbuf(NICMD, ud%, SADD(cmd$), LEN(cmd$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibcmda(ud%, cmd$)
	CALL cibbuf(NICMDA, ud%, SADD(cmd$), LEN(cmd$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibdma( ud%, v%)
	CALL cib2(NIDMA, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibeos( ud%, v%)
	CALL cib2(NIEOS, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibeot( ud%, v%)
	CALL cib2(NIEOT, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

FUNCTION bibfind%( name$ )
	udname$ = name$ + chr$(0)
	ud% = cibfind%( SADD(udname$), ibsta%, iberr%, ibcnt%)
	bibfind% = ud%
END FUNCTION

SUB bibgts( ud%, v%)
	CALL cib2(NIGTS, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibist( ud%, v%)
	CALL cib2(NIIST, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibloc( ud%)
	CALL cib1(NILOC, ud%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibonl( ud%, v%)
	CALL cib2(NIONL, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibpad( ud%, v%)
	CALL cib2(NIPAD, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibpct( ud%)
	CALL cib1(NIPCT, ud%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibppc( ud%, v%)
	CALL cib2(NIPPC, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrd(ud%, rd$)
	CALL cibbuf(NIRD, ud%, SADD(rd$), LEN(rd$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrdi(ud%, rd%(), cnt%)		  'Treated as IBRD in CBIB
	CALL cibbuf(NIRD, ud%, VARPTR(rd%(0)), cnt%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrda(ud%, rd$)
	CALL cibbuf(NIRDA, ud%, SADD(rd$), LEN(rd$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrdia(ud%, rd%(), cnt%)		  'Treated as IBRDA in CBIB
	CALL cibbuf(NIRDA, ud%, VARPTR(rd%(0)), cnt%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrdf(ud%, file$)
	filename$ = file$ + chr$(0)
	CALL cibstr(NIRDF, ud%, SADD(filename$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrpp( ud%, ppr%)
	CALL cibpoll(NIRPP, ud%, ppr%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrsc( ud%, v%)
	CALL cib2(NIRSC, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrsp( ud%, spr%)
	CALL cibpoll(NIRSP, ud%, spr%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibrsv( ud%, v%)
	CALL cib2(NIRSV, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibsad( ud%, v%)
	CALL cib2(NISAD, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibsic(ud%)
	CALL cib1(NISIC, ud%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibsre( ud%, v%)
	CALL cib2(NISRE, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibstop( ud%)		 'IBSTOP is a NOOP
END SUB

SUB bibtmo( ud%, v%)
	CALL cib2(NITMO, ud%, v%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibtrg( ud%)
	CALL cib1(NITRG, ud%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwait( ud%, mask%)
	CALL cib2(NIWAIT, ud%, mask%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwrt(ud%, wrt$)
	CALL cibbuf(NIWRT, ud%, SADD(wrt$), LEN(wrt$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwrti(ud%, wrt%(), cnt%)			     'Treated as IBWRT in CBIB
	CALL cibbuf(NIWRT, ud%, VARPTR(wrt%(0)), cnt%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwrta(ud%, wrt$)
	CALL cibbuf(NIWRTA, ud%, SADD(wrt$), LEN(wrt$), ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwrtia(ud%, wrt%(), cnt%) 		      'Treated as IBWRTA in CBIB
	CALL cibbuf(NIWRTA, ud%, VARPTR(wrt%(0)), cnt%, ibsta%, iberr%, ibcnt%)
END SUB

SUB bibwrtf(ud%, file$)
	filename$ = file$ + chr$(0)
	CALL cibstr(NIWRTF, ud%, SADD(filename$), ibsta%, iberr%, ibcnt%)
END SUB
