' Microsoft BASIC NI Example Program - Board Level

' This sample program is for reference only. It can only be expected to
' function with a Fluke 8840 Digital Multimeter that has been properly
' configured in IBCONF.

REM $INCLUDE: 'BSEDOSFL.BI'
REM $INCLUDE: 'NICODE.BAS'

' Begin

' Open board 0 as #1.

	ON ERROR GO TO ErrOpen

	OPEN "GPIB0" FOR BINARY AS #1


' Get the board's OS/2 file handle.

	brd0% = FILEATTR(1,2)

	ON ERROR GO TO ErrSub

' Send Interface Clear.

	RetCode% = DosDevIOCtl%( 0,0,0,0, SENDIFC, CATEGORY, brd0%)

'  Turn on the Remote Enable (REN) signal.

	RetCode% = DosDevIOCtl%( 0,0,0,0, SETREMOTE, CATEGORY, brd0%)

'  Inhibit front panel control with the Local Lockout (LLO) command (hex 11).
'  Place the device in remote mode by addressing it to listen. The listen
'  address of device three is its primary address, 3, plus hex 20.  This is an
'  ASCII "#".  Send the Device Clear (DCL) message (hex 14) to clear internal
'  device functions.  Finally, address the GPIB0 to talk by sending its talk
'  address, the pad 0 plus hex 40, or ASCII "@".  These commands can be found
'  in Appendix A of the Software Reference Manual.

	cmdstr$ = CHR$(&H11) + "#" + CHR$(&H14) + "@"	'LLO DLA3 DCL MTA0
	cnt% = 4
	RetCode% = DosDevIOCtl%( VARSEG(cmdstr$),SADD(cmdstr$),_
				VARSEG(cnt%),VARPTR(cnt%),    _
				CMD,CATEGORY,brd0%)
'
' Write the function, range, and trigger source instructions to the device.
'  This string is meaningful to the Fluke 8840 Digital Multimeter.

	wrt$ = "F3R7T3" : PUT #1, 1, wrt$

'  Send the GGET (hex 8) message to trigger a measurement reading.

	cmdstr$ = CHR$(GGET)
	cnt% = 1
	RetCode% = DosDevIOCtl%( VARSEG(cmdstr$),SADD(cmdstr$),_
				VARSEG(cnt%),VARPTR(cnt%),    _
				CMD,CATEGORY,brd0%)
'  
' Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).
' Descriptions of these status bits are listed in NICODE.BAS.  If
' the current time limit is too short, use BTempWrt to change it.

	mask% = BTIMO OR BSRQ
	RetCode% = DosDevIOCtl%( 0,0,_
		VARSEG(mask%), VARPTR(mask%), BWAIT, CATEGORY, brd0%)

'  If neither a timeout nor an error occurred, IBWAIT must have returned
'  on SRQ.  Next do a serial poll.  First unaddress bus devices by sending
'  the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)
'  command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)
'  command (hex 18) and the DVM's talk address (device three's pad, 3, plus
'  hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,
'  or ASCII space).  These commands can be found in Appendix A of the Software
'  Reference Manual.

	cmdstr$ = "_?" + CHR$(SPE) + "C "	'UNT, UNL, SPE, MTA3, MLA0
	cnt% = 5
	RetCode% = DosDevIOCtl%( VARSEG(cmdstr$),SADD(cmdstr$),_
				VARSEG(cnt%),VARPTR(cnt%),    _
				CMD,CATEGORY,brd0%)

'  Now read the status byte.  If it is &HC0, the device has valid data to send;
'  otherwise,  it has a fault condition to report.

	rd$ = SPACE$(1)
	RetCode% = DosRead%( brd0%, VARSEG(rd$), SADD(rd$), 1, cnt%)
	IF ASC(rd$) <> &HC0 THEN PRINT "Fault condition"

'  If more than one device were attached to the bus, it would be necessary to
'  explicitly check the &H40 bit of the device status word to be sure that
'  another device had not been responsible for asserting SRQ.  Complete the
'  serial poll by sending the Serial Poll Disable (SPD) message (hex 19).

	cmdstr$ = CHR$(&H19)			'SPD
	cnt% = 1
	RetCode% = DosDevIOCtl%( VARSEG(cmdstr$),SADD(cmdstr$),_
				VARSEG(cnt%),VARPTR(cnt%),    _
				CMD,CATEGORY,brd0%)
'
' If the data is valid, read the measurement.
'  
	rd$ = SPACE$(16)
	RetCode% = DosRead%( brd0%, VARSEG(rd$), SADD(rd$), 16, cnt%)


' Close board 0

	CLOSE 1

END

'      A routine at this location would report the failure to open the board,
'      and would refer you to driver software configuration procedures.

ErrOpen:
	PRINT "Unable to open board"
	ON ERROR GO TO 0

'      An error checking routine at this location would, among other things,
'      check board status to determine the exact cause of the error condition
'      and then take action appropriate to the application.  For errors during
'      DosRead or DosWrite, cnt may be examined to determine the actual number
'      of bytes transferred.

ErrSub:
	PRINT "GPIB ERROR" : RESUME NEXT
