* Microsoft FORTRAN - NI-488 Board Level Sample Program
*
* This sample program is for reference only. It can only be expected to
* function with a Fluke 8840 Digital Multimeter that has been properly
* configured in IBCONF.
*

$include: 'decl.for'

* Variables taken from DECL.FOR:

       character    rd(512),wrt(512)
       integer*1    cmd(10)
       integer*2    mask
       integer*2    ud
 

*
*  Assign a unique identifier to the interface board GPIB0:
*
		ud = ibfind ('GPIB0'C)
*
*	Note: Character string constants must be of type C so that the NI488
*	      interface will recognize the end of string.  This applies to the
*	      device names for IBFIND and IBBNA, and to the filenames for
*	      IBWRTF and IBRDF.  An alternative is for you to directly append
*	      a null character to the string.
*
*  Check for IBFIND error:
*
		if (ud .LT. 0) call finder
*
*  Send the Interface Clear (IFC) message to all devices:
*
		call ibsic (ud)
*
*  Check for an error on each GPIB call to be safe:
*
		if (ibsta .LT. 0)  call error( ibsta, iberr, ibcnt)
*
*  Turn on the Remote Enable (REN) signal:
*
		call ibsre (ud,1)
		if (ibsta .LT. 0)  call error( ibsta, iberr, ibcnt)
*
*  Inhibit front panel control with the Local Lockout (LLO) command (hex 11).
*  Place the device in remote mode by addressing it to listen. The listen address
*  of device three is its primary address, 3, plus hex 20.  This is an ASCII
*  "#".  Send the Device Clear (DCL) message (hex 14) to clear internal device
*  functions.  Finally, address the GPIB0 to talk by sending its talk address,
*  the pad 0 plus hex 40, or ASCII "@".  These commands can be found in Appendix
*  A of the Software Reference Manual.
*
		cmd(1) = LLO
		cmd(2) = #23
		cmd(3) = DCL
		cmd(4) = #40
		call ibcmd (ud,cmd,4)
		if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Write the function, range, and trigger source instructions to the device.
*  Use alternative character-type buffer.  These instructions are meaningful
*  to the Fluke 8840 Digital Multimeter.
*
		wrt(1) = 'F'
		wrt(2) = '3'
		wrt(3) = 'R'
		wrt(4) = '7'
		wrt(5) = 'T'
		wrt(6) = '3'
		call ibwrt (ud,wrt,6)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Send the GET message (hex 8) to trigger a measurement reading:
*
                cmd(1) = GET
		call ibcmd (ud,cmd,1)
                if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Wait for the device to set SRQ (hex 1000) or for a timeout (hex 4000).
*  These status bits are listed in Section Four of the Software Reference
*  manual.  If the current time limit is too short, use IBTMO to change it.
*
	        mask = ior (TIMO,SRQI)
		call ibwait (ud,mask)
	        if ( (iand(ibsta,TIMO) .EQ. 1) .OR. (ibsta.LT.0)) then
			call error( ibsta, iberr, ibcnt)
		endif
*
*  If neither a timeout nor an error occurred, IBWAIT must have returned
*  on SRQ.  Next do a serial poll.  First unaddress bus devices by sending
*  the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)
*  command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)
*  command (hex 18) and the device's talk address (device three's pad, 3, plus
*  hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,
*  or ASCII space).  These commands can be found in Appendix A of the Software
*  Reference Manual.
*
 	        cmd(1) = UNT
		cmd(2) = UNL
	        cmd(3) = SPE 
		cmd(4) = #43 
	        cmd(5) = #20
		call ibcmd (ud,cmd,5)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Now read the status byte. If it is 192, the device has valid data to
*  end, otherwise it has a fault condition to report:
*
		call ibrd (ud,rd,1)
		if (rd(1) .NE. char(192)) call dvmerr
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  If more than one device were attached to the bus, it would be necessary
*  to explicitly check the hex 40 bit of the device status word to be sure
*  that another device hadn't been responsible for asserting SRQ. Complete
*  the serial poll by sending the Serial Poll Disable (SPD) message (hex 19).
*  These commands can be found in Appendix A of the Software Reference Manual.
*
                cmd(1) = SPD
		call ibcmd (ud,cmd,1)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Since the device and the board are still addressed to talk and listen,
*  the measurement can be read as follows:
*
		call ibrd (ud,rd,16)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  To close out a programming sequence, send IFC to initialize the bus and
*  call the IBONL function to disable the hardware and software:
*
		call ibsic (ud)
		call ibonl (ud, 0)

	stop
	end

*------------------------------------------------------------------------------
*
*	This routine would notify you that the IBFIND call failed, and would
*	refer you to the handler software configuration procedures.

	subroutine finder

	  write (*,*) 'Find error.'

	return
	end

*------------------------------------------------------------------------------
*
*	This subroutine would, among other things, check IBERR to determine
*	the exact cause of the error condition and then take action appropriate
*	to the application.  For errors during data transfer, IBCNT may be
*	examined to determine the actual number of bytes transferred.

	subroutine error( ibsta, iberr, ibcnt)

	  logical Count, NoCount, Previous, NoPrevious
	  parameter (Count=.TRUE., NoCount=.FALSE., 
     .		     Previous=.TRUE., NoPrevious=.FALSE.)

	  call trace(ibsta, iberr, ibcnt, NoCount, NoPrevious)

	return
	end

*------------------------------------------------------------------------------
*
*	This routine would analyze the fault code returned in the device's
*	status byte and take appropriate action.

	subroutine dvmerr

	  write (*,*) 'device error.'

	return
	end

*------------------------------------------------------------------------------
*
*	This routine prints the mnemonics associated with the status variables
*	returned from a GPIB function call.

	subroutine trace(ibsta, iberr, ibcnt, Prtcnt, Previous)

*  These logicals specify whether to print count and/or previous value:
	logical Prtcnt, Previous

	integer ERR, EDVR
	parameter( ERR=#8000, EDVR=0 )

	character*(4) statbits(16) / 'dcas', 'dtas', 'lacs', 'tacs', 
     .	'atn ', 'cic ', 'rem ', 'lok ', 'cmpl', '?   ', '?   ', '?   ',
     .  'srqi', 'end ', 'timo', 'err '/

	character*(4) errcode(17) / 'edvr', 'ecic', 'enol', 'eadr', 
     .	'earg', 'esac', 'eabo', 'eneb', '?   ', '?   ', 'eoip', 'ecap',
     . 'efso', '?   ', 'ebus', 'estb', 'esrq'/


	write(*,7) ibsta
  7	format(1X,'ibsta = #',Z4\,' (')
	do 10, i=15,0,-1	
		if (iand(ibsta,ishft(1,i)) .NE. 0) then
			write(*,'(A,A\)') ' ',statbits(i+1)
		endif
 10	continue
	write(*,'(A2\)')  ' )'
	if (iand(ibsta,ERR) .NE. 0) then
		write(*,27) errcode(iberr+1)
 27		format(2x,'iberr=',A\)
		if ((iand(iberr,EDVR) .NE. 0) .AND. (Prtcnt)) then
			write(*,37) ibcnt
 37			format(', ibcnt=',I4)
		else
			write(*,'()')
		endif
	else
		if (Previous) then
			write(*,47) iberr
 47			format(/,' Previous value=#',z4\)
		endif
		if (Prtcnt) then
			write(*,37) ibcnt
 57			format(', ibcnt=',I4)
		else
			write(*,'()')
		endif
	endif
	return 
	end

