* Microsoft FORTRAN Sample Program - NI Board Level Functions

* This sample program is for reference only. It can only be expected to
* function with a Fluke 8840 Digital Multimeter that has been properly
* configured in IBCONF.

$include: 'nicode.for'

* Variables:

*  RetCode		   return code from API calls
*  cnt			   I/O count
*  brd0 		   board 0 device handle
*  action		   action taken by DosOpen
*  mask 		   event mask for WAIT
*  cmdbuf(20)		   buffer for GPIB commands
*  wrt(256), rd(256)	   I/O data buffers
*  udname		   board 0 symbolic name

	integer*2 RetCode
	integer*2 cnt
	integer*2 brd0
	integer*2 action
	integer*2 mask
	integer*1 cmdbuf(20)
	character wrt(256), rd(256)
	character*8 udname


* Begin

* Open GPIB0.

	data udname(1:5) /'gpib0'C/
	RetCode = DosOpen(locfar(udname), brd0, action, 0, RdOnly,
     .		   OpenTrunc, RdWrDN, RESERVED)
	if (RetCode .ne. 0) call erropen

* Send Interface Clear.

	RetCode = DosDevIOCtl(LOCNULL, LOCNULL, SENDIFC, CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr

*  Turn on the Remote Enable (REN) signal.

	RetCode = DosDevIOCtl(LOCNULL, LOCNULL, SETREMOTE, CATEGORY,
     .			brd0)
	if (RetCode .ne. 0) call gpiberr

*  Inhibit front panel control with the Local Lockout (LLO) command (hex 11).
*  Place the device in remote mode by addressing it to listen. The listen address
*  of device three is its primary address, 3, plus hex 20.  This is an ASCII
*  "#".  Send the Device Clear (DCL) message (hex 14) to clear internal device
*  functions.  Finally, address the GPIB0 to talk by sending its talk address,
*  the pad 0 plus hex 40, or ASCII "@".  These commands can be found in Appendix
*  A of the Software Reference Manual.

	cmdbuf(1) = LLO
	cmdbuf(2) = #23
	cmdbuf(3) = DCL
	cmdbuf(4) = #40
	cnt = 4
	RetCode = DosDevIOCtl( locfar(cmdbuf), locfar(cnt), CMD,
     .		      CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr
*
* Write the function, range, and trigger source instructions to the device.
* These instructions are meaningful to the Fluke 8840 Digital Multimeter.

	wrt(1) = 'F'
	wrt(2) = '3'
	wrt(3) = 'R'
	wrt(4) = '7'
	wrt(5) = 'T'
	wrt(6) = '3'
	RetCode = DosWrite(brd0, locfar(wrt), 6, cnt)
	if (RetCode .ne. 0) call gpiberr

*  Send the GGET message (hex 8) to trigger a measurement reading.

	cmdbuf(1) = GGET
	cnt = 1
	RetCode = DosDevIOCtl( locfar(cmdbuf), locfar(cnt), CMD,
     .		      CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr
*
* Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).
* Descriptions of these status bits are listed in NICODE.BAS.  If
* the current time limit is too short, use BTempWrt to change it.

	mask = ior (BTIMO,BSRQ)
	RetCode = DosDevIOCtl(LOCNULL, locfar(mask), BWAIT,
     .		      CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr

*  If neither a timeout nor an error occurred, IBWAIT must have returned
*  on SRQ.  Next do a serial poll.  First unaddress bus devices by sending
*  the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)
*  command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)
*  command (hex 18) and the DVM's talk address (device three's pad, 3, plus
*  hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,
*  or ASCII space).  These commands can be found in Appendix A of the Software
*  Reference Manual.

	cmdbuf(1) = UNT
	cmdbuf(2) = UNL
	cmdbuf(3) = SPE
	cmdbuf(4) = #43
	cmdbuf(5) = #20
	cnt = 5
	RetCode = DosDevIOCtl( locfar(cmdbuf), locfar(cnt), CMD,
     .		      CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr
*
*  Now read the status byte.  If it is #C0, the device has valid data to send;
*  otherwise, it has a fault condition to report.

	RetCode = DosRead (brd0, locfar(rd), 1, cnt)
	if (ichar(rd(1)) .ne. #C0) write(*,*) ' Fault condition'
	if (RetCode .ne. 0) call gpiberr
*
*  If more than one device were attached to the bus, it would be necessary
*  to explicitly check the #40 bit of the device status word to be sure that
*  another device had not been responsible for asserting SRQ.  Complete the
*  serial poll by sending the Serial Poll Disable (SPD) message (hex 19).

	cmdbuf(1) = SPD
	cnt = 1
	RetCode = DosDevIOCtl( locfar(cmdbuf), locfar(cnt), CMD,
     .		      CATEGORY, brd0)
	if (RetCode .ne. 0) call gpiberr
*
* If the data is valid, read the measurement.
*
	RetCode = DosRead (brd0, locfar(rd), 16, cnt)
	if (RetCode .ne. 0) call gpiberr
*
*  For good measure, close the board.
*
	RetCode = DosClose(brd0)

	stop
	end

*      A routine at this location would report the failure to open the board,
*      and would refer you to driver software configuration procedures.

	subroutine erropen
	write(*,*) ' Unable to open board'
	return
	end
*
*      An error checking routine at this location would, among other things,
*      check board status to determine the exact cause of the error condition
*      and then take action appropriate to the application.  For errors during
*      DosRead and DosWrite, cnt may be examined to determine the actual
*      number of bytes transferred.

	subroutine gpiberr
	write(*,*) ' GPIB error'
	return
	end
