(** Microsoft Pascal NI Example Program - Board Level **)

(* This sample program is for reference only. It can only be expected to *)
(* function with a Fluke 8840 Digital Multimeter that has been properly  *)
(* configured in IBCONF.						 *)

program main (input,output);

{$include: 'nicode.pas'}
{$include: 'os2def.int'}
{$include: 'bsedos.int'}


var
	bdname		       : array [1..8] of char;	     (* device name  *)
	action		       : word;			     (* placeholder  *)
	RetCode 	       : word;			     (* return code  *)
	bd		       : word;			     (* device handle*)
	cnt		       : word;			     (* count	     *)
	mask		       : integer;		     (* WAIT mask    *)
	NulAddr 	       : adsmem;		     (* placeholder  *)
	wrt, rd, cmdbuf        : array [1..20] of char;      (* I/O buffers  *)

(*****************************************************************************)
(* This routine would notify you that the DosOpen call failed, and refer you *)
(* to the driver software configuration procedures.                          *)
(*****************************************************************************)

procedure finderr;

begin
  writeln (' Find error');
end;

(*****************************************************************************)
(* This routine would, among other things, check RetCode to determine the    *)
(* exact cause of the error condition & then take action appropriate to the  *)
(* application. 							     *)
(*****************************************************************************)

procedure error;

begin
  writeln (' Error');
end;

(*****************************************************************************)
begin
	bdname[1] := 'G';
	bdname[2] := 'P';
	bdname[3] := 'I';
	bdname[4] := 'B';
	bdname[5] := '0';
	RetCode := DosOpen(	ads(bdname),		       (* path	 *)
				bd,			       (* handle *)
				action, 		       (* action *)
				0,			       (* size	 *)
				RdOnly, 		       (* attrs  *)
				OpenTrunc,		       (* flag	 *)
				RdWrDN, 		       (* mode	 *)
				0);			       (* zero	 *)
	if (RetCode <> 0) then finderr;

(* Send the Interface Clear (IFC) message to all devices:                    *)

	NulAddr.s := 0;
	NulAddr.r := 0;
	RetCode := DosDevIOCtl(NulAddr, NulAddr, SENDIFC, CATEGORY, bd);

(* Check for an error on each GPIB call to be safe...                        *)

	if (RetCode <> 0) then error;

(* Turn on the Remote Enable (REN) signal:                                   *)

	RetCode := DosDevIOCtl(NulAddr, NulAddr, SETREMOTE, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* Inhibit front panel control with the Local Lockout (LLO) command (hex 11).	*)
(* Place the device in remote mode by addressing it to listen. The listen	*)
(* address of device three is its primary address, 3, plus hex 20.  This is an	*)
(* ASCII "#".  Send the Device Clear (DCL) message (hex 14) to clear internal	*)
(* device functions.  Finally, address the GPIB0 to talk by sending its talk	*)
(* address, the pad 0 plus hex 40, or ASCII "@".  These commands can be found	*)
(* in Appendix A of the Software Reference Manual.				*)


	cmdbuf[1] := chr(LLO);
	cmdbuf[2] := '#';
	cmdbuf[3] := chr(DCL);
	cmdbuf[4] := '@';
	cnt := 4;
	RetCode := DosDevIOCtl(ads(cmdbuf), ads(cnt), CMD, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* Write the function, range, and trigger source instructions to the device. *)
(* This string is meaningful to the Fluke 8840 Digital Multimeter.	     *)

	wrt[1] := 'F';
	wrt[2] := '3';
	wrt[3] := 'R';
	wrt[4] := '7';
	wrt[5] := 'T';
	wrt[6] := '3';
	RetCode := DosWrite(bd, ads(wrt), 6, cnt);
	if (RetCode <> 0) then error;

(* Send the GGET (hex 8) message to trigger a measurement reading:	     *)

	cmdbuf[1] := chr(GGET);
	cnt := 1;
	RetCode := DosDevIOCtl(ads(cmdbuf), ads(cnt), CMD, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).	     *)
(* Descriptions of these status bits are listed in NICODE.PAS.	If the	     *)
(* current time limit is too short, use BTempWrt to change it.		     *)

	mask := BTIMO OR BSRQ;
	RetCode := DosDevIOCtl(NulAddr, ads(mask), BWAIT, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* If neither a timeout nor an error occurred, IBWAIT must have returned       *)
(* on SRQ.  Next do a serial poll.  First unaddress bus devices by sending     *)
(* the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)      *)
(* command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)     *)
(* command (hex 18) and the DVM's talk address (device three's pad, 3, plus    *)
(* hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,      *)
(* or ASCII space).  These commands can be found in Appendix A of the Software *)
(* Reference Manual.							       *)

	cmdbuf[1] := chr(UNL);
	cmdbuf[2] := chr(UNT);
	cmdbuf[3] := chr(SPE);
	cmdbuf[4] := 'C';
	cmdbuf[5] := ' ';
	cnt := 5;
	RetCode := DosDevIOCtl(ads(cmdbuf), ads(cnt), CMD, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* Now read the status byte. If it is 16#C0, the device has valid data to    *)
(* send, otherwise it has a fault condition to report.			     *)

	RetCode := DosRead(bd, ads(rd), 1, cnt);
	if (RetCode <> 0) then error;
	if (ord(rd[1]) <> 16#C0) then error;

(* If more than one device were attached to the bus, it would be necessary to *)
(* explicitly check the &H40 bit of the device status word to be sure that    *)
(* another device had not been responsible for asserting SRQ.  Complete the   *)
(* serial poll by sending the Serial Poll Disable (SPD) message (hex 19).     *)

	cmdbuf[1] := chr(SPD);
	cnt := 1;
	RetCode := DosDevIOCtl(ads(cmdbuf), ads(cnt), CMD, CATEGORY, bd);
	if (RetCode <> 0) then error;

(* Since the device and GPIB board are still addressed to talk and listen,   *)
(* the measurement can be read as follows:				     *)

	RetCode := DosRead(bd, ads(rd), 16, cnt);
	if (RetCode <> 0) then error;

(* To close out a programming sequence, send IFC to initialize the bus and  *)
(* call the ONLINE function to disable the hardware and software:	    *)

	RetCode := DosDevIOCtl(NulAddr, NulAddr, SENDIFC, CATEGORY, bd);
	RetCode := DosDevIOCtl(NulAddr, NulAddr, ONLINE, CATEGORY, bd);
end.
