' Microsoft BASIC NI-488 Example Program - Device Level
'
' This sample program is for reference only. It can only be expected to
' function with a Fluke 8840 Digital Multimeter that has been properly
' configured in IBCONF.
'

DECLARE SUB finderr ()
DECLARE SUB gpiberr ()
DECLARE SUB dvmerror ()

REM $INCLUDE: 'decl.bas'

'  Assign a unique identifier to the DVM ("Digital Voltmeter") and store in
'  variable DVM%.

   bdname$ = "dvm"
   dvm% = ibfind%(bdname$)

'  Check for error on IBFIND call.

   IF dvm% < 0 THEN CALL finderr

'  Clear the device.

   CALL ibclr (dvm%)

'  Check for an error on each GPIB call to be safe.

   IF ibsta% < 0 THEN CALL gpiberr

'  Write the function, range, and trigger source instructions to the DVM.
'  This string is meaningful to the Fluke 8840 Digital Multimeter.

   wrt$ = "F3R7T3"
   CALL ibwrt (dvm%,wrt$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Trigger the device.

   CALL IBTRG (dvm%)
   IF ibsta% < 0 THEN CALL gpiberr

'  Wait for the DVM to set SRQ (hex 1000) or for a timeout (hex 4000).
'  These status bits are listed in Section Four of the Software Reference
'  manual.  If the current time limit is too short, use IBTMO to change it.

   mask% = TIMO OR SRQI
   CALL ibwait (dvm%,mask%)
   IF (ibsta% AND (EERR OR TIMO)) <> 0 THEN CALL gpiberr

'  If neither a timeout nor an error occurred, IBWAIT must have returned
'  on SRQ.  Next do a serial poll.

   CALL ibrsp (dvm%,spr%)
   IF ibsta% < 0 THEN CALL gpiberr

'  Now read the status byte.  If it is &HC0, the DVM has valid data to send;
'  otherwise, it has a fault condition to report.

   IF spr% <> &HC0 THEN CALL dvmerror

'  If the data is valid, read the measurement.

   rd$ = SPACE$(16)
   CALL ibrd (dvm%,rd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  To close out a programming sequence, call the IBCLR routine to clear device
'  functions and call the IBONL function to disable the hardware and software.

   CALL ibclr (dvm%)
   CALL ibonl (dvm%,(0%))
   END

'  A routine at this location would notify you that the IBFIND call failed,
'  and refer you to the handler software configuration procedures.

SUB finderr	 STATIC
   PRINT "IBFIND error"
END SUB

'  An error checking routine at this location would, among other things,
'  check iberr to determine the exact cause of the error condition and then
'  take action appropriate to the application.  For errors during data
'  transfers, ibcnt may be examined to determine the actual number of bytes
'  transferred.

SUB gpiberr	STATIC
   PRINT "GPIB ERROR"
END SUB

'  A routine at this location would analyze the fault code returned in the
'  DVM's status byte and take appropriate action.

SUB dvmerror	STATIC
   PRINT "dvm error"
END SUB


