/* C Example Program - NI Device Level Functions       */
/*
  This sample program is for reference only and can only be expected to
  function with a Fluke 8840 Digital Multimeter that has been properly
  configured in IBCONF.
*/

#include <fcntl.h>
#include <stdio.h>
#include "nicode.h"
#include <os2.h>
#include "nictl.h"


/* Error termination macros
 */
#define errck  if (RetCode) {printf("nictl error:%i", (char) RetCode); goto bye;}


main()
{
	int	dvm;			   /* device number	     */
	int	cnt;			   /* bytes read	     */
	int	response;		   /* serial poll response   */
	char	rd[16]; 		   /* buffer for read	     */
	int	RetCode;		   /* API call return code   */
	nidev	DevConf;		   /* device config structure*/
	int	mask = (BTIMO | BSRQ);	   /* wait mask 	     */


/* Assign a unique identifier to the DVM ("Digital Voltmeter") and store in
 * variable dvm. Exit on error.
 */
	dvm = open("DVM",O_RDWR);
	if (dvm == -1) {
		printf("Unable to open device");
		exit(1);
	}

/* Clear the device, check for error.
 */
	RetCode = nictl(dvm,DCLEAR,0,0);
	errck;

/* Write the function, range, and trigger source instructions to the device.
 * This string is meaningful to the Fluke 8840 Digital Multimeter.
 */
	write(dvm,"F3R7T3",6);

/* Trigger the device.
 */
	RetCode = nictl(dvm,TRIGGER,0,0);
	errck;

/* Change the device timeout & enable GPIB errors.
 */
	nictl(dvm,DTempRd,&DevConf,0);
	DevConf.timo = 20000;		      /* 20 seconds */
	DevConf.uflags |= UGPIB;
	nictl(dvm,DTempWrt,&DevConf,0);

/* Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).
 * These status constants are defined in NICODE.H.
 */

	RetCode = nictl(dvm,BWAIT,&mask,0);
	errck;

/*  Next, serial poll the device.
 */

	RetCode = nictl(dvm,SPOLL,&response,0);
	errck;

/* Now test the status byte (response).  If response is 0xC0, the device has
  valid data to send; otherwise, it has a fault condition to report.
*/

	if (response != 0xC0) printf("Fault condition.");

/*
 * If the data is valid, read the measurement.
 */
	cnt = read(dvm,rd,16);

bye:

	close(dvm);
}
