' BASIC Declarations

' Common GPIB status variables

  COMMON SHARED /nistatblk/ ibsta%, iberr%, ibcnt%

' GPIB Commands

CONST UNL=  &H3f  ' GPIB unlisten command
CONST UNT=  &H5f  ' GPIB untalk command
CONST GTL=  &H01  ' GPIB go to local
CONST SDC=  &H04  ' GPIB selected device clear
CONST PPC=  &H05  ' GPIB parallel poll configure
CONST GGET= &H08  ' GPIB group execute trigger
CONST TCT=  &H09  ' GPIB take control
CONST LLO=  &H11  ' GPIB local lock out
CONST DCL=  &H14  ' GPIB device clear
CONST PPU=  &H15  ' GPIB parallel poll unconfigure
CONST SPE=  &H18  ' GPIB serial poll enable
CONST SPD=  &H19  ' GPIB serial poll disable
CONST PPE=  &H60  ' GPIB parallel poll enable
CONST PPD=  &H70  ' GPIB parallel poll disable

' GPIB status bit vector :
'       status variable ibsta and wait mask

CONST EERR=    &H8000  ' Error detected
CONST TIMO=    &H4000  ' Timeout
CONST EEND=    &H2000  ' EOI or EOS detected
CONST SRQI=    &H1000  ' SRQ detected by CIC
CONST CMPL=    &H100   ' I/O completed
CONST LOK=     &H80    ' Local lockout state
CONST RREM=    &H40    ' Remote state
CONST CIC=     &H20    ' Controller-in-Charge
CONST AATN=    &H10    ' Attention asserted
CONST TACS=    &H8     ' Talker active
CONST LACS=    &H4     ' Listener active
CONST DTAS=    &H2     ' Device trigger state
CONST DCAS=    &H1     ' Device clear state

' Error messages returned in status variable iberr

CONST EDVR=  0	' DOS error
CONST ECIC=  1	' Function requires GPIB board to be CIC
CONST ENOL=  2	' Write function detected no listeners
CONST EADR=  3	' Interface board not addressed correctly
CONST EARG=  4	' Invalid argument to function call
CONST ESAC=  5	' Function requires GPIB board to be SAC
CONST EABO=  6	' I/O operation aborted
CONST ENEB=  7	' Non-existent interface board
CONST EOIP= 10	' I/O operation started before previous
		 ' operation completed
CONST ECAP= 11	' No capability for intended operation
CONST EFSO= 12	' File system operation error
CONST EBUS= 14	' Command error during device call
CONST ESTB= 15	' Serial poll status byte lost
CONST ESRQ= 16	' SRQ remains asserted

' EOS mode bits

CONST BIN=  &H1000  ' Eight bit compare
CONST XEOS= &H800   ' Send EOI with EOS byte
CONST REOS= &H400   ' Terminate read on EOS

' Timeout values and meanings

CONST TNONE=	0   ' Infinite timeout (disabled)
CONST T10us=	1   ' Timeout of 10 us (ideal)
CONST T30us=	2   ' Timeout of 30 us (ideal)
CONST T100us=	3   ' Timeout of 100 us (ideal)
CONST T300us=	4   ' Timeout of 300 us (ideal)
CONST T1ms=	5   ' Timeout of 1 ms (ideal)
CONST T3ms=	6   ' Timeout of 3 ms (ideal)
CONST T10ms=	7   ' Timeout of 10 ms (ideal)
CONST T30ms=	8   ' Timeout of 30 ms (ideal)
CONST T100ms=	9   ' Timeout of 100 ms (ideal)
CONST T300ms=  10   ' Timeout of 300 ms (ideal)
CONST T1s=     11   ' Timeout of 1 s (ideal)
CONST T3s=     12   ' Timeout of 3 s (ideal)
CONST T10s=    13   ' Timeout of 10 s (ideal)
CONST T30s=    14   ' Timeout of 30 s (ideal)
CONST T100s=   15   ' Timeout of 100 s (ideal)
CONST T300s=   16   ' Timeout of 300 s (ideal)
CONST T1000s=  17   ' Timeout of 1000 s (maximum)

' Miscellaneous

CONST S=    &H08    ' parallel poll sense bit
CONST LF=   &H0a    ' ASCII linefeed character

' GPIB Subroutine Declarations

DECLARE SUB ibbna ALIAS "bibbna" (bd%, bdname$)
DECLARE SUB ibcac ALIAS "bibcac" (bd%, v%)
DECLARE SUB ibclr ALIAS "bibclr" (bd%)
DECLARE SUB ibcmd ALIAS "bibcmd" (bd%, cmd$)
DECLARE SUB ibcmda ALIAS "bibcmda" (bd%, cmd$)
DECLARE SUB ibdma ALIAS "bibdma" (bd%, v%)
DECLARE SUB ibeos ALIAS "bibeos" (bd%, v%)
DECLARE SUB ibeot ALIAS "bibeot" (bd%, v%)
DECLARE FUNCTION ibfind% ALIAS "bibfind" (bdname$)
DECLARE SUB ibgts ALIAS "bibgts" (bd%, v%)
DECLARE SUB ibist ALIAS "bibist" (bd%, v%)
DECLARE SUB ibloc ALIAS "bibloc" (bd%)
DECLARE SUB ibonl ALIAS "bibonl" (bd%, v%)
DECLARE SUB ibpad ALIAS "bibpad" (bd%, v%)
DECLARE SUB ibpct ALIAS "bibpct" (bd%)
DECLARE SUB ibppc ALIAS "bibppc" (bd%, v%)
DECLARE SUB ibrd ALIAS "bibrd" (bd%, rd$)
DECLARE SUB ibrdi ALIAS "bibrdi" (bd%, rd%, cnt%)
DECLARE SUB ibrda ALIAS "bibrda" (bd%, rd$)
DECLARE SUB ibrdia ALIAS "bibrdia" (bd%, rd%, cnt%)
DECLARE SUB ibrdf ALIAS "bibrdf" (bd%, file$)
DECLARE SUB ibrpp ALIAS "bibrpp" (bd%, v%)
DECLARE SUB ibrsc ALIAS "bibrsc" (bd%, v%)
DECLARE SUB ibrsp ALIAS "bibrsp" (bd%, spr%)
DECLARE SUB ibrsv ALIAS "bibrsv" (bd%, v%)
DECLARE SUB ibsad ALIAS "bibsad" (bd%, v%)
DECLARE SUB ibsic ALIAS "bibsic" (bd%)
DECLARE SUB ibsre ALIAS "bibsre" (bd%, v%)
DECLARE SUB ibstop ALIAS "bibstop" (ud%)
DECLARE SUB ibtmo ALIAS "bibtmo" (bd%, v%)
DECLARE SUB ibtrg ALIAS "bibtrg" (bd%)
DECLARE SUB ibwait ALIAS "bibwait" (bd%, mask%)
DECLARE SUB ibwrt ALIAS "bibwrt" (bd%, wrt$)
DECLARE SUB ibwrti ALIAS "bibwrti" (bd%, wrt%, cnt%)
DECLARE SUB ibwrta ALIAS "bibwrta" (bd%, wrt$)
DECLARE SUB ibwrtia ALIAS "bibwrtia" (bd%, wrt%, cnt%)
DECLARE SUB ibwrtf ALIAS "bibwrtf" (bd%, file$)

