*	Include file for Microsoft FORTRAN OS/2 GPIB Applications

*		    define integers as two-byte quantities
$storage:2

	interface to subroutine ibbna [pascal] (ud, udname)
	integer*2 ud
	character*8 udname [reference, far]
	end

	interface to subroutine ibcac [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibclr [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibcmd [pascal] (ud, cmd, cnt)
	integer*2 ud
	integer*1 cmd  [reference, far]
	integer*2 cnt
	end

	interface to subroutine ibcmda [pascal] (ud, cmd, cnt)
	integer*2 ud
	integer*1 cmd  [reference, far]
	integer*2 cnt
	end

	interface to subroutine ibdma [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibeos [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibeot [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to integer*2 function ibfind [pascal] (udname)
	character*8 udname [reference, far]
	end

	interface to subroutine ibgts [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibist [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibloc [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibonl [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibpad [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibpct [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibppc [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibrd [pascal] (ud, rd, cnt)
	integer*2 ud
	character rd [reference,far]
	integer*2 cnt
	end

	interface to subroutine ibrda [pascal] (ud, rd, cnt)
	integer*2 ud
	character rd [reference,far]
	integer*2 cnt
	end

	interface to subroutine ibrdf [pascal] (ud, flname)
	integer*2 ud
	character*50 flname [reference, far]
	end

	interface to subroutine ibrpp [pascal] (ud, ppr)
	integer*2 ud
	integer*2 ppr  [reference, far]
	end

	interface to subroutine ibrsc [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibrsp [pascal] (ud, spr)
	integer*2 ud
	integer*2 spr  [reference, far]
	end

	interface to subroutine ibrsv [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibsad [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibsic [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibsre [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibstop [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibtmo [pascal] (ud, v)
	integer*2 ud
	integer*2 v
	end

	interface to subroutine ibtrg [pascal] (ud)
	integer*2 ud
	end

	interface to subroutine ibwait [pascal] (ud, mask)
	integer*2 ud
	integer*2 mask
	end

	interface to subroutine ibwrt [pascal] (ud, wrt, cnt)
	integer*2 ud
	character wrt [reference,far]
	integer*2 cnt
	end

	interface to subroutine ibwrta [pascal] (ud, wrt, cnt)
	integer*2 ud
	character wrt [reference,far]
	integer*2 cnt
	end

	interface to subroutine ibwrtf [pascal] (ud, flname)
	integer*2 ud
	character*50 flname [reference,far]
	end

*------------------------------------------------------------------------------
*
*  OPTIONALLY include the following declarations in your program:
*

*  GPIB Commands and Meanings:
*
*      UNL - GPIB unlisten command
*      UNT - GPIB untalk command
*      GTL - GPIB go to local
*      SDC - GPIB selected dev clear
*      PPC - GPIB parallel poll configure
*      GET - GPIB group execute trigger
*      TCT - GPIB take control
*      LLO - GPIB local lock out
*      DCL - GPIB device clear
*      PPU - GPIB parallel poll unconfigure
*      SPE - GPIB serial poll enable
*      SPD - GPIB serial poll disable
*      PPE - GPIB parallel poll enable
*      PPD - GPIB parallel poll disable

       integer*1 UNL, UNT, GTL, SDC, PPC, GET, TCT
       integer*1 LLO, DCL, PPU, SPE, SPD, PPE, PPD

       parameter( UNL=#3F,  UNT=#5F,  GTL=#1,   SDC=#4,  PPC=#5,
     . 		  GET=#08,  TCT=#09,  LLO=#11,  DCL=#14, PPU=#15,
     .  	  SPE=#18,  SPD=#19,  PPE=#60,  PPD=#70)

*  GPIB Status Bit Vector:
*
*      ERR  (hex 8000) - Error detected
*      TIMO (hex 4000) - Timeout
*      END  (hex 2000) - EOI or eos detected
*      SRQI (hex 1000) - SRQ detected by CIC
*      CMPL (hex  100) - I/O completed
*      LOK  (hex   80) - Local lockout state
*      REM  (hex   40) - Remote state
*      CIC  (hex   20) - Controller-in-charge
*      ATN  (hex   10) - Attention asserted
*      TACS (hex    8) - Talker active
*      LACS (hex    4) - Listener active
*      DTAS (hex    2) - Device trigger state
*      DCAS (hex    1) - Device clear state
 
       integer	 ERR,  TIMO,   END,  SRQI, CMPL, LOK
       integer   REM, CIC, ATN, TACS, LACS, DTAS, DCAS

       parameter( ERR=#8000, TIMO=#4000, END=#2000, SRQI=#1000,
     . CMPL=#100, LOK=#80,    REM=#40,	 CIC=#20,   ATN=#10,
     . TACS=#8,   LACS=#4,    DTAS=#2,	 DCAS=#1)

* Error Messages returned in IBERR:
*
*      EDVR = 0  - DOS error
*      ECIC = 1  - Function requires board to be CIC
*      ENOL = 2  - Write function detected no listeners
*      EADR = 3  - Interface board not addressed correctly
*      EARG = 4  - Invalid argument to function call
*      ESAC = 5  - Function requires board to be SAC
*      EABO = 6  - I/O operation aborted
*      ENEB = 7  - Non-existent interface board
*      EOIP = 10 - I/O operation started before previous operation completed
*      ECAP = 11 - No capability for operation
*      EFSO = 12 - File system operation error
*      EBUS = 14 - Command error during device call
*      ESTB = 15 - Serial Poll status byte lost
*      ESRQ = 16 - SRQ remains asserted
 
       integer  EDVR, ECIC, ENOL, EADR, EARG, ESAC, EABO
       integer  ENEB, EOIP, ECAP, EFSO, EBUS, ESTB, ESRQ

       parameter( EDVR=0,  ECIC=1,  ENOL=2,  EADR=3,  EARG=4,
     .		  ESAC=5,  EABO=6,  ENEB=7,  EOIP=10, ECAP=11,
     .		  EFSO=12, EBUS=14, ESTB=15, ESRQ=16)
*
*  EOS Mode Bits:
*
*      BIN   (hex 1000) - Eight bit compare
*      XEOS  (hex  800) - Send EOI with eos byte
*      REOS  (hex  400) - Terminate read on eos

       integer    BIN,       XEOS,      REOS
       parameter( BIN=#1000, XEOS=#800, REOS=#400)

*  Timeout Values and Meanings:
*
*      TNONE   =  0 - Infinite timeout	(disabled)
*      T10us   =  1 - Timeout of 10 us	(ideal)
*      T30us   =  2 - Timeout of 30 us	(ideal)
*      T100us  =  3 - Timeout of 100 us (ideal)
*      T300us  =  4 - Timeout of 300 us (ideal)
*      T1ms    =  5 - Timeout of 1 ms	(ideal)
*      T3ms    =  6 - Timeout of 3 ms	(ideal)
*      T10ms   =  7 - Timeout of 10 ms	(ideal)
*      T30ms   =  8 - Timeout of 30 ms	(ideal)
*      T100ms  =  9 - Timeout of 100 ms (ideal)
*      T300ms  = 10 - Timeout of 300 ms (ideal)
*      T1s     = 11 - Timeout of 1 s	(ideal)
*      T3s     = 12 - Timeout of 3 s	(ideal)
*      T10s    = 13 - Timeout of 10 s	(ideal)
*      T30s    = 14 - Timeout of 30 s	(ideal)
*      T100s   = 15 - Timeout of 100 s	(ideal)
*      T300s   = 16 - Timeout of 300 s	(ideal)
*      T1000s  = 17 - Timeout of 1000 s (maximum)

       integer TNONE,  T10us, T30us, T100us, T300us
       integer T1ms,   T3ms,  T10ms, T30ms,  T100ms
       integer T300ms, T1s,   T3s,   T10s,   T30s
       integer T100s,  T300s, T1000s

       parameter( TNONE=0,  T10us=1,   T30us=2, T100us=3, T300us=4,
     .		   T1ms=5,   T3ms=6,   T10ms=7,  T30ms=8, T100ms=9,
     .		 T300ms=10,   T1s=11,    T3s=12,  T10s=13,  T30s=14,
     .		  T100s=15, T300s=16, T1000s=17)

*  Miscellaneous:
*
*      S  - specifies sense of PPR
*      LF - ASCII line feed character

       integer    S,    LF
       parameter( S=08, LF=10)


*  Suggested variables for GPIB function calls:
*
*  You may change the data type of array elements at your convenience,
*  provided that you also retype the corresponding formal parameter, above.
*
*      cmd    - command buffer
*      rd     - read data buffer
*      wrt    - write data buffer
*      bname  - board name buffer
*      bdname - board or device name buffer
*      flname - file name buffer
*      bd     - board or device number
*      dvm    - device number
*      v      - "value" parameter
*      cnt    - byte count for transfers
*      mask   - events to be waited for
*      spr    - serial poll response byte
*      ppr    - parallel poll response byte
*
*      character    rd(512),wrt(512)
*      character*8  udname
*      character*50 flname
*      integer*1    cmd(10)
*      integer*2    ud,dvm,v,cnt,mask
*      integer*2    spr,ppr
*
*  Required variable declarations:

       integer*2 ibsta [C, extern]
       integer*2 iberr [C, extern]
       integer*2 ibcnt [C, extern]

       integer*2 ibfind
