(******************** IBM/Microsoft Pascal Declarations **********************)

Const

(* GPIB Commands:                                                            *)

   UNL  =  16#3f;                       (* GPIB unlisten command             *)
   UNT  =  16#5f;                       (* GPIB untalk command               *)
   GTL  =  16#01;                       (* GPIB go to local                  *)
   SDC  =  16#04;                       (* GPIB selected device clear        *)
   PPC  =  16#05;                       (* GPIB parallel poll configure      *)
   GET	=  16#08;			(* GPIB group execute trigger	     *)
   TCT  =  16#09;                       (* GPIB take control                 *)
   LLO  =  16#11;                       (* GPIB local lock out               *)
   DCL  =  16#14;                       (* GPIB device clear                 *)
   PPU  =  16#15;                       (* GPIB parallel poll unconfigure    *)
   SPE  =  16#18;                       (* GPIB serial poll enable           *)
   SPD  =  16#19;   			(* GPIB serial poll disable          *)
   PPE  =  16#60;   			(* GPIB parallel poll enable         *)
   PPD  =  16#70;   			(* GPIB parallel poll disable        *)

(* GPIB status bit vector:                                                   *)

   ERR   = 16#8000;			(* Error detected                    *)
   TIMO  = 16#4000;			(* Timeout                           *)
   UEND  = 16#2000;			(* EOI or EOS detected		     *)
   SRQI  = 16#1000;			(* SRQ detected by CIC               *)
   CMPL  = 16#100; 			(* I/O completed                     *)
   LOK   = 16#80;  			(* Local lockout state               *)
   REM   = 16#40;  			(* Remote state                      *)
   CIC   = 16#20;  			(* Controller-in-Charge              *)
   ATN   = 16#10;  			(* Attention asserted                *)
   TACS  = 16#8;   			(* Talker active                     *)
   LACS  = 16#4;   			(* Listener active                   *)
   DTAS  = 16#2;   			(* Device trigger state              *)
   DCAS  = 16#1;   			(* Device clear state                *)

(* Error messages returned in global variable IBERR:                         *)

   EDVR  = 0;                      (* DOS error                              *)
   ECIC  = 1; 		   	   (* Function requires GPIB board to be CIC *)
   ENOL  = 2;			   (* Write function detected no listeners   *)
   EADR  = 3; 		   	   (* Interface board not addressed correctly*)
   EARG  = 4; 		           (* Invalid argument to function call      *)
   ESAC  = 5; 		   	   (* Function requires GPIB board to be SAC *)
   EABO  = 6; 		   	   (* I/O operation aborted                  *)
   ENEB  = 7; 		   	   (* Non-existent interface board           *)
   EOIP  = 10;		   	   (* I/O operation started before previous  *)
		 		   (* operation completed                    *)
   ECAP  = 11;		   	   (* No capability for intended operation   *)
   EFSO  = 12;		   	   (* File system operation error            *)
   EBUS  = 14;		   	   (* Command error during device call       *)
   ESTB  = 15;		   	   (* Serial poll status byte lost           *)
   ESRQ  = 16;  		   (* SRQ remains asserted                   *)

(* EOS mode bits:                                                            *)

   BIN  = 16#1000;			(* Eight bit compare                 *)
   XEOS = 16#800; 			(* Send EOI with EOS byte            *)
   REOS = 16#400; 			(* Terminate read on EOS             *)


(* Timeout values and meanings:                                              *)

   TNONE    = 0;  			(* Infinite timeout  (disabled)      *)
   T10us    = 1;  			(* Timeout of 10 us  (ideal)         *)
   T30us    = 2;  			(* Timeout of 30 us  (ideal)         *)
   T100us   = 3;  			(* Timeout of 100 us (ideal)         *)
   T300us   = 4;  			(* Timeout of 300 us (ideal)         *)
   T1ms     = 5;  			(* Timeout of 1 ms   (ideal)         *)
   T3ms     = 6;  			(* Timeout of 3 ms   (ideal)         *)
   T10ms    = 7;  			(* Timeout of 10 ms  (ideal)         *)
   T30ms    = 8;  			(* Timeout of 30 ms  (ideal)         *)
   T100ms   = 9;  			(* Timeout of 100 ms (ideal)         *)
   T300ms   = 10; 			(* Timeout of 300 ms (ideal)         *)
   T1s      = 11; 			(* Timeout of 1 s    (ideal)         *)
   T3s      = 12; 			(* Timeout of 3 s    (ideal)         *)
   T10s     = 13; 			(* Timeout of 10 s   (ideal)         *)
   T30s     = 14; 			(* Timeout of 30 s   (ideal)         *)
   T100s    = 15; 			(* Timeout of 100 s  (ideal)         *)
   T300s    = 16; 			(* Timeout of 300 s  (ideal)         *)
   T1000s   = 17; 			(* Timeout of 1000 s (maximum)       *)

(* Miscellaneous:                                                            *)

   S  = 16#08;   			(* Parallel poll sense bit           *)
   LF = 16#0A;   			(* ASCII linefeed character          *)

{*****************************************************************************}

Type cbuf  = array[1..100] of char;
     nbuf  = string(8);
     flbuf = array[1..50] of char;

{*****************************************************************************}

{* You MUST include the following three variable declarations in your program *}

var [c, extern] ibsta : word;		   {* status word			*}
var [c, extern] iberr : word;		   {* GPIB error code			*}
var [c, extern] ibcnt : word;		   {* number of bytes sent or DOS error *}
   
{* Suggested variable declarations:					       *}
{*  cmd    : cbuf;			(* command buffer		     *)*}
{*  rd	   : cbuf;			(* read data buffer		     *)*}
{*  wrt    : cbuf;			(* write data buffer		     *)*}
{*  bname  : nbuf;			(* board name buffer		     *)*}
{*  bdname : nbuf;			(* device name buffer		     *)*}
{*  flname : flbuf;			(* file name buffer		     *)*}
{*  bd	   : integer;			(* board or device number	     *)*}
{*  dvm    : integer;			(* device number		     *)*}
{*  v	   : integer;			(* "value" parameter		     *)*}
{*  cnt    : integer;			(* byte count for transfers	     *)*}
{*  mask   : integer;			(* events to be waited for	     *)*}
{*  ppr    : char;			(* parallel poll response byte	     *)*}
{*  spr    : char;			(* serial poll response byte	     *)*}

{* You MUST include the appropriate extern declaration, as  given below, for *}
{* each procedure or function you call. 				     *}
{*									     *}
{* The GPIB board functions:						     *}

   procedure  ibbna  (bd:integer;vars bname:nbuf); extern;

   procedure  ibcac  (bd:integer;v:integer); extern;
		
   procedure  ibclr  (bd:integer); extern;

   procedure  ibcmd  (bd:integer;vars cmd:cbuf;cnt:integer); extern;

   procedure  ibcmda (bd:integer;vars cmd:cbuf;cnt:integer); extern;

   procedure  ibdma  (bd:integer;v:integer); extern;

   procedure  ibeos  (bd:integer;v:integer); extern;
	
   procedure  ibeot  (bd:integer;v:integer); extern;
	
   function   ibfind (vars bdname:nbuf):integer; extern;

   procedure  ibgts  (bd:integer;v:integer); extern;
			
   procedure  ibist  (bd:integer;v:integer); extern;
			
   procedure  ibloc  (bd:integer); extern;

   procedure  ibonl  (bd:integer;v:integer); extern;
		
   procedure  ibpad  (bd:integer;v:integer); extern;
		
   procedure  ibpct  (bd:integer); extern;

   procedure  ibppc  (bd:integer;v:integer); extern;
	
   procedure  ibrd   (bd:integer;vars rd:cbuf;cnt:integer); extern;

   procedure  ibrda  (bd:integer;vars rd:cbuf;cnt:integer); extern;

   procedure  ibrdf  (bd:integer;vars flname:flbuf); extern;
		
   procedure  ibrpp  (bd:integer;vars ppr:char); extern;
		
   procedure  ibrsc  (bd:integer;v:integer); extern;
			
   procedure  ibrsp  (bd:integer;vars spr:char); extern;
			
   procedure  ibrsv  (bd:integer;v:integer); extern;
		
   procedure  ibsad  (bd:integer;v:integer); extern;
		
   procedure  ibsic  (bd:integer); extern;

   procedure  ibsre  (bd:integer;v:integer); extern;
		
   procedure  ibstop (bd:integer); extern;

   procedure  ibtmo  (bd:integer;v:integer); extern;
		
   procedure  ibtrg  (bd:integer); extern;

   procedure  ibwait (bd:integer;mask:integer); extern;
			
   procedure  ibwrt  (bd:integer;vars wrt:cbuf;cnt:integer); extern;

   procedure  ibwrta (bd:integer;vars wrt:cbuf;cnt:integer); extern;

   procedure  ibwrtf (bd:integer;vars flname:flbuf); extern;

