* Microsoft FORTRAN - NI-488 Device Level Sample Program
*
* This sample program is for reference only. It can only be expected to
* function with a Fluke 8840 Digital Multimeter that has been properly
* configured in IBCONF.
*

$include: 'decl.for'

* Variables taken from DECL.FOR:

       character    rd(512),wrt(512)
       integer*2    dvm
       integer*2    mask
       integer*2    spr

*
*  Assign a unique identifier to the device DVM ("Digital Voltmeter").
*
		dvm = ibfind ('DVM'C)
*
*	Note: Character string constants must be of type C so that the NI488
*	      interface will recognize the end of string.  This applies to the
*	      device names for IBFIND and IBBNA, and to the filenames for
*	      IBWRTF and IBRDF.  An alternative is for you to directly append
*	      a null character to the string.
*
*  Check for IBFIND error:
*
		if (dvm .LT. 0) call finder
*
*  Clear the device:
*
		call ibclr (dvm)
*
*  Check for an error on each GPIB call to be safe:
*
		if (ibsta .LT. 0)  call error( ibsta, iberr, ibcnt)
*
*  Write the function, range, and trigger source instructions to the DVM.
*  This string is meaningful to the Fluke 8840 Digital Multimeter.
*
		wrt(1) = 'F'
		wrt(2) = '3'
		wrt(3) = 'R'
		wrt(4) = '7'
		wrt(5) = 'T'
		wrt(6) = '3'
		call ibwrt (dvm,wrt,6)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Trigger the device:
*
                call ibtrg (dvm)
                if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  Wait for the DVM to set SRQ (hex 1000) or for a timeout (hex 4000).
*  These status bits are listed in Section Four of the Software Reference
*  manual.  If the current time limit is too short, use IBTMO to change it.
*
		mask = ior( TIMO,SRQI )
	        call ibwait (dvm,mask)
	        if ( (iand(ibsta,TIMO) .EQ. 1) .OR. (ibsta.LT.0)) then
			call error( ibsta, iberr, ibcnt)
		endif
*
*  Since neither a timeout nor an error occured, IBWAIT must have returned
*  on SRQ.  Next do a serial poll of the device:
*
	        call ibrsp (dvm,spr)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  If the serial poll response is 192, the DVM has valid data to send,
*  otherwise it has a fault condition to report:
*
	 	if (spr .NE. 192) call dvmerr
*
*  Since the DVM and the board are still addressed to talk and listen, the
*  measurement can be read as follows:
*
 	        call ibrd (dvm,rd,16)
	        if (ibsta .LT. 0) call error( ibsta, iberr, ibcnt)
*
*  To close out a programming sequence, call the IBONL function to disable
*  the hardware and software:
*
	        call ibonl (dvm, 0)

	stop
	end

*------------------------------------------------------------------------------
*
*	This routine would notify you that the IBFIND call failed, and would
*	refer you to the handler software configuration procedures.

	subroutine finder


	  write (*,*) ' Find error.'

	return
	end

*------------------------------------------------------------------------------
*
*	This subroutine would, among other things, check IBERR to determine
*	the exact cause of the error condition and then take action appropriate
*	to the application.  For errors during data transfer, IBCNT may be ex-
*	amined to determine the actual number of bytes transfer.

	subroutine error( ibsta, iberr, ibcnt)

	  logical Count, NoCount, Previous, NoPrevious
	  parameter (Count=.TRUE., NoCount=.FALSE., 
     .		     Previous=.TRUE., NoPrevious=.FALSE.)

	  call trace(ibsta, iberr, ibcnt, NoCount, NoPrevious)

	return
	end

*------------------------------------------------------------------------------
*
*	This routine would analyze the fault code returned in the DVM's status
*	byte and take appropriate action.

	subroutine dvmerr

	  write (*,*) 'DVM error.'

	return
	end

*------------------------------------------------------------------------------
*
*	This routine prints the mnemonics associated with the status variables
*	returned from a GPIB function call.

	subroutine trace(ibsta, iberr, ibcnt, Prtcnt, Previous)

*  These logicals determine whether to print count and/or previous value:
	logical Prtcnt, Previous

	integer ERR, EDVR
	parameter( ERR=#8000, EDVR=0 )

	character*(4) statbits(16) / 'dcas', 'dtas', 'lacs', 'tacs', 
     .	'atn ', 'cic ', 'rem ', 'lok ', 'cmpl', '?   ', '?   ', '?   ',
     .  'srqi', 'end ', 'timo', 'err '/

	character*(4) errcode(17) / 'edvr', 'ecic', 'enol', 'eadr', 
     .	'earg', 'esac', 'eabo', 'eneb', '?   ', '?   ', 'eoip', 'ecap',
     . 'efso', '?   ', 'ebus', 'estb', 'esrq'/


	write(*,7) ibsta
  7	format(1X,'ibsta = #',Z4\,' (')
	do 10, i=15,0,-1	
		if (iand(ibsta,ishft(1,i)) .NE. 0) then
			write(*,'(A,A\)') ' ',statbits(i+1)
		endif
 10	continue
	write(*,'(A2\)')  ' )'
	if (iand(ibsta,ERR) .NE. 0) then
		write(*,27) errcode(iberr+1)
 27		format(2x,'iberr=',A\)
		if ((iand(iberr,EDVR) .NE. 0) .AND. (Prtcnt)) then
			write(*,37) ibcnt
 37			format(', ibcnt=',I4)
		else
			write(*,'()')
		endif
	else
		if (Previous) then
			write(*,47) iberr
 47			format(/,' Previous value=#',z4\)
		endif
		if (Prtcnt) then
			write(*,37) ibcnt
 57			format(', ibcnt=',I4)
		else
			write(*,'()')
		endif
	endif
	return 
	end

