* Microsoft FORTRAN Example Program - NI Device Level Functions

* This sample program is for reference only. It can only be expected to
* function with a Fluke 8840 Digital Multimeter that has been properly
* configured in IBCONF.

$include: 'nicode.for'

* Variables:

*  RetCode		   return code from API calls
*  cnt			   I/O count
*  dvm			   voltmeter device handle
*  action		   action taken by DosOpen
*  mask 		   event mask for WAIT
*  spr			   serial poll response
*  wrt(256), rd(256)	   I/O data buffers
*  udname		   voltmeter symbolic name

	integer*2 RetCode
	integer*2 cnt
	integer*2 dvm
	integer*2 action
	integer*2 mask
	integer*2 spr
	character wrt(256), rd(256)
	character*8 udname

* Begin

* Open GPIB0.

	data udname(1:4) /'dvm'C/
	RetCode = DosOpen(locfar(udname), dvm, action, 0, RdOnly,
     .		   OpenTrunc, RdWrDN, RESERVED)
	if (RetCode .ne. 0) call erropen

* Send Interface Clear.

	RetCode = DosDevIOCtl(LOCNULL, LOCNULL, DCLEAR, CATEGORY, dvm)
	if (RetCode .ne. 0) call deverr

*
* Write the function, range, and trigger source instructions to the device.
* This string is meaningful to the Fluke 8840 Digital Multimeter.

	wrt(1) = 'F'
	wrt(2) = '3'
	wrt(3) = 'R'
	wrt(4) = '7'
	wrt(5) = 'T'
	wrt(6) = '3'
	RetCode = DosWrite(dvm, locfar(wrt), 6, cnt)
	if (RetCode .ne. 0) call deverr

* Trigger the device.

	RetCode = DosDevIOCtl(LOCNULL, LOCNULL, TRIGGER, CATEGORY, dvm)
	if (RetCode .ne. 0) call deverr

*
* Wait for an SRQ (hex 800) or for a timeout (hex 40); if the device's time
* limit is too short, use DTempWrt to change it.  The mask bits BTIMO and
* BSRQ are described in NICODE.BAS.

	mask = ior (BTIMO,BSRQ)
	RetCode = DosDevIOCtl(LOCNULL, locfar(mask), BWAIT, CATEGORY, dvm)
	if (RetCode .ne. 0) call deverr

*
*  Next, serial poll the device.

	RetCode = DosDevIOCtl(LOCNULL, locfar(spr), SPOLL, CATEGORY, dvm)

*  Now test the status byte (spr). If spr is #C0, the device has valid data
*  to send; otherwise, it has a fault condition to report.

	if (spr .ne. #C0) write(*,*) ' Fault condition'
	if (RetCode .ne. 0) call deverr
*
*  If the data is valid, read the measurement.
*
	RetCode = DosRead (dvm, locfar(rd), 16, cnt)
	if (RetCode .ne. 0) call deverr
*
*  For good measure, close the device.
*
	RetCode = DosClose(dvm)

	stop
	end

*      A routine at this location would report the failure to open the device,
*      and would refer you to driver software configuration procedures.

	subroutine erropen
	write(*,*) ' Unable to open device'
	return
	end
*
*      An error checking routine at this location would, among other things,
*      check device status to determine the exact cause of the error condition
*      and then take action appropriate to the application.  For errors during
*      DosRead and DosWrite, cnt may be examined to determine the actual
*      number of bytes transferred.

	subroutine deverr
	write(*,*) 'Device error'
	return
	end
