(************ Microsoft Pascal NI-488 Example Program - Device Level **********)

(* This sample program is for reference only. It can only be expected to *)
(* function with a Fluke 8840 Digital Multimeter that has been properly  *)
(* configured in IBCONF.						 *)


program main (input,output);

{$include: 'decl.pas'}

{* Variable declarations taken from DECL.PAS:				     *}

var
  rd	 : cbuf;		      (* read data buffer		     *)
  wrt	 : cbuf;		      (* write data buffer		     *)
  bdname : nbuf;		      (* device name buffer		     *)
  dvm	 : integer;		      (* device number			     *)
  mask	 : integer;		      (* wait mask			     *)
  spr	 : char;		      (* serial poll response byte	     *)

(*****************************************************************************)
(* This routine would notify you that the IBFIND call failed, and refer you  *)
(* to the driver software configuration procedures.                          *)
(*****************************************************************************)

procedure finderr;

begin
  writeln (' Find error');
end;

(*****************************************************************************)
(* This routine would, among other things, check IBERR to determine the      *)
(* exact cause of the error condition & then take action appropriate to the  *)
(* application.  For errors during data transfers, IBCNT may be examined to  *)
(* determine the actual number of bytes transferred.                         *)
(*****************************************************************************)

procedure error;

begin
  writeln (' Error');
  writeln ('ibsta=',ibsta,'iberr=',iberr,'ibcnt=',ibcnt);
end;

(*****************************************************************************)
(* This routine would analyze the fault code returned in the DVM's status    *)
(* byte and then take appropriate action.                                    *)
(*****************************************************************************)

procedure dvmerr;

begin
  writeln (' DVM error');
  writeln ('ibsta=',ibsta,'iberr=',iberr,'ibcnt=',ibcnt);
end;

(*****************************************************************************)

begin

(* Assign a unique identifier to the device 'DVM' ("digital voltmeter")      *)

  bdname := 'DVM     ';
  dvm := ibfind (bdname);

(* Check for IBFIND error:						     *)

  if (dvm < 0) then finderr;

(* Clear the device:                                                         *)

  ibclr (dvm);

(* Check for an error on each GPIB call to be safe...                        *)

  if ((ibsta AND ERR) <> 0) then error;

(* Write the function, range, and trigger source instructions to the DVM.    *)
(* This string is meaningful to the Fluke 8840 Digital Multimeter.	     *)

  wrt[1] := 'F';
  wrt[2] := '3';
  wrt[3] := 'R';
  wrt[4] := '7';
  wrt[5] := 'T';
  wrt[6] := '3';
  ibwrt (dvm,wrt,6);
  if ((ibsta AND ERR) <> 0) then error;

(* Trigger the device:                                                       *)

  ibtrg (dvm);
  if ((ibsta AND ERR) <> 0) then error;

(* Wait for the DVM to set SRQ (hex 1000) or for a timeout (hex 4000).	    *)
(* These status bits are listed in Section Four of the Software Reference   *)
(* manual.  If the current time limit is too short, use IBTMO to change it. *)

  mask := TIMO OR SRQI;
  ibwait (dvm,mask);
  if ((ibsta AND ERR) <> 0) then error;

(* Next do a serial poll of the device. 				     *)

  ibrsp (dvm,spr);
  if ((ibsta AND ERR) <> 0) then error;

(* Now check the status byte. If it is 16#C0, the DVM has valid data to send *)
(* otherwise it has a fault condition to report.                             *)

  if (spr <> chr(16#C0)) then dvmerr;

(* If the data is valid, then read the measurement:                          *)

  ibrd (dvm,rd,16);
  if ((ibsta AND ERR) <> 0) then error;

(* To close out a programming sequence, call the IBONL function to disable   *)
(* the hardware and software:						     *)

  ibonl (dvm,0);

end.

