'**********
'*
'* nicode.bas :
'*   Definitions for National Instruments OS/2 GPIB Device Control Functions
'*
'*      Copyright 1988,1989 National Instruments Corporation.
'*            All rights reserved.
'*
'* Purpose:
'*      This file contains BASIC constants for device functions supported
'*      by National Instruments GPIB Drivers for OS/2.
'*
'***********
'
' Use the following API function declarations for wait-for-event

DECLARE FUNCTION DosCreateSem%( _	'Create system semaphore
	BYVAL privacy AS INTEGER, _
	BYVAL SemSeg AS INTEGER, BYVAL SemOff AS INTEGER,_
	BYVAL SemNameSeg AS INTEGER, BYVAL SemNameOff AS INTEGER)

DECLARE FUNCTION DosSemSet%( _		'Set RAM semaphore
	BYVAL SemSeg AS INTEGER, BYVAL SemOff AS INTEGER)

DECLARE FUNCTION DosSemClear%( _	'Clear RAM semaphore
	BYVAL SemSeg AS INTEGER, BYVAL SemOff AS INTEGER)


' Parameter for DosDevIOCtl

CONST CATEGORY =	&H81

' Parameters for DosOpen

CONST RdOnly =		1		 ' Attribute: Read only
CONST OpenTrunc =	2		 ' OpenFlag:
					 '      Open and truncate file if exists
CONST RdWrDN =		&H42		 ' OpenMode:
					 '      access mode  = read/write,
					 '      sharing mode = deny none

' GPIB Commands:

CONST UNL  =  &H3f			  ' GPIB unlisten command
CONST UNT  =  &H5f			  ' GPIB untalk command
CONST GTL  =  &H01			  ' GPIB go to local
CONST SDC  =  &H04			  ' GPIB selected device clear
CONST PPC  =  &H05			  ' GPIB parallel poll configure
CONST GGET =  &H08			  ' GPIB group execute trigger
CONST TCT  =  &H09			  ' GPIB take control
CONST LLO  =  &H11			  ' GPIB local lock out
CONST DCL  =  &H14			  ' GPIB device clear
CONST PPU  =  &H15			  ' GPIB parallel poll unconfigure
CONST SPE  =  &H18			  ' GPIB serial poll enable
CONST SPD  =  &H19			  ' GPIB serial poll disable
CONST PPE  =  &H60			  ' GPIB parallel poll enable
CONST PPD  =  &H70			  ' GPIB parallel poll disable

 '  device and board definitions


	' uflag - user flag definitions


CONST UEOT =		&H1	' end termination on write
CONST UREOS =		&H4	' terminate read on EOS
CONST UWEOS =		&H8	' assert EOI with EOS byte
CONST UCMP8 =		&H10	' 8-bit compare on EOS byte
CONST UDMA =		&H2000	' use DMA I/O

	' uflag - board only flag definitions


CONST UGPIB =		&H400	' return GPIB codes on all calls
CONST USC =		&H0800	' interface is system controller

'*******************************************************************
'*
'* OS/2 GPIB board status bit definitions (device function = STATUS)
'*
'*         bit definitions
'*          15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
'*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'*        | B | B| B| B| B| B| B| B| B| B|  |  | B|  | B | B|
'*        | C | A| L| R| S| L| T| D| D| T|  |  | E|  | T | I|
'*        | I | T| O| E| R| A| A| C| T| I|  |  | N|  | C | O|
'*        | C | N| K| M| Q|  |  | A| A| M|  |  | D|  |   | D|
'*        |   |  |  |  |  |  |  | S| S| O|  |  |  |  |   | O|
'*        |   |  |  |  |  |  |  |  |  |  |  |  |  |  |   | N|
'*        |   |  |  |  |  |  |  |  |  |  |  |  |  |  |   | E|
'*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'*
'*        BCIC     - board is controller in charge
'*        BATN     - GPIB attention line is asserted
'*        BLOK     - board is in lockout state
'*        BREM     - board is in remote state
'*        BSRQ     - GPIB SRQ line is asserted
'*        BLA      - GPIB is addressed as listener
'*        BTA      - GPIB is addressed as talker
'*        BDCAS    - GPIB has detected a device clear
'*        BDTAS    - GPIB has detected a device trigger
'*        BTIMO    - time limit exceeded on I/O function
'*        BEND     - END or EOS detected on I/O function
'*        BTC      - count was reached on I/O function
'*        BIODONE  - successful completion of I/O function
'*


CONST BIODONE = 	&H1
CONST BTC =		&H2
CONST BEND =		&H10
CONST BTIMO =		&H40
CONST BDTAS =		&H80
CONST BDCAS =		&H100
CONST BTA =		&H200
CONST BLA =		&H400
CONST BSRQ =		&H800
CONST BREM =		&H1000
CONST BLOK =		&H2000
CONST BATN =		&H4000
CONST BCIC =		&H8000

'********************************************************************
'*
'*  OS/2 handler errors
'*
'*        ECIC     - board must be CIC to use this function
'*        ENOL     - no listener for write transfer
'*        EADR     - board not addressed correctly
'*        EARG     - invalid argument to function call
'*        ESAC     - board must be system controller to use this function
'*        EABO     - I/O transfer aborted
'*        ECAP     - illegal function code
'*        ESEM     - invalid semaphore handle
'*        EBUS     - command error during device function
'*        ETMW     - timeout on wait function
'*

CONST	ECIC = 1
CONST	ENOL = 2
CONST	EADR = 3
CONST	EARG = 4
CONST	ESAC = 5
CONST	EABO = 6
CONST	ECAP = 11
CONST	ESEM = 13
CONST	EBUS = 14
CONST	ETMW = 17

'*********
'*
'*      Definitions of functions supported by National Instruments
'*      OS/2 Operating System GPIB Device Driver
'*
'***********

' Device Control Codes supported by OS/2 GPIB driver

		 ' begin BOARD DosDevIOCtl
CONST CMD =		&H67	' send commands from buffer
CONST ATNON =		&H68	' raise ATN
CONST ATNOFF =		&H69	' lower ATN
CONST SETREMOTE =	&H6B	' set remote enable
CONST SENDIFC = 	&H6C	' send IFC for 100 microseconds
CONST PRESENT = 	&H6D	' return whether board present
CONST ONLINE =		&H6E	' place device online
CONST OFFLINE = 	&H6F	' place device offline
CONST STATUS =		&H70	' return interface status
CONST BLOCAL =		&H71	' return board to local state
CONST SPOLLBYTE =	&H72	' change status byte returned by serial poll
CONST REQUEST = 	&H73	' set request service
CONST PPOLLIST =	&H74	' set individual status bit
CONST CLRREMOTE =	&H75	' clear remote enable
CONST BWAIT =		&H76	' wait for event
CONST BConfRd = 	&H79	' read board default configuration
CONST BConfWrt =	&H80	' write board default configuration
CONST BTempRd = 	&H81	' read board temporary information
CONST BTempWrt =	&H82	' write board temporary information
CONST IBSTATUS =        &H87 	' return interface status for
                                ' ib-style calls.

				' begin DEVICE DosDevIOCtl
CONST DCLEAR =		&H92	' device clear
CONST DLOCAL =		&H93	' return to local
CONST PASSCONTROL =	&H96	' pass control
CONST PPOLL =		&H97	' parallel poll
CONST PPOLLCONF =	&H98	' parallel poll configure
CONST TRIGGER = 	&H99	' device trigger
CONST SPOLL =		&H9A	' serial poll

				
CONST DConfRd = 	&HA1	' read device default configuration
CONST DConfWrt =	&HA2	' write device default configuration
CONST DTempRd = 	&HA3	' read device temporary information
CONST DTempWrt =	&HA4	' write device temporary information

type nibrd
	pad	   as integer		  ' primary address of board
	sad	   as integer		  ' secondary address of board
	eos	   as integer		  ' eos character
	timo	   as long		  ' minimum timeout
	uflags	   as integer		  ' some flags
	reserved   as integer		  ' reserved word
	rbase	   as integer		  ' base address of board
	dmaCH	   as integer		  ' DMA channel used by board
end type

type nidev
	brdno	   as integer		  ' number of associated board
	pad	   as integer		  ' primary address of device
	sad	   as integer		  ' secondary address of device
	eos	   as integer		  ' eos character
	uflags	   as integer		  ' some flags
	timo	   as long		  ' minimum timeout
end type
