*~~~~~~~~~~~
*
*  nicode.for:
*    Definitions for National Instruments OS/2 GPIB Device Control Functions
*
*	Copyright 1988,1989, 1990, 1991 National Instruments Corporation.
*	      All rights reserved.
*
*  Purpose:
*	This file contains FORTRAN constants for device functions supported
*	by National Instruments Version 1.3 GPIB Drivers for OS/2.
*
*~~~~~~~~~~~

* Allow long names:
$NOTRUNCATE
* Define integers to be two bytes long:
$storage:2

* Interface to API functions

	interface to integer*2 function DosOpen (udName[value],
     .	      udHandle, ActionTaken, Size[value],
     .	      Attribute[value], OpenFlag[value], OpenMode[value],
     .	      Reserved[value])
	integer*4 udName
	integer*2 udHandle [reference, far]
	integer*2 ActionTaken [reference, far]
	integer*4 Size
	integer*2 Attribute, OpenFlag, OpenMode
	integer*4 Reserved
	end

	interface to integer*2 function DosClose (udHandle[value])
	integer*2 udHandle
	end

	interface to integer*2 function DosDevIOCtl
     .	     (DataLoc[value], ParamLoc[value], Func[value], Categ[value],
     .	      udHandle[value])
	integer*4 DataLoc, ParamLoc
	integer*2 Func, Categ, udHandle
	end

       interface to integer*2 function DosRead	( udHandle[value],
     .	      BufferLoc[value], BufferLength[value], BytesRead)
       integer*2 udHandle
       integer*4 BufferLoc
       integer*2 BufferLength
       integer*2 BytesRead [reference, far]
       end

       interface to integer*2 function DosWrite  ( udHandle[value],
     .	      BufferLoc[value], BufferLength[value],
     .	      BytesWritten)
       integer*2 udHandle
       integer*4 BufferLoc
       integer*2 BufferLength
       integer*2 BytesWritten [reference, far]
       end

* Semaphore functions -- preparation for wait-for-event

*				DosCreateSem for system semaphores
       interface to integer*2 function DosCreateSem(privacy[value],
     .	      SemHandle[value], SemName[value])
       integer*2 privacy
       integer*4 SemHandle, SemName
       end

       interface to integer*2 function DosSemSet (SemHandle[value])
       integer*4 SemHandle
       end

       interface to integer*2 function DosSemClear (SemHandle[value])
       integer*4 SemHandle
       end


* Parameters for DosDevIOCtl

	integer*4 RESERVED
	integer*4 LOCNULL
	integer CATEGORY
	parameter (RESERVED = 0)
	parameter (LOCNULL = 0)
	parameter (CATEGORY = #81)

* Parameters for DosOpen

*   Attribute:	    RdOnly	   (Read only attribute)
*   OpenFlag:	    OpenTrunc	   (Open and truncate file if exists)
*   OpenMode:	    RdWrDN	   (Open device with:
*					access mode  = read/write,
*					sharing mode = deny none)

	integer RdOnly, OpenTrunc, RdWrDN
	parameter (RdOnly = 1, OpenTrunc = 2, RdWrDN = #42)

*------------------------------------------------------------------------------
*
*
*  GPIB Commands and Meanings:
*
*      UNL - GPIB unlisten command
*      UNT - GPIB untalk command
*      GTL - GPIB go to local
*      SDC - GPIB selected dev clear
*      PPC - GPIB parallel poll configure
*      GET - GPIB group execute trigger
*      TCT - GPIB take control
*      LLO - GPIB local lock out
*      DCL - GPIB device clear
*      PPU - GPIB parallel poll unconfigure
*      SPE - GPIB serial poll enable
*      SPD - GPIB serial poll disable
*      PPE - GPIB parallel poll enable
*      PPD - GPIB parallel poll disable

       integer*1 UNL, UNT, GTL, SDC, PPC, GGET, TCT
       integer*1 LLO, DCL, PPU, SPE, SPD, PPE, PPD

       parameter( UNL=#3F,  UNT=#5F,  GTL=#1,   SDC=#4,  PPC=#5,
     .		 GGET=#08, TCT=#09,  LLO=#11,  DCL=#14, PPU=#15,
     .		 SPE=#18,  SPD=#19,  PPE=#60,  PPD=#70)

*  device and board definitions


*	  uflag - user flag definitions
*     UEOT	   end termination on write
*     UREOS	   terminate read on EOS
*     UWEOS	   assert EOI with EOS byte
*     UCMP8	   8-bit compare on EOS byte
*     UDMA	   use DMA I/O

	integer*1 UEOT, UREOS, UWEOS, UCMP8, UDMA

	parameter (UEOT=#1, UREOS=#8, UWEOS=#8, UCMP8=#10, UDMA=#2000)

*	  uflag - board only flag definitions
*     UGPIB	   return GPIB codes on all calls
*     USC	   interface is system controller
*     UIST	   set or clear individual status bits for ppoll
*     USRE	   set or clear remote enable line

	integer*1 UGPIB, USC, UIST, USRE

	parameter (USRE=#100, UIST=#200, UGPIB=#400, USC=#800)

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*
*  OS/2 GPIB board status bit definitions (device function = STATUS)
*
*	   bit definitions
*	   15 14 13 12 11 10  9  8  7  6  5  4	3  2  1  0
*	 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*	 | B | B| B| B| B| B| B| B| B| B|  |  | B|  | B | B|
*	 | C | A| L| R| S| L| T| D| D| T|  |  | E|  | T | I|
*	 | I | T| O| E| R| A| A| C| T| I|  |  | N|  | C | O|
*	 | C | N| K| M| Q|  |  | A| A| M|  |  | D|  |	| D|
*	 |   |	|  |  |  |  |  | S| S| O|  |  |  |  |	| O|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| N|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| E|
*	 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*
*	 BCIC	  - board is controller in charge
*	 BATN	  - GPIB attention line is asserted
*	 BLOK	  - board is in lockout state
*	 BREM	  - board is in remote state
*	 BSRQ	  - GPIB SRQ line is asserted
*	 BLA	  - GPIB is addressed as listener
*	 BTA	  - GPIB is addressed as talker
*	 BDCAS	  - GPIB has detected a device clear
*	 BDTAS	  - GPIB has detected a device trigger
*	 BTIMO	  - time limit exceeded on I/O function
*	 BEND	  - END or EOS detected on I/O function
*	 BTC	  - count was reached on I/O function
*	 BIODONE  - successful completion of I/O function

	integer BIODONE, BTC, BEND, BTIMO, BDTAS, BDCAS, BTA, BLA
	integer BSRQ, BREM, BLOK, BATN, BCIC

	parameter (BIODONE=#1, BTC=#2, BEND=#10, BTIMO=#40, BDTAS=#80,
     .		  BDCAS=#100, BTA=#200, BLA=#400, BSRQ=#800,
     .		  BREM=#1000, BLOK=#2000, BATN=#4000, BCIC=#8000)

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*
*  OS/2 handler errors
*
*	 ECIC	  - board must be CIC to use this function
*	 ENOL	  - no listener for write transfer
*	 EADR	  - board not addressed correctly
*	 EARG	  - invalid argument to function call
*	 ESAC	  - board must be system controller to use this function
*	 EABO	  - I/O transfer aborted
*	 ECAP	  - illegal function code
*	 ESEM	  - invalid semaphore handle
*	 EBUS	  - command error during device function
*	 ETMW	  - timeout on wait function
*
	integer ECIC, ENOL, EADR, EARG, ESAC, EABO, ECAP, ESEM, EBUS
	integer ETMW

	parameter (ECIC = 1, ENOL = 2, EADR = 3, EARG = 4, ESAC = 5,
     .		  EABO = 6, ECAP = 11, ESEM = 13, EBUS = 14,
     .		  ETMW = 17)


*~~~~~~~~~~~
*	Definitions of functions supported by National Instruments
*	OS/2 Operating System GPIB Device Driver
*
*~~~~~~~~~~~

* Device Control Codes supported by National Instruments
* OS/2 GPIB driver

*	    BOARD DosDevIOCtl
*     CMD	      send commands from buffer
*     ATNON	      raise ATN
*     ATNOFF	      lower ATN
*     SETREMOTE       set remote enable
*     SENDIFC	      send IFC for 100 microseconds
*     PRESENT	      return whether board present
*     ONLINE	      place device online
*     OFFLINE	      place device offline
*     STATUS	      return interface status
*     BLOCAL	      return board to local state
*     SPOLLBYTE       change status byte returned by serial poll
*     REQUEST	      set request service
*     PPOLLIST	      set individual status bit
*     CLRREMOTE       clear remote enable
*     BWAIT	      wait for event
*     BConfRd	      read board default configuration
*     BConfWrt	      write board default configuration
*     BTempRd	      read board temporary information
*     BTempWrt	      write board temporary information
*     IBSTATUS        return interface status for ibstyle calls.

	integer CMD, ATNON, ATNOFF, SETREMOTE, SENDIFC, PRESENT, ONLINE
	integer OFFLINE, STATUS, BLOCAL, SPOLLBYTE, REQUEST, PPOLLIST
	integer CLRREMOTE, BWAIT, BConfRd, BConfWrt, BTempRd, BTempWrt
        integer IBSTATUS

	parameter (CMD=#67, ATNON=#68, ATNOFF=#69, SETREMOTE=#6B,
     .		 SENDIFC=#6C, PRESENT=#6D, ONLINE=#6E, OFFLINE=#6F,
     .		 STATUS=#70, BLOCAL=#71, SPOLLBYTE=#72,  REQUEST=#73,
     .		 PPOLLIST=#74, CLRREMOTE=#75, BWAIT=#76, BConfRd=#79,
     .		 BConfWrt=#80, BTempRd=#81, BTempWrt=#82, IBSTATUS=#87)

*	   DEVICE DosDevIOCtl
*     DCLEAR	      device clear
*     DLOCAL	      return to local
*     PASSCONTROL     pass control
*     PPOLL	      parallel poll
*     PPOLLCONF       parallel poll configure
*     TRIGGER	      device trigger
*     SPOLL	      serial poll
*
*     DConfRd	      read device default configuration
*     DConfWrt	      write device default configuration
*     DTempRd	      read device temporary information
*     DTempWrt	      write device temporary information

	integer DCLEAR, DLOCAL, PASSCONTROL, PPOLL, PPOLLCONF
	integer TRIGGER, SPOLL, DConfRd, DConfWrt, DTempRd, DTempWrt

	parameter (DCLEAR=#92, DLOCAL=#93, PASSCONTROL=#96, PPOLL=#97,
     .		 PPOLLCONF=#98, TRIGGER=#99, SPOLL=#9A, DConfRd=#A1,
     .		 DConfWrt=#A2, DTempRd=#A3, DTempWrt=#A4)

* Example board/device structures
* Arrays such as these must be passed to the commands BConfRd, BConfWrt,
* BTempRd, BTempWrt, DConfRd, DConfWrt, DTempRd, and DTempWrt.
* Before using this code, remove comments to right of equivalence statements.
*
* Simulated structures:
*	integer*2	nibrd(9), nidev(7)
* Structure fields:
*	integer*2	bpad,bsad,beos,buflags,reserved,rbase,dmaCH
*	integer*2	brdno,dpad,dsad,deos,duflags
*	integer*4	btimeo,dtimeo
*
*	equivalence (nibrd(1),bpad),	     primary address of board
*    .		    (nibrd(2),bsad),	     secondary address of board
*    .		    (nibrd(3),beos),	     eos character
*    .		    (nibrd(4),btimeo),	     minimum timeout
*    .		    (nibrd(6),buflags),      some flags
*    .		    (nibrd(7),reserved),     reserved word
*    .		    (nibrd(8),rbase),	     base address of board
*    .		    (nibrd(9),dmaCH)	     DMA channel used by board
*
*	equivalence (nidev(1),brdno),	     number of GPIB board
*    .		    (nidev(2),dpad),	     primary address of device
*    .		    (nidev(3),dsad),	     secondary address of device
*    .		    (nidev(4),deos),	     eos character
*    .		    (nidev(5),duflags),      some flags
*    .		    (nidev(6),dtimeo)	     minimum timeout
*
*
* Declare function names
	integer*2 DosDevIOCtl, DosOpen, DosClose, DosRead, DosWrite
	integer*2 DosCreateSem, DosSemSet, DosSemClear
