/***********
 *
 * nictl.h - definitions for National Instruments OS/2 GPIB
 *	     Device Control Functions
 *
 *	Copyright (c) 1988, 1989, 1990, 1991 National Instruments Corporation
 *	      All rights reserved.
 *
 * Purpose:
 *	This file contains the C macro NICTL for device functions supported
 *	by National Instruments Version 1.3 GPIB Drivers for OS/2.
 *
 ************/

#define CATEGORY   0x81
#define NAD	(int far *) 0

#define nictl(d,cmd,pa,ba) DosDevIOCtl((ba) ? (void far *) (ba) : NAD,(pa) ? (void far *) (pa) : NAD,(cmd),CATEGORY,d)
/*  parameters:	file handle,
 *		device function code,
 *		address of parameter,
 *		address of buffer)
 */

/*
 * Example board functions
 *
 *	nictl(b,ATNOFF,0,0)
 *	nictl(b,ATNON,0,0)
 *	nictl(b,BLOCAL,0,0)
 *	nictl(bd,BWAIT,&mask,&semhandle)
 *	nictl(b,CLRREMOTE,0,0)
 *	nictl(b,CMD,&count,&commands)
 *	nictl(b,OFFLINE,0,0)
 *	nictl(b,ONLINE,0,0)
 *	nictl(b,PPOLLIST,&ist,0)
 *	nictl(b,PRESENT,&boolean,0)
 *	nictl(b,REQUEST,0,0)
 *	nictl(b,SENDIFC,0,0)
 *	nictl(b,SETREMOTE,0,0)
 *	nictl(b,SPOLLBYTE,&spollbyte,0)
 *	nictl(bd,STATUS,&status,0)
 *
 *	nictl(db,BConfRd,&NIbrd,0)
 *	nictl(db,BConfWrt,&NIbrd,0)
 *	nictl(db,BTempRd,&NIbrd,0)
 *	nictl(db,BTempWrt,&NIbrd,0)
 * 
 * Example device functions
 *
 *	nictl(d,DCLEAR,0,0)
 *	nictl(d,DLOCAL,0,0)
 *	nictl(d,PASSCONTROL,0,0)
 *	nictl(d,PPOLL,&response,0)
 *	nictl(d,PPOLLCONF,&ppc,sense)
 *	nictl(d,SPOLL,&response,0)
 *	nictl(d,TRIGGER,0,0)
 *
 *
 *	nictl(d,DConfRd,&NIdev,0)
 *	nictl(d,DConfWrt,&NIdev,0)
 *	nictl(d,DTempRd,&NIdev,0)
 *	nictl(d,DTempWrt,&NIdev,0)
 */
