/***********
 *
 * nicode.h - NI_488.2 specific definitions for 
 *            National Instruments OS/2 GPIB API Functions
 *
 ************/

/* The following definitions allow the necessary API function declarations
 * to be included by os2.h.
 */




/* Parameter for DosDevIOCtl	  */

#define CATEGORY 0x81

/* GPIB Commands     */

#define UNL  0x3f       /* GPIB unlisten command                */
#define UNT  0x5f       /* GPIB untalk command                  */
#define GTL  0x01      /* GPIB go to local                     */
#define SDC  0x04     /* GPIB selected device clear           */
#define PPC  0x05     /* GPIB parallel poll configure         */
#define GGET 0x08    /* GPIB group execute trigger	   */
#define TCT  0x09      /* GPIB take control                    */
#define LLO  0x11     /* GPIB local lock out                  */
#define DCL  0x14    /* GPIB device clear                    */
#define PPU  0x15   /* GPIB parallel poll unconfigure       */
#define SPE  0x18  /* GPIB serial poll enable              */
#define SPD  0x19  /* GPIB serial poll disable             */
#define PPE  0x60  /* GPIB parallel poll enable            */
#define PPD  0x70  /* GPIB parallel poll disable           */

/*
 *  device and board definitions
 */

#define UEOT	 0x0001	 /* Board/Device, end termination on write */
#define UREOS	 0x0004	 /* Board/Device, Terminate read on EOS */
#define UWEOS	 0x0008	 /* Board/Device, assert EOI with EOS byte */
#define UCMP8	 0x0010	 /* Board/Device, 8-bit compare on EOS byte */
#define UGPIB   0x0400 /* Board/Device, return GPIB codes on all calls */

#define UNAD 	 0x0020	 /* Device Only, unaddress devices after I/O */

	/* uflag - board only flag definitions
	 */

#define USC    0x0800   /* Board Only, interface is system controller */
#define UDMA	0x2000  /* Board Only, use DMA I/O */

/* GPIB status vector:       */

#define BDCAS    (1 << 0)
#define BDTAS    (1 << 1)
#define BLACS    (1 << 2)
#define BTACS    (1 << 3)
#define BATN     (1 << 4)
#define BCIC     (1 << 5)
#define BREM     (1 << 6)
#define BLOK     (1 << 7)
#define BCMPL    (1 << 8)
#define BRQS     (1 << 11)
#define BSRQI    (1 << 12)
#define BEND     (1 << 13)
#define BTIMO    (1 << 14)
#define BERR     (1 << 15)
#define BIODONE  BCMPL
#define BTC      BCMPL

/********************************************************************
*
*  NI-488.2M Driver errors
*
*/

#define  EDVR     0     /* operating system error                       */
#define  ECIC     1     /* not controller in charge                     */
#define  ENOL     2     /* write error (no listeners)                   */
#define  EADR     3     /* CIC and not addressed before I/O             */
#define  EARG     4     /* bad argument to function call                */
#define  ESAC     5     /* not SC                                       */
#define  EABO     6     /* operation aborted (timeout)                  */
#define  ENEB     7     /* Non existant board                           */
#define  EDMA     8     /* Error with DMA                               */
#define  EOIP     10    /* Asynchronous not complete                    */
#define  ECAP     11    /* no capability for intended operation         */
#define  EFSO     12    /* file system error                            */
#define  EBUS     14    /* GPIB bus error                               */
#define  ESTB     15    /* serial poll bytes queue overflow             */
#define  ESRQ     16    /* SRQ stuck on                                 */
#define  ETAB     20    /* The result buffer has overflowed.            */

/* Timeout values and its meanings.  These codes are to be used to change
 * the board's or device's timeout using TempWrt and ConfWrt calls.
 */

#define TNONE             (ushort)0        /* timeout disabled */
#define T10us             (ushort)1        /* timeout of 10 us */
#define T30us             (ushort)2        /* timeout of 30 us */
#define T100us            (ushort)3        /* timeout of 100 us */
#define T300us            (ushort)4        /* timeout of 300 us */
#define T1ms              (ushort)5        /* timeout of 1 ms */
#define T3ms              (ushort)6        /* timeout of 3 ms */
#define T10ms             (ushort)7        /* timeout of 10  ms */
#define T30ms             (ushort)8        /* timeout of 30 ms */
#define T100ms            (ushort)9        /* timeout of 100 ms */
#define T300ms            (ushort)10       /* timeout of 300 ms */
#define T1s               (ushort)11       /* timeout of 1 s */
#define T3s               (ushort)12       /* timeout of 3 s */
#define T10s              (ushort)13       /* timeout of 10 s */
#define T30s              (ushort)14       /* timeout of 30 s */
#define T100s             (ushort)15       /* timeout of 100 s */
#define T300s             (ushort)16       /* timeout of 300 s */
#define T1000s            (ushort)17       /* timeout of 1000 s */


/***********
 *
/*	Definitions of functions and constants supported by National Instruments
 *	OS/2 Operating System GPIB Device Driver
 *
 ************/

/* Device Control Codes supported by OS/2 GPIB driver */

				/* begin BOARD IOCTL */
#define CMD		   0x67	/* send commands from buffer */
#define ATNON		0x68	/* raise ATN */
#define ATNOFF		0x69	/* lower ATN */
#define ONLINE		0x6A	/* place device online */
#define SETREMOTE	0x6B	/* set remote enable */
#define SENDIFC	0x6C	/* send IFC for 100 microseconds */
#define PRESENT	0x6D	/* return whether board present */
#define OFFLINE 	0x6E	/* place device offline */
#define STATUS		0x70	/* interface status specific to API style
                           calls.*/
#define BLOCAL		0x71	/* return board to local state */
#define SPOLLBYTE	0x72	/* change status byte returned by serial poll */
#define REQUEST 	0x73	/* set request service */
#define PPOLLIST	0x74	/* set individual status bit */
#define CLRREMOTE	0x75	/* clear remote enable */
#define BWAIT		0x76	/* wait for event */
#define BConfRd	0x79	/* read board default configuration */
#define BConfWrt	0x80	/* write board default configuration */
#define BTempRd	0x81	/* read board temporary information */
#define BTempWrt	0x82	/* write board temporary information */


				/* begin DEVICE IOCTL */
#define DCLEAR		   0x92	/* device clear */
#define DLOCAL		   0x93	/* return to local */
#define PASSCONTROL	0x96	/* pass control */
#define PPOLL		   0x97	/* parallel poll */
#define PPOLLCONF	   0x98	/* parallel poll configure */
#define TRIGGER		0x99	/* device trigger */
#define SPOLL		   0x9A	/* serial poll */

				
#define DConfRd		0xA1	/* read device default configuration */
#define DConfWrt	   0xA2	/* write device default configuration */
#define DTempRd		0xA3	/* read device temporary information */
#define DTempWrt	   0xA4	/* write device temporary information */

/* Board configuration structure */

typedef struct nibrd {
	short	uflags; 	/* certain board configuration flags */
	short	pad;		/* primary address of board */
	short	sad;		/* secondary address of board */
	short	eos;		/* eos character */
	short	timo;		/* minimum timeout for board level operations */
	short	rbase;		/* base address of board */
	short dmaCH;		/* DMA channel used by board */
} nibrd;

/* Device configuration structure */

typedef struct nidev {
	short	uflags; 	/* certain device configuration flags */
	short	brdno;		/* index to associated board */
	short	pad;		/* primary address of device */
	short	sad;		/* secondary address of device */
	short	eos;		/* eos character */
	short	timo;		/* minimum timeout for device level operations */
} nidev;





