/* OS/2 Example Program 3 -- Asynchronous I/O */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include "decl.h"

#define SCAN_SIZE 2000  /*size of scan*/

main(){

   int clp;            /* file descriptor for color printer */
   char *data_in;      /* intake data array */
   FILE *fd;           /* file descriptor for "scan.dat" */

   /*Allocate buffer for scan data*/
   data_in=malloc(SCAN_SIZE);
   if (data_in==NULL)
      report_error(clp, "Could not allocate sufficient memory");

   /*Open file for storing scan image*/
   fd = fopen("scan.dat", "w+");
   if (fd==NULL)
      report_error(clp, "Could not open data file\n");

   /*Bring the color printer on-line*/
   if ((clp = ibfind("P500C")) < 0)
      report_error(clp, "Could not open device P500C");
                  

   while(CheckScan() != 0) {        /*while more data available from scanner*/
      
      /*Read in data from CAT scanner, store in "data_in" buffer*/
      ScanRead(data_in);
      printf("IMAGE IN\n");

      /*Asynchronously write the data to the color printer*/
      ibwrta(clp, data_in, SCAN_SIZE);
      if (ibsta & ERR)
         report_error(clp, "Error occurred while trying to print");
      else
         printf("Printing image...\n");


      /*Write data to disk file "data_in"*/
      fwrite(data_in, 1,SCAN_SIZE, fd);    

      while (!(ibsta & CMPL)) {     /* while previous I/O not complete */

         /*Null wait to update status word*/
         ibwait(clp, 0);

         /*Do some processing on current image*/
         ScanProc(data_in);
      }
      printf("Done printing image- READY FOR NEXT IMAGE\n");
   }

   /*Take the color printer off-line*/
   ibonl(clp, 0);       
}

report_error(int fd, char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);

   if (fd != -1) {
      printf("Cleanup: taking board off-line\n");
      ibonl(fd,0);
   }
   exit(1);              /* abort program */
}
