
/* This include file will have all the definitions that the 488.1    *
 * calls, 488.2 calls and API-style calls need to include along with *
 * their GPIB application programs.												*
 */

/* C Declarations                                          */
/*                                                         */
/*                                                         */
/* Status variables                                        */

extern int  _far ibsta;
extern int  _far ibcnt;
extern int  _far iberr;
extern int  _far ibcntl;

/* GPIB Commands */

#define UNL  0x3f       /* GPIB unlisten command                */
#define UNT  0x5f       /* GPIB untalk command                  */
#define GTL  0x01      /* GPIB go to local                     */
#define SDC  0x04     /* GPIB selected device clear           */
#define PPC  0x05     /* GPIB parallel poll configure         */
#define GET 0x08    /* GPIB group execute trigger	   */
#define TCT  0x09      /* GPIB take control                    */
#define LLO  0x11     /* GPIB local lock out                  */
#define DCL  0x14    /* GPIB device clear                    */
#define PPU  0x15   /* GPIB parallel poll unconfigure       */
#define SPE  0x18  /* GPIB serial poll enable              */
#define SPD  0x19  /* GPIB serial poll disable             */
#define PPE  0x60  /* GPIB parallel poll enable            */
#define PPD  0x70  /* GPIB parallel poll disable           */

/* GPIB status vector:       *
 *   global variable ibsta and wait mask.  */

#define DCAS    (1 << 0)
#define DTAS    (1 << 1)
#define LACS    (1 << 2)
#define TACS    (1 << 3)
#define ATN     (1 << 4)
#define CIC     (1 << 5)
#define REM     (1 << 6)
#define LOK     (1 << 7)
#define CMPL    (1 << 8)
#define EVENT   (1 << 9)  
#define SPOLL   (1 << 10) 
#define RQS     (1 << 11)
#define SRQI    (1 << 12)
#define END     (1 << 13)
#define TIMO    (1 << 14)
#define ERR     (1 << 15)



/* Error messages returned in global variable iberr */

#define EDVR 0
#define ECIC 1
#define ENOL 2
#define EADR 3
#define EARG 4
#define ESAC 5
#define EABO 6
#define ENEB 7
#define EOIP 10
#define ECAP 11
#define EFSO 12
#define EBUS 14
#define ESTB 15
#define ESRQ 16
#define ETAB 20

/* EOS mode bits          */

#define BIN    (1 << 12)  /* eight bit compare          */
#define XEOS   (1 << 11)  /* send END with EOS byte     */
#define REOS   (1 << 10)  /* Terminate read on EOS      */

/* Timeout values and meanings   */
#define TNONE    0   /* infinite timeout (disabled      */
#define T10us    1   /* Timeout of 10us                 */
#define T30us    2   /* Timeout of 30us                 */
#define T100us   3   /* Timeout of 100us                */
#define T300us   4   /* Timeout of 300us                */
#define T1ms     5   /* Timeout of 1ms                  */
#define T3ms     6   /* Timeout of 3ms                  */
#define T10ms    7   /* Timeout of 10ms                 */
#define T30ms    8   /* Timeout of 30ms                 */
#define T100ms   9   /* Timeout of 100ms                */
#define T300ms   10  /* Timeout of 300ms                */
#define T1s      11  /* Timeout of 1s                   */
#define T3s      12  /* Timeout of 3s						  */
#define T10s 	  13	/* Timeout of 10s						  */
#define T30s     14  /* Timeout of 30s                  */
#define T100s    15	/* Timeout of 100s                 */
#define T300s    15	/* Timeout of 300s                 */
#define T1000s   15	/* Timeout of 1000s                 */


/* IBLN Constants */
#define NO_SAD   0
#define ALL_SAD -1


/*
 *    GotoMultAddr flags
 */
#define  MultAddrPrimary      0x00
#define  MultAddrSecondary    0x01

#define  MultAddrListen       0x00
#define  MultAddrTalk         0x01
#define  MultAddrSerialPoll   0x81


/* Miscellaneous                                           */

#define S    0x08    /* parallel poll sense bit            */
#define LF   0x0A    /* ASCII linefeed character           */


/*  The following constants are used for the second parameter of the 
 *  ibconfig function.  They are the "option" selection codes.
 */
#define  IbcPAD            0x0001      /* Primary Address                         */
#define  IbcSAD            0x0002      /* Secondary Address                       */
#define  IbcTMO            0x0003      /* Timeout Value                           */
#define  IbcEOT            0x0004      /* Send EOI with last data byte?           */
#define  IbcPPC            0x0005      /* Parallel Poll Configure                 */
#define  IbcREADDR         0x0006      /* Repeat Addressing                       */
#define  IbcAUTOPOLL       0x0007      /* Disable Auto Serial Polling             */
#define  IbcCICPROT        0x0008      /* Use the CIC Protocol?                   */
#define  IbcIRQ            0x0009      /* Use PIO for I/O                         */
#define  IbcSC             0x000A      /* Board is System Controller?             */
#define  IbcSRE            0x000B      /* Assert SRE on device calls?             */
#define  IbcEOSrd          0x000C      /* Terminate reads on EOS                  */
#define  IbcEOSwrt         0x000D      /* Send EOI with EOS character             */
#define  IbcEOScmp         0x000E      /* Use 7 or 8-bit EOS compare              */
#define  IbcEOSchar        0x000F      /* The EOS character.                      */
#define  IbcPP2            0x0010      /* Use Parallel Poll Mode 2.               */
#define  IbcTIMING         0x0011      /* NORMAL, HIGH, or VERY_HIGH timming.     */
#define  IbcDMA            0x0012      /* Use DMA for I/O                         */
#define  IbcReadAdjust     0x0013      /* Swap bytes during an ibrd.              */
#define  IbcWriteAdjust    0x0014      /* Swap bytes during an ibwrt.             */
#define  IbcEventQueue     0x0015      /* Enable/disable the event queue.         */
#define  IbcSPollBit       0x0016      /* Enable/disable the visibility of SPOLL. */
#define  IbcSendLLO        0x0017      /* Enable/disable the sending of LLO.      */
#define  IbcSPollTime      0x0018      /* Set the timeout value for serial polls. */
#define  IbcPPollTime      0x0019      /* Set the parallel poll length period.    */
#define  IbcEndBitIsNormal 0x001A      /* Remove EOS from END bit of IBSTA.       */
#define  IbcUnAddr         0x001B      /* Enable/disable device unaddressing.     */
#define  IbcHSCableLength  0x001F      /* CableLength for TNT chip                */
#define  IbcLON            0x0022      /* Listen Only mode                        */

/*
 *    Constants that can be used (in addition to the ibconfig constants)
 *    when calling the ibask() function.
 */

#define  IbaPAD        IbcPAD      /* Primary Address                      */
#define  IbaSAD        IbcSAD      /* Secondary Address                    */
#define  IbaTMO        IbcTMO      /* Timeout Value                        */
#define  IbaEOT        IbcEOT      /* Send EOI with last data byte?        */
#define  IbaPPC        IbcPPC      /* Parallel Poll Configure              */
#define  IbaREADDR     IbcREADDR      /* Repeat Addressing                    */
#define  IbaAUTOPOLL   IbcAUTOPOLL      /* Disable Auto Serial Polling          */
#define  IbaCICPROT    IbcCICPROT      /* Use the CIC Protocol?                */
#define  IbaIRQ        IbcIRQ      /* Use PIO for I/O                      */
#define  IbaSC         IbcSC      /* Board is System Controller?          */
#define  IbaSRE        IbcSRE      /* Assert SRE on device calls?          */
#define  IbaEOSrd      IbcEOSrd      /* Terminate reads on EOS               */
#define  IbaEOSwrt     IbcEOSwrt      /* Send EOI with EOS character          */
#define  IbaEOScmp     IbcEOScmp      /* Use 7 or 8-bit EOS compare           */
#define  IbaEOSchar    IbcEOSchar      /* The EOS character.                   */
#define  IbaPP2        IbcPP2      /* Use Parallel Poll Mode 2.            */
#define  IbaTIMING     IbcTIMING      /* NORMAL, HIGH, or VERY_HIGH timming.  */
#define  IbaDMA        IbcDMA      /* Use DMA for I/O                      */
#define  IbaReadAdjust IbcReadAdjust     /* Swap bytes during an ibrd.           */
#define  IbaWriteAdjust IbcWriteAdjust     /* Swap bytes during an ibwrt.          */
#define  IbaEventQueue IbcEventQueue      /* Enable/disable the event queue.         */
#define  IbaSPollBit   IbcSPollBit      /* Enable/disable the visibility of SPOLL. */
#define  IbaSendLLO    IbcSendLLO      /* Enable/disable the sending of LLO.      */
#define  IbaSPollTime  IbcSPollTime      /* Set the timeout value for serial polls. */
#define  IbaPPollTime  IbcPPollTime      /* Set the parallel poll length period.    */
#define  IbaEndBitIsNormal IbcEndBitIsNormal   /* Remove EOS from END bit of IBSTA.       */
#define  IbaUnAddr     IbcUnAddr      /* Enable/disable device unaddressing.     */
#define  IbaHSCableLength  IbcHSCableLength   /* CableLength for TNT chip                */ 
#define  IbaLON            IbcLON  				 /* Listen Only mode                        */

#define  IbaBNA            0x0200   /* A device's access board.                  */
#define  IbaBaseAddr       0x0201   /* A GPIB board's base I/O address.          */
#define  IbaDmaChannel     0x0202   /* A GPIB board's DMA channel.               */
#define  IbaIrqLevel       0x0203   /* A GPIB board's IRQ level.                 */
#define  IbaBaud           0x0204   /* Baud rate used to communicate to CT box.  */
#define  IbaParity         0x0205   /* Parity setting for CT box.                */
#define  IbaStopBits       0x0206   /* Stop bits used for communicating to CT.   */
#define  IbaDataBits       0x0207   /* Data bits used for communicating to CT.   */
#define  IbaComPort        0x0208   /* System COM port used for CT box.          */
#define  IbaComIrqLevel    0x0209   /* System COM port's interrupt level.        */
#define  IbaComPortBase    0x020A   /* System COM port's base I/O address.       */


/* These are the values are used by the Send 488.2 command. */
#define  NULLend (unsigned short)0x00  /* Do nothing at the end of a transfer.*/
#define  NLend   (unsigned short)0x01  /* Send NL with EOI after a transfer.  */
#define  DABend  (unsigned short)0x02  /* Send EOI with the last DAB.         */


/* This value is used by the 488.2 Receive command.
 */
#define  STOPend     (unsigned short)0x0100

/* Address type (for 488.2 calls) */

typedef short Addr4882_t; /* System dependent: must be 16 bits */


/*
 *  This macro can be used to easily create an entry in address list
 *  that is required by many of the 488.2 functions.  An address list is
 *  just an array of unsigned integers.  The primary address goes in the
 *  lower 8-bits and the secondary address goes in the upper 8-bits.
 */
#define  MakeAddr(pad, sad)   ((unsigned short)(((unsigned char)(pad)) | (((unsigned char)(sad))<<8)))

/*
 *  This value is used to terminate an address list.  It should be
 *  assigned to the last entry.
 */
#define  NOADDR    (Addr4882_t)0xFFFF

/*
 *  The following two macros are used to "break apart" an address list
 *  entry.  They take an unsigned integer and return either the primary
 *  or secondary address stored in the integer.
 */
#define  GetPAD(val)    ((val) & 0xFF)
#define  GetSAD(val)    (((val) >> 8)& 0xFF)


/*
 *  The following values are used by the iblines function.  The unsigned
 *  integer returned by iblines contains:
 *       The lower byte will contain a "monitor" bit mask.  If a bit is
 *          set (1) in this mask, then the corresponding line can be
 *          monitiored by the driver.  If the bit is clear (0),
 *          then the line cannot be monitored.
 *       The upper byte will contain the status of the bus lines.
 *          Each bit corresponds to a certain bus line, and has
 *          a correcponding "monitor" bit in the lower byte.
 *
 */
#define  ValidEOI   (unsigned short)0x0080
#define  ValidATN   (unsigned short)0x0040
#define  ValidSRQ   (unsigned short)0x0020
#define  ValidREN   (unsigned short)0x0010
#define  ValidIFC   (unsigned short)0x0008
#define  ValidNRFD  (unsigned short)0x0004
#define  ValidNDAC  (unsigned short)0x0002
#define  ValidDAV   (unsigned short)0x0001
#define  BusEOI     (unsigned short)0x8000
#define  BusATN     (unsigned short)0x4000
#define  BusSRQ     (unsigned short)0x2000
#define  BusREN     (unsigned short)0x1000
#define  BusIFC     (unsigned short)0x0800
#define  BusNRFD    (unsigned short)0x0400
#define  BusNDAC    (unsigned short)0x0200
#define  BusDAV     (unsigned short)0x0100



/* define all the ib-function prototypes found in nidioctl.c */
extern int _far _cdecl ibask (int handle, int param_code, int _far *v);
extern int _far _cdecl ibcac (int handle, int v);
extern int _far _cdecl ibcmd (int handle, void _far *buffer, long count);
extern int _far _cdecl ibcmda (int handle, void _far *buffer, long count);
extern int _far _cdecl ibconfig (int handle, int option, int value);
extern int _far _cdecl ibdiag (int handle, void _far *buffer, long count);
extern int _far _cdecl ibdma (int handle, int v);
extern int _far _cdecl ibeos (int handle, int v);
extern int _far _cdecl ibeot (int handle, int v);
extern int _far _cdecl ibfind (char _far *name);
extern int _far _cdecl ibgts (int handle, int v);
extern int _far _cdecl ibist (int handle, int v);
extern int _far _cdecl iblines (int handle, short _far *lines);
extern int _far _cdecl ibln ( int handle, int pad, int sad, short _far *listen);
extern int _far _cdecl ibloc (int handle);
extern int _far _cdecl ibonl (int handle, int v);
extern int _far _cdecl ibpad (int handle, int v);
extern int _far _cdecl ibpoke (int handle, int option, int v);
extern int _far _cdecl ibppc (int handle, int v);
extern int _far _cdecl ibrd (int handle, void _far *buffer, long count);
extern int _far _cdecl ibrda (int handle, void _far *buffer, long count);
extern int _far _cdecl ibrdf (int handle, char _far *filename);
extern int _far _cdecl ibrpp (int handle, char _far *buffer);
extern int _far _cdecl ibrsc (int handle, int v);
extern int _far _cdecl ibrsv (int handle, int v);
extern int _far _cdecl ibsad (int handle, int v);
extern int _far _cdecl ibsic (int handle);
extern int _far _cdecl ibsre (int handle, int v);
extern int _far _cdecl ibsrq (void (_far * func) (void));
extern int _far _cdecl ibstop (int handle);
extern int _far _cdecl ibtmo (int handle, int v);
extern int _far _cdecl ibwait (int handle, int mask);
extern int _far _cdecl ibwrt (int handle, void _far *buffer, long count);
extern int _far _cdecl ibwrta (int handle, void _far *buffer, long count);
extern int _far _cdecl ibwrtf(int handle, char _far *filename);
extern int _far _cdecl ibxtrc (int handle, char _far *buffer, unsigned int count); 
extern int _far _cdecl ibbna (int handle, char _far *boardname);
extern int _far _cdecl ibclr (int handle);
extern int _far _cdecl ibdev (int board_index, int pad, int sad, int tmo, int eot, int eos);
extern int _far _cdecl ibpct (int handle);
extern int _far _cdecl ibrsp (int handle, char _far *spr);
extern int _far _cdecl ibtrg (int handle);

/* 488-2 function calls prototype  */
extern void _far _cdecl AllSpoll (int boardID, Addr4882_t _far *addrlist, short _far *resultlist);
extern void _far _cdecl DevClear (int boardID, Addr4882_t address);
extern void _far _cdecl DevClearList (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl EnableLocal (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl EnableRemote (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl FindLstn (int boardID, Addr4882_t  _far *padlist, Addr4882_t _far *resultlist, int limit);
extern void _far _cdecl FindRQS (int boardID, Addr4882_t _far *addrlist, short  _far *result);
extern void _far _cdecl PPoll (int boardID, short _far *result);
extern void _far _cdecl PPollConfig (int boardID, Addr4882_t address,int dataLine, int lineSense);
extern void _far _cdecl PPollUnconfig (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl PassControl (int boardID, Addr4882_t address);
extern void _far _cdecl RcvRespMsg (int boardID, void _far *buffer, long cnt, int termination);
extern void _far _cdecl ReadStatusByte (int boardID, Addr4882_t address, short  _far *result);
extern void _far _cdecl Receive (int boardID, Addr4882_t address, void _far *buffer, long cnt, int termination);
extern void _far _cdecl ReceiveSetup (int boardID, Addr4882_t address);
extern void _far _cdecl ResetSys (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl Send (int boardID, Addr4882_t address,void _far *buffer,long datacnt, int eotmode);
extern void _far _cdecl SendCmds (int boardID, void _far *buffer,long cnt);
extern void _far _cdecl SendDataBytes (int boardID, void _far *buffer,long cnt, int eot_mode);
extern void _far _cdecl SendIFC (int boardID);
extern void _far _cdecl SendLLO (int boardID);
extern void _far _cdecl SendList (int boardID, Addr4882_t _far *addrlist,void _far *buffer,long datacnt,int eotmode);
extern void _far _cdecl SendSetup (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl SetRWLS (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl TestSRQ (int boardID, short  _far *result);
extern void _far _cdecl TestSys (int boardID, Addr4882_t _far *addrlist, short  _far *resultlist);
extern void _far _cdecl Trigger (int boardID, Addr4882_t address);
extern void _far _cdecl TriggerList (int boardID, Addr4882_t _far *addrlist);
extern void _far _cdecl WaitSRQ (int boardID, short  _far *result);




