/* OS/2 Example Program 8 -- Parallel Polls with 488.2 Calls */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "decl.h"

int i;                                     /* Loop control variable*/
char buffer[101];                          /* Data received from the mixers */
unsigned short  ppresp;                    /* parallel poll response byte */           
unsigned short  done=0;                    /* set to 1 when all metals heated */
unsigned short  instruments[4]=
                     { 7, 8, 9, NOADDR };  /* PADs of mixers */


main() {

   /*Initialize the GPIB interface*/
   SendIFC(0);         
   if (ibsta & ERR)
      error("Could not send IFC");


   /*
   Configure each of the three mixers for parallel polls.  Mixer 1 will
   assert dataline 1, Mixer 2 dataline 2, and Mixer 3 dataline 3.  Sense
   is set to 1, which means the mixer will assert its line if its individual
   status bit is 1.
   */


      PPollConfig(0, instruments[0], 1, 1);
      if (ibsta & ERR) 
         error("Could not configure mixer 1 for PPoll");

      PPollConfig(0, instruments[1], 2, 1);
      if (ibsta & ERR) 
         error("Could not configure mixer 2 for PPoll");

      PPollConfig(0, instruments[2], 3, 1);
      if (ibsta & ERR) 
         error("Could not configure mixer 3 for PPoll");


   /*
   Loop until all three mixers have heated their alloy to the proper
   temperature (determined via parallel poll).  While waiting for
   mixers to finish heating, run internal routine UpdateScreen.
   */

   while (done==0) {                /* continue looping while metals heat   */

      UpdateScreen();             /* do screen update while metals heated */
      PPoll(0, &ppresp);          /* get PPoll response                   */
      ppresp &= 0xff;             /* only interested in low byte          */
      if (ppresp == 0x7)
         done = 1;                /* if all metals heated, we are finished */
   }

   /*All mixers are now ready, so send command to turn on motors */

   SendList(0, instruments, "MIX ON;", 7L, STOPend);

   /*Unconfigure (disable) parallel polls */

   PPollUnconfig(0, instruments);

   /*Take devices off-line*/
   ibonl (0,0);
}

error(char *errmsg){
   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   ibonl(0,0);
   exit(1);              /* abort program */
}

