/* OS/2 Example Program 1 -- Basic Communication */

#include <stdio.h>
#include "decl.h"

main() {
   
   int dmm;          /* file descriptor for digital multimeter */
   int i;            /* loop control variable*/
   char reading[30]; /* stores measurement readings from dmm */

   if ((dmm = ibfind("DMM")) < 0)
      report_error(dmm,"Could not open DMM");

   /*Set up dmm to measure VDC, autorange*/
   ibwrt(dmm, "VOLTS DC;AUTO", 13);
   if (ibsta & ERR)
      report_error(dmm,"Could not initialize DMM");

   /*Take 100 readings*/
   for (i=0; i < 100; i++) {
      /*Request voltage reading from dmm*/
      ibwrt(dmm, "VOLTS?", 6);     
      if (ibsta & ERR)
         report_error(dmm, "Could not trigger multimeter");

      /*Read data from dmm*/
      ibrd(dmm, reading, 20);       
      if (ibsta & ERR)
         report_error(dmm, "Could not read data from multimeter");
      /*Null terminate the string*/
      reading[20] = 0;          

      printf("Data read: %s\n", &reading);
  }

   /*Take dmm off-line*/
   ibonl(dmm, 0);     
}

report_error(int fd, char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   if (fd != -1) {
      printf("Cleanup: taking board off-line\n");
      ibonl(fd,0);
   }
   exit(1);              /* abort program */
}
