/* OS/2 Example Program 7 -- Serial Polls with 488.2 Calls */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "decl.h"

#define  DialogBox printf
#define  running  1              /* state1 = running */      
#define  done     2              /* state2 = done */
#define threshold 9              /* internally defined consistency threshold*/

unsigned char  buffer[10];       /* Data received from the serial poll */
unsigned short instruments[4]=
            { 1, 4 , 8, NOADDR };   /* Array of primary addresses*/
short          SRQ_seen;         /* Indicates whether SRQ occurred */
unsigned short result;           /* Result of FindRQS call*/
short          state=1;


main() {

   /* Make board controller in charge*/
   SendIFC(0);        
   if (ibsta & ERR)
      report_error("Could not send Interface Clear");

   /* Configure the strain gauges to request service when they have a
      significant pressure reading or a mechanical failure occurs */

   SendList(0,instruments, "SRQ=HI", 6L, NLend);
   if (ibsta & ERR)
         report_error("Could not send SRQ=HI to devices");

   while (state == running) {     /* while more data to collect */
      /* Wait for one or more of the strain gauges to request service */
      WaitSRQ(0, &SRQ_seen);
      if (ibsta & ERR)
         report_error("Error occurred while waiting for Service Request");

      /* Determine which of the strain gauges requested service */
      FindRQS(0,instruments,&result);
      if (ibsta & ERR)
         report_error("Error occurred while determining who requested service");

      if (result & 0x40)    
            Receive(0, instruments[ibcnt], buffer, 10, STOPend);

      /*Now print a dialog box to match the type of service requested*/
      if (buffer[0] >= threshold)
         DialogBox("The syrup in gauge %d is ready", instruments[ibcnt]);
      else     
         DialogBox("Gauge %d requires service", instruments[ibcnt]);
      /* Update the state of the gauges */
      UpdateState(&state);         

   }     

   /* Take the GPIB interface board off-line*/
   ibonl (0,0);
}

report_error(char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   ibonl (0,0);
   exit(1);              /* abort program */
}

