/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/* Copyright International Business Machines Corp. 1991, 1992.            */
/*                                                                        */
/* All Rights Reserved                                                    */
/*                                                                        */
/* Refer to "LICENSE.DOC" for information regarding the use of this file. */
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
#define yes         'y'
#define YES         'Y' /* capital letter to be input when user wants to     */
                        /* to answer positively to a question                */

#define play_file   'p'
#define PLAY_FILE   'P'

#define rcd_file    'r'
#define RCD_FILE    'R'

#define BLANK_70 "                                                                    "

#define CLEARSCRN 99
#define BLANK     98

/*****************************************************************************/
/* Title Messages - 80 characters wide / 2 lines each                        */
/*****************************************************************************/
#define TITLE_NUM  3
#define TITLE_LINE 2

#define PLAYBACK   0
#define RCD        1
#define GENERAL    2

char            title_msg     [TITLE_NUM][TITLE_LINE][80] = {
 "          Welcome to the IBM Audio Device Driver Playback Demo Program        \0",
 "                                                                              \0",

 "           Welcome to the IBM Audio Device Driver Record Demo Program         \0",
 "                                                                              \0",

 "           Welcome to the IBM Audio Device Driver Demo Program                \0",
 "                                                                              \0"
 };

/*****************************************************************************/
/* Copyright Message - 80 characters wide / 1 line */
/*****************************************************************************/
#define COPY_NUM  1
#define COPY_LINE 1

char            copyright_msg [COPY_NUM][COPY_LINE][80] = {
"           (C)Copyright IBM Corp. 1991, 1992.  ALL RIGHTS RESERVED            \0"
};

/*****************************************************************************/
/* User Input Messages  70 characters wide / 2 lines each                    */
/*****************************************************************************/
#define USER_NUM  10
#define USER_LINE 2

#define PLAYFILE  0
#define PLAYRCD   1
#define RCDFILE   2
#define TPQN      3
#define PMODE     4
#define PCMMODES  5
#define AVCMODES  6
#define CVSDMODES 7
#define INPMODE   8
#define OUTMODE   9

char            user_msg      [USER_NUM][USER_LINE][70] = {
"        Please enter the name of the MIDI standard file or the      \0",
"        waveform file that you would like to hear played:           \0",

"        Would you like to 'P'lay a music file or                    \0",
"        'R'ecord one? (enter 'p' or 'r') \0",

"        Please enter the name of the file you would                 \0",
"        like created:                                               \0",

"        Please enter the value for ticks per quarter note:          \0",
"                                                                    \0",

"        Please enter the mode you would like to use:                \0",
"                                                                    \0",

"        Please enter the sampling rate/bits per sample you          \0",
"        would like to use: \0",

"        Please enter the type of ADPCM you would like to use:       \0",
"                                                                    \0",

"        Please enter the type of CVSD you would like to use:        \0",
"                                                                    \0",

"        Please enter the type of input that you would like          \0",
"        to use: \0",

"        Please enter the type of output that you would like         \0",
"        to use: \0"

};

/*****************************************************************************/
/* Yes/No Question      no more than 69 characters wide / 1 line each        */
/*****************************************************************************/
#define YNQUEST_NUM  1
#define YNQUEST_LINE 1

#define WANTVERBOSE  0

char            ynquest_msg   [YNQUEST_NUM][YNQUEST_LINE][70] = {
"      Do you want to see all intermediate information messages? \0"
};

/*****************************************************************************/
/* Volume/Balace Help   no more than 70 characters wide / 1 line each        */
/*****************************************************************************/
#define VBHELP_NUM  1
#define VBHELP_LINE 1

#define VOLBAL      0

char            vbhelp_msg    [VBHELP_NUM][VBHELP_LINE][70] = {
"    Press 0 - 9 to set volume, 'L','M','R' to set balance.          \0"
};

/*****************************************************************************/
/* Status Messages  70 characters wide / 1 line each                         */
/*****************************************************************************/
#define STATUS_NUM  5
#define STATUS_LINE 1

#define EXITDEMO    0
#define LOADING     1
#define STARTSTOP   2
#define CONTINUE    3
#define CONTESC     4

char            status_msg    [STATUS_NUM][STATUS_LINE][70] = {
"              Press ESC to exit demo program                        \0",

"      Loading code                                                  \0",

"         Press space bar to start/stop, Esc to quit.                \0",

"         Press any key to continue......                            \0",

"         Press <ESC> to continue.....                               \0"
};

/*****************************************************************************/
/* Error Messages  70 characters wide / 4 lines each                         */
/*****************************************************************************/
#define ERROR_NUM   38
#define ERROR_LINE  4

#define DOESNTEXIST    0
#define HDRTOOBIG      1
#define ERRHDRDATA     2
#define NOMEMORY       3
#define ERRTRKDATA     4
#define FILNOTFNDP     5
#define FILNOTFNDR     6
#define EINITIOCTL     7
#define ETIMEINIT      8
#define READAUD        9
#define DISKFULL       10
#define INITFAILED     11
#define HPIIOCTL       12
#define DSPOPEN        13
#define NOMEMDSP       14
#define UNRECOG        15
#define UNSUPRIFF      16
#define NOTPCMDATA     17
#define ECHNGIOCTL     18
#define NOMEMSYS       19
#define EAUDIOLOAD     20
#define EDSPLOAD       21
#define MALLOCERR      22
#define BATCHFUNC      23
#define BATCHNUMP      24
#define CBINVALID      25
#define NUMINVALID     26
#define SIZEINVALID    27
#define NOSIZE         28
#define NONUM          29
#define CREATESEM      30
#define CLOSESEM       31
#define WAITIOCTL      32
#define EUPDATEIOCTL   33
#define DELAYINVALID   34
#define EUPDATEINVALID 35
#define EUPDATEMIDI    36
#define EUPDATEWREC    37

char            error_msg     [ERROR_NUM][ERROR_LINE][70] = {
"                                                                    \0",
"                Open failed, file does not exist.                   \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                Header Chunk too big for buffer.                    \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                Error reading header data.                          \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                Not enough memory to load track data.               \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                Error reading track data.                           \0",
"                                                                    \0",
"                                                                    \0",

"          Unable to open the input file:                            \0",
"                                                                    \0",
"                                                                    \0",
"          Please check the file name and enter it again.            \0",

"          Unable to open the output file:                           \0",
"                                                                    \0",
"                                                                    \0",
"          Please check the file name and enter it again.            \0",

"                                                                    \0",
"          Error from init IOCTL:                                    \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"          Error writing timinit:                                    \0",
"                                                                    \0",
"                                                                    \0",

"      Error reading data from Audio Device:                         \0",
"                                                                    \0",
"             Bytes being read: \0",
"             Total bytes written: \0",

"             Error writing data to:                                 \0",
"                                                                    \0",
"                                                                    \0",
"                Disk may be full.                                   \0",

"                                                                    \0",
"          Initialization of the Audio device was unsuccessful.      \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"          Error on Audio High Performance Interface IOCTL:          \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"          Cannot open DSP file:                                     \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"          Not enough memory to load DSP module.                     \0",
"                                                                    \0",
"                                                                    \0",

"     File format is not recognized as either of the supported       \0",
"     formats for this program. Supported formats are MIDI Standard  \0",
"     Files and RIFF Waveform, MIDI Audio, or 'ibmw' file formats.   \0",
"                                                                    \0",

"     RIFF file format is not supported.                             \0",
"                                                                    \0",
"     'WAVE', 'RMID', and 'ibmw' form types are the only supported   \0",
"     RIFF file formats.                                             \0",

"                                                                    \0",
"     File contains an unsupported waveform data type.               \0",
"     ADPCM, PCM, A Law, and Mu Law are supported by this program.   \0",
"                                                                    \0",

"                                                                    \0",
"          Error from Audio Change IOCTL call:                       \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"     System Exclusive message is too large.                         \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Error from AUDIO_LOAD IOCTL call:                            \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Error from DSPLOAD call:                                     \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Not enough memory available for buffers.                     \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Invalid function specified, batch mode aborted.              \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Not enough parameters specified for /B option.               \0",
"       Batch mode aborted.                                          \0",
"                                                                    \0",

"                                                                    \0",
"       Invalid callback mask or number specified.                   \0",
"       No callback will be done.                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Invalid audio device number specified.                       \0",
"       '1' is being used.                                           \0",
"                                                                    \0",

"                                                                    \0",
"       Buffer size too large. 65000 is being used.                  \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Not enough buffer sizes were specified.                      \0",
"       Remaining buffers will have a size of 0.                     \0",
"                                                                    \0",

"                                                                    \0",
"       Number of buffers was not specified.                         \0",
"       1 buffers is being used.                                     \0",
"                                                                    \0",

"                                                                    \0",
"       Error creating semaphore.                                    \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Error closing semaphore.                                     \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Error from AUDIO_WAIT call:                                  \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"       Error from AUDIO_UPDATE call:                                \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                Invalid delay specified.                            \0",
"                No delay will be done.                              \0",
"                                                                    \0",

"     AUDIO_UPDATE with this DEMO program requires the use of the    \0",
"     /p option if playing data or the /r option if recording data   \0",
"     with at least 3 buffers specified.                             \0",
"     AUDIO_UPDATE will not be used.                                 \0",

"                                                                    \0",
"     AUDIO_UPDATE (/u) is not supported for MIDI mode in this       \0",
"     DEMO program.                                                  \0",
"                                                                    \0",

"                                                                    \0",
"     AUDIO_UPDATE (/u) is not supported for the RECORD operation    \0",
"     in this DEMO program.                                          \0",
"                                                                    \0"

};

/*****************************************************************************/
/* Help Messages  70 characters wide / 9 lines each                          */
/*****************************************************************************/
#define HELP_NUM   13
#define HELP_LINE  9

#define NOFNAMEP   0
#define NODDINSTAL 1
#define PLAYING1   2
#define ENTERPR    3
#define NOFNAMER   4
#define RECORD1    5
#define MODEDEFS   6
#define MODEPCM    7
#define MODEAVC    8
#define MODELAW    9
#define MODECVSD   10
#define INPUTLIST  11
#define OUTPUTLIST 12

char            help_msg      [HELP_NUM][HELP_LINE][70] = {
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",
"     Please enter the name of the MIDI standard file or the         \0",
"     Waveform file that you would like to hear played on            \0",
"     the adapter.                                                   \0",
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",

"      Unable to locate the AUDIO device: \0",
"      Please ensure that the AUDIO Device Driver is installed.      \0",
"      This requires the following statment in the CONFIG.SYS file:  \0",
"          DEVICE = <drive>: <path> <device driver name>.sys         \0",
"      After entering this in the config.sys file, reboot the        \0",
"      system to install the device driver and run the demo again.   \0",
"                                                                    \0",
"      This may also occur if the adapter is being exclusively used  \0",
"      by another process or all tracks are currently being used.    \0",

"  Playing data from:   \0",
"  Using Device Driver: \0",
"                                                                    \0",
"  Status:  \0",
"  Volume:  \0",
"  Balance: \0",
"  Total bytes played:  \0",
"  Total bytes written: \0",
"                                                                    \0",

"                                                                    \0",
"                                                                    \0",
"    Please enter either a 'P' to play a music data file             \0",
"                            or                                      \0",
"    enter a 'R' to record music and create a standard MIDI file.    \0",
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"                                                                    \0",
"                                                                    \0",
"     Please enter the name of the MIDI standard file that you would \0",
"     like to be created from the music being recorded.              \0",
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",
"                                                                    \0",

"                                                                    \0",
"  Recording MIDI data to: \0",
"  Using Device Driver:    \0",
"                                                                    \0",
"  Status: \0",
"                                                                    \0",
"  Total bytes read: \0",
"                                                                    \0",
"                                                                    \0",

"   The following is a list of recognized modes:                     \0",
"                                                                    \0",
"   Standard MIDI files   :  MIDI                                    \0",
"   ADPCM files           :  ADPCM                                   \0",
"   Mu-Law Companding     :  MU_LAW                                  \0",
"   A-Law Companding      :  A_LAW                                   \0",
"   Pulse Code Modulation :  PCM                                     \0",
"                         :  CVSD                                    \0",
"                                                                    \0",

"   Enter the combination as: xKys                                   \0",
"      where x - sample rate                                         \0",
"            y - bits per sample                                     \0",
"            s - letter 'S' if you would like stereo                 \0",
"                                                                    \0",
"   Supported sampling rates :  7  8  11  22  315  44  48            \0",
"   Supported bits per sample:  8  16                                \0",
"                                                                    \0",
"   Example: 8K8S - 8k sample rate, 8 bits per sample, stereo mode   \0",

"                                                                    \0",
"   The following is a list of recognized ADPCM modes:               \0",
"                                                                    \0",
"                   VOICE                                            \0",
"                   MUSIC                                            \0",
"                   STEREO                                           \0",
"                   HQ                                               \0",
"                                                                    \0",
"                                                                    \0",

"   Enter the combination as: xKys                                   \0",
"      where x - sample rate                                         \0",
"            y - bits per sample                                     \0",
"            s - letter 'S' if you would like stereo                 \0",
"                                                                    \0",
"   Supported sampling rates :  7  8  11  22  315  44  48            \0",
"   Supported bits per sample:  8                                    \0",
"                                                                    \0",
"   Example: 8K8S - 8k sample rate, 8 bits per sample, stereo mode   \0",

"                                                                    \0",
"   The following is a list of recognized CVSD modes:                \0",
"                                                                    \0",
"                   0                                                \0",
"                   1                                                \0",
"                   2                                                \0",
"                   3                                                \0",
"                   4                                                \0",
"                   5                                                \0",

"   The following is a list of recognized inputs:                    \0",
"                                                                    \0",
"   NULL_INPUT           0         HANDSET_INPUT            7        \0",
"   STEREO_LINE_INPUT    1         SYNTH_INPUT              8        \0",
"   LEFT_LINE_INPUT      2         DIGITAL_PHONE_LINE_INPUT 9        \0",
"   RIGHT_LINE_INPUT     3         DIGITAL_HANDSET_INPUT    10       \0",
"   MIC_INPUT            4         MIDI_IN_PORT             11       \0",
"   BOOSTED_MIC_INPUT    5         LOOPBACK                 12       \0",
"   PHONE_LINE_INPUT     6                                           \0",

"   The following is a list of recognized outputs:                   \0",
"                                                                    \0",
"   NULL_OUTPUT           0         PHONE_LINE_OUTPUT         6      \0",
"   STEREO_LINE_OUTPUT    1         HANDSET_OUTPUT            7      \0",
"   LEFT_LINE_OUTPUT      2         SYNTH_OUTPUT              8      \0",
"   RIGHT_LINE_OUTPUT     3         DIGITAL_PHONE_LINE_OUTPUT 9      \0",
"   SPEAKER_OUTPUT        4         DIGITAL_HANDSET_OUTPUT    10     \0",
"   HEADSET_OUTPUT        5         MIDI_OUT_PORT             11     \0",
"                                                                    \0"
};

/*****************************************************************************/
/* Warning Messages 70 characters wide / 4 lines each                        */
/*****************************************************************************/
#define WARNING_NUM  13
#define WARNING_LINE 3

#define BESTFIT   0
#define NOMODE    1
#define DISCARD   2
#define NOTES     3
#define UNCHUNK   4
#define TPQNVAL   5
#define NORATE    6
#define NOADPCM   7
#define UNDERRUN  8
#define OVERRUN   9
#define NOCVSD    10
#define INPINVALID 11
#define OUTINVALID 12

char            warning_msg   [WARNING_NUM][WARNING_LINE][70] = {
"         The configuration specified for the initialization         \0",
"         of the device driver is not supported.  The device         \0",
"         driver has been configured to the closest fit possible.    \0",

"         No mode was entered or mode entered was not recognized.    \0",
"         Please enter mode again.                                   \0",
"                                                                    \0",

"                                                                    \0",
"         Discarding received data bytes: \0",
"                                                                    \0",

"                                                                    \0",
"         Warning: More NOTE OFFs than NOTE ONs                      \0",
"                                                                    \0",

"                                                                    \0",
"         Warning: Ignoring unrecognized chunk                       \0",
"                                                                    \0",

"        The ticks per quarter note must be a multiple of 24         \0",
"        with the lowest supported value of 48 and a maximum         \0",
"        of 384 ticks per quarter note.                              \0",

"         No sample rate/bits per sample was entered or it was       \0",
"         not recognized as a supported combination.                 \0",
"         Please enter again.                                        \0",

"         ADPCM option was not recognized as a supported option.     \0",
"                                                                    \0",
"         Please enter again.                                        \0",

"                                                                    \0",
"                  Underrun Occurred                                 \0",
"                                                                    \0",

"                                                                    \0",
"                  Overrun Occurred                                  \0",
"                                                                    \0",

"         CVSD option was not recognized as a supported option.      \0",
"                                                                    \0",
"         Please enter again.                                        \0",

"                                                                    \0",
"       Invalid input source specified.                              \0",
"                                                                    \0",

"                                                                    \0",
"       Invalid output source specified.                             \0",
"                                                                    \0"

};

/*****************************************************************************/
/* Command Line Argument Help / 19 lines each                                */
/*****************************************************************************/
#define CLHELP_NUM  2
#define CLHELP_LINE 19

#define HELPHELP  0
#define BATCHHELP 1

char            clhelp_msg   [CLHELP_NUM][CLHELP_LINE][70] = {
"     Format for running:   DEMO [options]                           \0",
"/C x mask   Use callback function where x: unique number 1-9 mask:  \0",
"            DATA-256 IOBUF-1024 BLOCK-512 ERROR-2048 UNDERRUN-4096  \0",
"/D x        Delay to add to any volume/balance changes              \0",
"/I          Want to specify input other than default                \0",
"/M x        Monitor for Record 0=off 1=uncompressed 3=compressed    \0",
"/N x        Specify audio device number - DEFAULT = 1               \0",
"/O          Want to specify output other than default               \0",
"/P x y {y}  Specify buffer size(s) for Play operation where x       \0",
"            specifies the number of buffers and y {y} specifies the \0",
"            lengths of the buffers. Buffer size must be <65000 bytes\0",
"            DEFAULT - 1 buffer of 60000 bytes                       \0",
"/R x y {y}  Same as /P option, but for Record operation.            \0",
"/S          Suppress display of byte counts (default no suppression)\0",
"/T          Display the position value at the end of the operation. \0",
"/U          Use AUDIO_UPDATE function                               \0",
"/V x        Master Volume - where x is the value for master volume  \0",
"/W          Use AUDIO_WAIT function to end the song(default no wait)\0",
"                                                                    \0",

"format for /B option: /B <function> <filename> <mode> <time>        \0",
"                                                                    \0",
"where <function>: p - PLAY       r - RECORD                         \0",
"      <filename>: name of file to be played/recorded                \0",
"      <mode>    : 0  - MIDI                                         \0",
"                : 1  - ADPCM VOICE                                  \0",
"                : 2  - ADPCM MUSIC                                  \0",
"                : 3  - ADPCM STEREO                                 \0",
"                : 4  - ADPCM HQ                                     \0",
"         PCM    : 10 - 8K8        18 - 8K8S       70 - 7K8          \0",
"                : 11 - 8K16       19 - 8K16S      71 - 7K16         \0",
"                : 12 - 11K8       20 - 11K8S      72 - 315K8        \0",
"                : 13 - 11K16      21 - 11K16S     73 - 315K16       \0",
"                : 14 - 22K8       22 - 22K8S      74 - 48K8         \0",
"                : 15 - 22K16      23 - 22K16S     75 - 48K16        \0",
"                : 16 - 44K8       24 - 44K8S    (add 10 for stereo  \0",
"                : 17 - 44K16      25 - 44K16S    for modes 70-75)   \0",
"      <time>    : Number of seconds to record                       \0",
"      MU-LAW = PCM+20          A-LAW = PCM+40                       \0"
};


/*****************************************************************************/
/* Extra Messages Inside existing messages / 1 line each                     */
/*****************************************************************************/
#define EXTRA_NUM  2

#define POSITION  0
#define CBCOUNT   1

char            extra_msg   [EXTRA_NUM][70] = {
"  Position: \0",

"  Callback Count: \0"
};


/*****************************************************************************/
/* File Type Messages                                                        */
/*****************************************************************************/
#define FILE_TYPE  43

/* Already #defined in */
#define  MIDI_MODE       0
#define  AVC_VOICE       1
#define  AVC_MUSIC       2
#define  AVC_STEREO      3
#define  AVC_HQ          4
#define  PCM8k8b         5
#define  PCM11k8b        6
#define  PCM22k8b        7
#define  PCM44k8b        8
#define  PCM8k16b        9
#define  PCM11k16b       10
#define  PCM22k16b       11
#define  PCM44k16b       12
#define  OTHER8bPCM      13
#define  OTHER16bPCM     14
#define  SOURCE_MIX_MODE 15
#define  MULAW8K        16
#define  MULAW11K       17
#define  MULAW22K       18
#define  MULAW44K       19
#define  ALAW8K         20
#define  ALAW11K        21
#define  ALAW22K        22
#define  ALAW44K        23
#define  CLAIM_HDWR_MODE 24
#define  CVSD_0          25
#define  CVSD_1          26
#define  CVSD_2          27
#define  CVSD_3          28
#define  CVSD_4          29
#define  CVSD_5          30
#define  PCM7k8b         31
#define  PCM315k8b       32
#define  PCM48k8b        33
#define  PCM7k16b        34
#define  PCM315k16b      35
#define  PCM48k16b       36
#define  MULAW78K        37
#define  MULAW315K       38
#define  MULAW48K        39
#define  ALAW78K         40
#define  ALAW315K        41
#define  ALAW48K         42

char            file_type_msg   [FILE_TYPE][20] = {
"MIDI ",
"ADPCM VOICE ",
"ADPCM MUSIC ",
"ADPCM STEREO ",
"ADPCM HIGH QUALITY ",
"PCM 8k 8bit ",
"PCM 11K 8bit ",
"PCM 22K 8bit ",
"PCM 44K 8bit ",
"PCM 8K 16bit ",
"PCM 11K 16bit ",
"PCM 22K 16bit ",
"PCM 44K 16bit ",
"Other 8bit PCM ",
"Other 16bit PCM ",
"Source Mix ",
"Mu-Law 8K 8bit ",
"Mu-Law 11K 8bit ",
"Mu-Law 22K 8bit ",
"Mu-Law 44K 8bit ",
"A-Law 8K 8bit ",
"A-Law 11K 8bit ",
"A-Law 22K 8bit ",
"A-Law 44K 8bit ",
"Claim Hardware ",
" CVSD - 0 ",
" CVSD - 1 ",
" CVSD - 2 ",
" CVSD - 3 ",
" CVSD - 4 ",
" CVSD - 5 ",
"PCM 7875K 8bit ",
"PCM 31500K 8bit ",
"PCM 48000K 8bit ",
"PCM 7875K 16bit ",
"PCM 31500K 16bit ",
"PCM 48000K 16bit ",
"Mu-Law 7875K 8bit ",
"Mu-Law 31500K 8bit ",
"Mu-Law 48000K 8bit ",
"A-Law 7875K 16bit ",
"A-Law 31500K 16bit ",
"A-Law 48000K 16bit "
};


/*****************************************************************************/
/* Mone/Stereo Messages                                                      */
/*****************************************************************************/
#define MONO_STEREO 3

#define NONE      0
#define MONO      1
#define STEREO    2


char            mono_stereo_msg [MONO_STEREO][7] = {
"    ",
"Mono",
"Stereo"
};

