/*********************************************************************/
/*								     */
/*  INCLUDE NAME = 2play.h					     */
/*								     */
/*  DESCRIPTIVE NAME = AAPI Two Track Play Example messages	     */
/*								     */
/*  COPYRIGHT = (C) Copyright IBM Corp. 1991.			     */
/*		All rights reserved.				     */
/*		Refer to "LICENSE.DOC" for information regarding     */
/*		the use of this file.				     */
/*								     */
/*								     */
/* Unless otherwise specified all messages are restricted to a	     */
/* maximum length of 80 visual characters per line.  Messages may    */
/* span multiple lines by inserting carriage return/linefeed (\r\n)  */
/* characters into the message. Total number of characters in the    */
/* message is restricted to 256.				     */
/*								     */
/*********************************************************************/
#define M_0 "Enter file name to play (Enter for source mix) ==> "
#define M_1 "\nEnter 2nd file name to play (or Enter for none) ==> "
#define M_2 "\n        Press any other key to stop......\n\r\n"
#define M_3 "\n\r\nInsufficient storage to complete operation.\r\n"
#define M_4 "\n\r\nOpen failed, file already exists.\n\r\n"
#define M_5 "\n\r\nOpen failed, file does not exist.\n\r\n"
#define M_6 "\n\r\nGeneral error on audio file.\n\r\n"
#define M_7 "\n\r\nGeneral error on escape file.\n\r\n"
#define M_8 "Signal processor on M-ACPA not responding.\n"
#define M_9 "Audio card software not installed (IBMxxxx.DSP).\n"
#define M_10 "Audio card software damaged or invalid (IBMxxxx.DSP).\n"
#define M_11 "Audio card not installed.\n"
#define M_12 "Audio device driver not installed or in use.\n"
/*********************************************************************/
/*  M-13 - Variable %d can expand to 4 visual characters.	     */
/*********************************************************************/
#define M_13 "Error, can not continue -  AAPI rc = %d\n"
/*********************************************************************/
/*  M-14 - Message M_31 is appended to this message.		     */
/*	   Maximum length is 40 characters or a new line	     */
/*	   must be started.					     */
/*********************************************************************/
#define M_14 "Playing time\\volume\\balance = "
#define M_15 "MIDI audio type can not be played in DOS or on channel A."
#define M_16 "\n\r\nFile is not an audio file.\n\r\n"
#define M_17 " Master Volume                          (0-120 : Enter = 100) ==> "
#define M_18 " Fade to Volume                         (0-100 : Enter = 100) ==> "
#define M_19 " Length of fade in seconds             (0 - 64 : Enter =   0) ==> "
#define M_20 " Balance                   (0=Left - 100=Right : Enter =  50) ==> "
#define M_21 " Length of pan in  seconds             (0 - 64 : Enter =   0) ==> "
#define M_22 "\n\r\nInvalid combination - can not play these file types together.\n\r\n"
#define M_23 "Requested operation requires DSP reload. Stop current operation first.\n"
#define M_24 "\nPress F1 (track 1) or F2 (track 2) or F3 (both) to start/pause/resume\n\r"
#define M_25 "\n\r\nCan not play ADPCM or MIDI with PCM file\n\r\n"
#define M_26 "\nUse the keys below to control volume/balance on Track 1\n\r"
#define M_27 "    (For Track 2 use Ctrl + key) \n\r"
#define M_28 "    Cursor keys        -  Volume/Balance \n\r"
#define M_29 "    Home, End          -  Pans left/right over 7 seconds \n\r"
#define M_30 "    Page Up, Page Down -  Fades up/down over 7 seconds\n\r"
/*********************************************************************/
/*  M-31 - Variables represent					     */
/*	     Track 1 Playing Time, Volume, Balance		     */
/*	     Track 2	"             "      "                       */
/*  This message is appended to M_14.				     */
/*  Message can expand to a maximum of 40 visual characters.	     */
/*********************************************************************/
#define M_31 "%lu %d %d      %lu %d %d      \r"
#define M_32 " Signal processor track      (1 or 2, Enter = any available ) ==> "
#define M_33 " Enter for no file,                          (1 = source mix) ==> "
#define M_34 " Source Mix                            (1 = yes, Enter =  no) ==> "
#define M_35 " Input Source (0=mic, 1=left, 2=right, Enter=both, 4=low-mic) ==> "
#define M_36 " Display volume/balance choices        (1 = yes, Enter =  no) ==> "
#define M_37 " Display other option choices          (1 = yes, Enter =  no) ==> "
#define M_38 " PS/2 speaker (right channel only)     (1 = on,  Enter = off) ==> "
#define M_39 " Invalid value, try again or Ctrl Break to exit\n\r"
#define M_40 "Start or stop position invalid.\n"
#define M_41 " Start position in milliseconds       (Enter = start of file) ==> "
#define M_42 " End   position in milliseconds       (Enter = end   of file) ==> "
#define M_43 " Loop the file                         (1 = yes, Enter =  no) ==> "
#define M_44 "\nM-ACPA Audio API Sample Play Program \n\r"
#define M_45 "(C) Copyright IBM Corp. 1991 - All Rights Reserved.\n\r\n"
#define M_46 "\n\r\nAn AVC MIDI file can only be played with a voice file.\r\n"
/*								     */
