/******************************************************************************/
/******************************************************************************/
/* JPEG.H - JPEG API Include file                                             */
/******************************************************************************/
/******************************************************************************/
#ifndef BYTE
  #define BYTE             unsigned char
#endif

#ifndef USHORT
  typedef unsigned short   USHORT;
#endif

#ifndef UCHAR
  typedef unsigned char    UCHAR;
#endif

#ifndef ULONG
  typedef unsigned long    ULONG;
#endif



/******************************************************************************/
/******************************************************************************/
/* Operation field definitions                                               */
/******************************************************************************/
/******************************************************************************/
#define DECOMPRESS            0x0000
#define COMPRESS              0x0001
#define NO_COLOR_CONVERT      0x0000
#define COLOR_CONVERT         0x0002
#define SINGLE_BUFFER         0x0000
#define MULTIPLE_BUFFER       0x0004
#define START_IMAGE           0x0008
#define INTERMEDIATE_SCAN     0x0010
#define END_OF_SCAN           0x0018
#define END_OF_IMAGE          0x0020
#define CALL_FIELD            0x0038
#define BIT_MAP               0x0040
#define NO_BIT_MAP            0x0000


/* Color Convert codes */
#define RGB888                0x0000
#define RGB565                0x0001
#define INT565                0x0002
#define YUV                   0x0003
#define YYUV                  0x0004



/******************************************************************************/
/******************************************************************************/
/* Structures used by JPEG_base()                                             */
/******************************************************************************/
/******************************************************************************/


/******************************************************************************/
/* Pixel Buffer                                                               */
/******************************************************************************/
typedef struct buffer {
  BYTE far     *bufad;          /* address of buffer                          */
  USHORT        buflen;         /* no. bytes in buffer not counting the Buffer*/
                                /*   structure                                */
/***** Hidden Variable ************/
  USHORT        buflim;         /* Reserved for system use                    */

  USHORT        bufused;        /* no. bytes already used                     */
  BYTE far     *bufpt;          /* ptr to last BYTE read/written              */
  struct buffer far  *nextbuf;  /* next buffer descriptor in chain            */
} BUFFER;



/******************************************************************************/
/* Warning Elements of WARN_STRUCT                                            */
/******************************************************************************/
typedef struct warn_ele {
   USHORT WarnErrorCode;
   USHORT data_element;
   int   data_value;
} WARN_ELE;



/******************************************************************************/
/* Warning Structure of COM_AREA                                              */
/******************************************************************************/
typedef struct warn_struct {
    WARN_ELE  *ImageFrame;
    WARN_ELE  *Component;
    WARN_ELE  *Scan;
    WARN_ELE  *JPEG_Tab;
    WARN_ELE  *HuffTab;
    WARN_ELE  *QuantTab;
    WARN_ELE  *Samples;
    WARN_ELE  *DNL;
    WARN_ELE  *Pars;

    USHORT    NumImageFrame;
    USHORT    NumComponent;
    USHORT    NumScan;
    USHORT    NumJPEG_Tab;
    USHORT    NumHuffTab;
    USHORT    NumQuantTab;
    USHORT    NumSamples;
    USHORT    NumDNL;
    USHORT    NumPars;
} WARN_STRUCT;



/******************************************************************************/
/* COM_AREA                                                                   */
/******************************************************************************/
typedef struct com_area{
   char        BegAreaID[10];   /* Should contain the string ComArea          */
   USHORT      operation;
   USHORT      InputColorSpace;
   USHORT      OutputColorSpace;
   WARN_ELE    error;           /* Error structure                            */
   USHORT      warning_flags;   /* Bit string showing which warnings occurred */
   WARN_STRUCT warnings;        /* Warning structure                          */

/******* Hidden Variable **************/
   USHORT      SampleCode;      /* Reserved for systen use                    */

   char        EndAreaID[10];   /* Should contain the string ComArea          */
} COM_AREA;
