/*------------------------------------------------------------------------------
   WINSAMP.C -- Sample Driver for JPEG Microsoft Windows 3.0 DLL

Copyright International Business Machines Corp. 1991
All Rights Reserved
Refer to "LICENSE.DOC" for information regarding the use of this file.

------------------------------------------------------------------------------*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <string.h>
#include <malloc.h>

#include "winsamp.h"

#include "jpeg.h"
#include "jpegerr.h"

#define MAXLEN  50

/******************************************************************************/
/* Function Prototypes                                                        */
/******************************************************************************/
int   openbuff(char *fpvSource, char *fpvDestination, COM_AREA *IoType,
               USHORT *JPEGHandle, USHORT *CoefHandle);
int   openPIX(char *file, USHORT options, int *file_handle);
int   PixelRead(int PixelHandle, BUFFER *PixelBuffer, COM_AREA *ComArea);
int   PixelWrite(int PixelHandle, BUFFER *PixelBuffer, COM_AREA *ComArea);
void  TestErrMsg(char *mod, char *mess, int rc);
int   TestWarnMsg(char *mod, char *mess);
int  _loadds JPEG_base(int  JPEGHandle,int  CoefHandle,struct  buffer _far * _far *PixelBuffer,struct  com_area *iotype);

long  FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

char szAppName [] = "JPEGTest" ;
char szInputFile  [MAXLEN];
char szOutputFile  [MAXLEN];
char szHeaderFile  [MAXLEN];

/******************************************************************************/
/* WinMain() - Create Main Window and Dispatch Messages                       */
/******************************************************************************/
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
      HWND        hwnd ;
      MSG         msg ;
      WNDCLASS    wndclass ;

      if (!hPrevInstance)
      {
        wndclass.style            = CS_HREDRAW | CS_VREDRAW ;
        wndclass.lpfnWndProc      = WndProc ;
        wndclass.cbClsExtra       = 0 ;
        wndclass.cbWndExtra       = 0 ;
        wndclass.hInstance        = hInstance;
        wndclass.hIcon            = LoadIcon (NULL, IDI_APPLICATION);
        wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground    = GetStockObject (WHITE_BRUSH);
        wndclass.lpszMenuName     = szAppName;
        wndclass.lpszClassName    = szAppName;

        RegisterClass (&wndclass) ;
      } /* endif */

      hwnd = CreateWindow (szAppName,             // window class name
                     "JPEG Codec",                // window caption
                     WS_OVERLAPPEDWINDOW,         // window style
                     CW_USEDEFAULT,               // initial x position
                     CW_USEDEFAULT,               // initial y position
                     750,                         // initial x size
                     300,                         // initial y size
                     NULL,                        // parent window handle
                     NULL,                        // window menu handle
                     hInstance,                   // program instance handle
                     NULL);                       // creation parameters

      ShowWindow (hwnd, nCmdShow) ;
      UpdateWindow (hwnd);

      while (GetMessage (&msg, NULL, 0, 0))
      {
        TranslateMessage (&msg) ;
        DispatchMessage (&msg) ;
      } /* endwhile */

      return msg.wParam ;

} /* End of WinMain() */

/******************************************************************************/
/* DlgProc() - Process dialog to get filenames                                */
/******************************************************************************/
BOOL FAR PASCAL DlgProc (HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
   switch (message)
   {
      case WM_INITDIALOG :
           SendDlgItemMessage (hDlg, IDD_INPSTRING, EM_LIMITTEXT,
                               MAXLEN-1, 0L) ;
           SendDlgItemMessage (hDlg, IDD_OUTSTRING, EM_LIMITTEXT,
                               MAXLEN-1, 0L) ;
           SendDlgItemMessage (hDlg, IDD_HDRSTRING, EM_LIMITTEXT,
                               MAXLEN-1, 0L) ;
           return TRUE ;

      case WM_COMMAND :
           switch (wParam)
           {
              case IDOK :
                   GetDlgItemText (hDlg, IDD_INPSTRING, szInputFile, MAXLEN) ;
                   GetDlgItemText (hDlg, IDD_OUTSTRING, szOutputFile, MAXLEN) ;
                   GetDlgItemText (hDlg, IDD_HDRSTRING, szHeaderFile, MAXLEN) ;
                   EndDialog (hDlg, TRUE) ;
                   return TRUE ;

              case IDCANCEL :
                   EndDialog (hDlg, FALSE) ;
                   return TRUE ;
           } /* endswitch */
   } /* endswitch */

   return FALSE ;
} /* End of DlgProc() */

/******************************************************************************/
/* WndProc() - Compress/Decompress                                            */
/******************************************************************************/
long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
   static FARPROC lpfnDlgProc;
   static HANDLE  hInst ;
   static short   cxChar, cyChar, cxClient, cyClient;
   FILE *fileptr;
   HDC            hdc ;
   PAINTSTRUCT    ps ;
   TEXTMETRIC     tm ;

   int         bytes_read_written, ret;
   COM_AREA    iotyp;
   int         PixelHandle;
   int         CoefHandle;
   int         JPEGHandle;
   BUFFER far *PixelBuffer;

   switch (message)
   {
      case WM_CREATE :
           hInst = ((LPCREATESTRUCT) lParam)->hInstance ;

           lpfnDlgProc        = MakeProcInstance (DlgProc, hInst) ;

           hdc = GetDC (hwnd) ;
           GetTextMetrics (hdc, &tm) ;
           cxChar = tm.tmAveCharWidth ;
           cyChar = tm.tmHeight + tm.tmExternalLeading ;
           ReleaseDC (hwnd, hdc) ;

           return 0 ;

      case WM_COMMAND :
           switch (wParam)
           {
              case IDM_COMPRESS:
                   if (DialogBox (hInst, "CompDlg", hwnd, lpfnDlgProc))
                   {
                      iotyp.operation = COMPRESS;

      /* Open input header file and output compressed image file */
                      if ((ret = openbuff(szHeaderFile, szOutputFile, &iotyp,
                          &JPEGHandle, &CoefHandle)) == ERROR_RETURN)
                      {
                         MessageBox(hwnd,
                                    "Error opening parameter file or output file.",
                                    "COMPRESS ERROR",
                                    MB_OK | MB_ICONSTOP);
                         return 0;
                      } /* endif */

      /* Open input bitmap file with RGB data */
                      if ((ret = openPIX(szInputFile, O_RDONLY, &PixelHandle))
                          == ERROR_RETURN)
                      {
                         MessageBox(hwnd,
                                    "Error opening bitmap file.",
                                    "COMPRESS ERROR",
                                    MB_OK | MB_ICONSTOP);
                         close(JPEGHandle);
                         close(CoefHandle);
                         return 0;
                      } /* endif */

      /* While there is data to process and there are no errors */
                      for (strcpy(iotyp.BegAreaID,"ComArea"),
                           strcpy(iotyp.EndAreaID,"ComArea"),
                           iotyp.operation |= START_IMAGE,
                           ret = SUCCESS,bytes_read_written = 0;
                           ((iotyp.operation & CALL_FIELD) != END_OF_IMAGE) &&
                               (bytes_read_written != -1) &&
                               (ret != ERROR_RETURN); )
                      {

          /* Read data from the input bitmap file */
                          if ((iotyp.operation & CALL_FIELD) != START_IMAGE)
                          {
                              /* Not initial call.  On initial call,
                              jpeg_base allocates pixel buffer */
                              bytes_read_written = PixelRead(PixelHandle,PixelBuffer,&iotyp);
                              if (bytes_read_written == ERROR_RETURN)
                              {
                                 MessageBox(hwnd,
                                            "Error reading from bitmap file.",
                                            "COMPRESS ERROR",
                                            MB_OK | MB_ICONSTOP);
                                 close(PixelHandle);
                                 close(JPEGHandle);
                                 close(CoefHandle);
                                 return 0;
                              } /* endif */
                          } /* endif */

          /* Compress the data */
                          ret = JPEG_base(JPEGHandle,CoefHandle,
                                          &PixelBuffer,&iotyp);

          /* Check for errors */
                          if (ret == ERROR_RETURN)
                          {
                              MessageBox(hwnd,
                                         "Error in JPEG_base() - See comp.log",
                                         "COMPRESS ERROR",
                                         MB_OK | MB_ICONSTOP);
/* Log errors */
fileptr=fopen("comp.log","w");
fprintf(fileptr,"\n\nInput file  - Decompressed: [%s]", szInputFile);
fprintf(fileptr,"\nOutput file - Compressed:  [%s]", szOutputFile);
fprintf(fileptr,"\nHeader file - Input:       [%s]", szHeaderFile);

fprintf(fileptr,"\n\nReturn from JPEG_base= %d",ret);

fprintf(fileptr,"\n\nComarea Error: iotyp.error.WarnErrorCode= %hu", iotyp.error.WarnErrorCode);
fprintf(fileptr,"\n               iotyp.error.data_element = %hu", iotyp.error.data_element);
fprintf(fileptr,"\n               iotyp.error.data_value   = %d", iotyp.error.data_value);

fprintf(fileptr,"\n\nComarea Data: iotyp.BegAreaID        = [%s]", iotyp.BegAreaID);
fprintf(fileptr,"\n              iotyp.operation        = %hu", iotyp.operation);
fprintf(fileptr,"\n              iotyp.InputColorSpace  = %hu", iotyp.InputColorSpace);
fprintf(fileptr,"\n              iotyp.OutputColorSpace = %hu", iotyp.OutputColorSpace);
fprintf(fileptr,"\n              iotyp.warning_flags    = %hu", iotyp.warning_flags);
fprintf(fileptr,"\n              iotyp.EndAreaID        = [%s]", iotyp.EndAreaID);
fclose(fileptr);

                             close(PixelHandle);
                             close(JPEGHandle);
                             close(CoefHandle);
                             return 0;
                          } /* endif */

                      } /* endfor */

                      close(PixelHandle);
                      close(JPEGHandle);
                      close(CoefHandle);
                   } /* endif DialogBox() */
                   break ;

              case IDM_DECOMPRESS:
                   if (DialogBox (hInst, "DecompDlg", hwnd, lpfnDlgProc))
                   {
                      iotyp.operation = DECOMPRESS;

      /* Open input compressed image file and output header file */
                      if ((ret = openbuff(szInputFile, szHeaderFile, &iotyp,
                          &JPEGHandle, &CoefHandle)) == ERROR_RETURN)
                      {
                         MessageBox(hwnd,
                                    "Error opening parameter file or input file.",
                                    "DECOMPRESS ERROR",
                                    MB_OK | MB_ICONSTOP);
                         return 0;
                      } /* endif */

      /* Open output bitmap file for RGB data */
                      if ((ret = openPIX(szOutputFile, O_WRONLY|O_CREAT,
                                         &PixelHandle))
                          == ERROR_RETURN)
                      {
                         MessageBox(hwnd,
                                    "Error opening decompressed output file.",
                                    "DECOMPRESS ERROR",
                                    MB_OK | MB_ICONSTOP);
                         close(JPEGHandle);
                         close(CoefHandle);
                         return 0;
                      } /* endif */

      /* While there is data to process and there are no errors */
                      for (strcpy(iotyp.BegAreaID,"ComArea"),
                           strcpy(iotyp.EndAreaID,"ComArea"),
                           iotyp.operation |= START_IMAGE,
                           ret = SUCCESS,bytes_read_written = 0;
                           ((iotyp.operation & CALL_FIELD) != END_OF_IMAGE) &&
                               (bytes_read_written != -1) &&
                               (ret != ERROR_RETURN); )
                      {

          /* Decompress the data */
                         ret = JPEG_base(JPEGHandle,CoefHandle,
                                         &PixelBuffer,&iotyp);

          /* Check for errors */
                          if (ret == ERROR_RETURN)
                          {
                              MessageBox(hwnd,
                                         "Error in JPEG_base() - See decomp.log",
                                         "DECOMPRESS ERROR",
                                         MB_OK | MB_ICONSTOP);
/* Log errors */
fileptr=fopen("decomp.log","w");
fprintf(fileptr,"\n\nInput file  - Compressed:   [%s]", szInputFile);
fprintf(fileptr,"\nOutput file - Decompressed: [%s]", szOutputFile);
fprintf(fileptr,"\nHeader file - Output:       [%s]", szHeaderFile);

fprintf(fileptr,"\n\nReturn from JPEG_base= %d",ret);

fprintf(fileptr,"\n\nComarea Error: iotyp.error.WarnErrorCode= %hu", iotyp.error.WarnErrorCode);
fprintf(fileptr,"\n               iotyp.error.data_element = %hu", iotyp.error.data_element);
fprintf(fileptr,"\n               iotyp.error.data_value   = %d", iotyp.error.data_value);

fprintf(fileptr,"\n\nComarea Data: iotyp.BegAreaID        = [%s]", iotyp.BegAreaID);
fprintf(fileptr,"\n              iotyp.operation        = %hu", iotyp.operation);
fprintf(fileptr,"\n              iotyp.InputColorSpace  = %hu", iotyp.InputColorSpace);
fprintf(fileptr,"\n              iotyp.OutputColorSpace = %hu", iotyp.OutputColorSpace);
fprintf(fileptr,"\n              iotyp.warning_flags    = %hu", iotyp.warning_flags);
fprintf(fileptr,"\n              iotyp.EndAreaID        = [%s]", iotyp.EndAreaID);
fclose(fileptr);

                             close(PixelHandle);
                             close(JPEGHandle);
                             close(CoefHandle);
                             return 0;
                          } /* endif */

          /* Write out the data to the output bitmap file */
                          bytes_read_written = PixelWrite(PixelHandle,
                                                          PixelBuffer, &iotyp);
                          if (bytes_read_written == ERROR_RETURN)
                          {
                             MessageBox(hwnd,
                                        "Error writing to bitmap file.",
                                        "DECOMPRESS ERROR",
                                        MB_OK | MB_ICONSTOP);
                             close(PixelHandle);
                             close(JPEGHandle);
                             close(CoefHandle);
                             return 0;
                          } /* endif */
                      } /* endfor */

                      close(PixelHandle);
                      close(JPEGHandle);
                      close(CoefHandle);
                   } /* endif */
                   break ;
           } /* endswitch */
           return 0;

      case WM_SIZE :
           cxClient = LOWORD (lParam) ;
           cyClient = HIWORD (lParam) ;
           return 0;

      case WM_PAINT :
           hdc = BeginPaint (hwnd, &ps) ;

           EndPaint (hwnd, &ps) ;
           return 0;

      case WM_DESTROY :
           PostQuitMessage (0) ;
           return 0 ;
   } /* endswitch */
   return DefWindowProc (hwnd, message, wParam, lParam) ;
} /* End of WndProc() */

/******************************************************************************/
/* openbuff()                                                                 */
/*      Open parameter file and compressed image file                         */
/******************************************************************************/

int openbuff(
char      *fpvSource,
char      *fpvDestination,
COM_AREA  *IoType,
USHORT    *JPEGHandle,
USHORT    *CoefHandle
)
{
   int rc;

   rc = SUCCESS;
   if ((IoType->operation & COMPRESS) != 0) {
      if ((*JPEGHandle = open((char *)fpvSource, O_BINARY|O_RDONLY,0666)) == -1 ) {
#ifndef MS_WIN
          printf("unable to open input file:  %s, return code:  %d\n",
                  (char *)fpvSource,*JPEGHandle);
#endif
          rc = ERROR_RETURN;
      }

      if (fpvDestination !=  NULL) {
          if ((*CoefHandle = open((char *)fpvDestination,O_BINARY|O_WRONLY|O_CREAT,0666))  ==  -1 )
          {
#ifndef MS_WIN
              printf("unable to open output file:  %s, return code:  %d\n",
                      (char *)fpvDestination,*CoefHandle);
#endif
              rc = ERROR_RETURN;
          }
      } else {
          if ((*CoefHandle = open("enc.out",O_BINARY|O_WRONLY|O_CREAT,0666))  ==  -1 )
          {
              rc = ERROR_RETURN;
          }
          rc = ERROR_RETURN;
      }
   } else { /* DeCompress */
      if ((*CoefHandle = open((char *)fpvSource,O_BINARY|O_RDONLY,0666)) == -1) {
          rc = ERROR_RETURN;
      }

      if ((*JPEGHandle = open((char *)fpvDestination,O_BINARY|O_WRONLY|O_CREAT,0666)) == -1 ) {
          rc = ERROR_RETURN;
      }
   }
   return(rc);
} /* End of openbuff() */

/******************************************************************************/
/* openPIX()                                                                  */
/*      Open pixel file                                                       */
/******************************************************************************/

int openPIX(file,options,file_handle)
char   *file;
USHORT  options;
int    *file_handle;
{
   if ((*file_handle = open(file,O_BINARY|options,0666)) == -1) {
      return(ERROR_RETURN);
   }
   return(SUCCESS);
} /* End of openPIX() */

/******************************************************************************/
/* PixelRead() and PixelWrite()                                               */
/*      Read and write a pixel buffer from/to a file                          */
/******************************************************************************/

int PixelRead(PixelHandle,PixelBuffer,ComArea)
int       PixelHandle;
BUFFER   *PixelBuffer;
COM_AREA *ComArea;
{
   int     k;
   char cMsg[100], buf[100];

   /* For all but the last group of blocks, DCT_ROW_COL rows of maxvsamp MDUs are
      acquired */
   k = read(PixelHandle, PixelBuffer->bufad, PixelBuffer->buflen);
   if (k == -1) {
      strcpy(cMsg,"Invalid read into pixel buffer, error:  ");
      itoa(errno,buf,16);
      strcat(cMsg,buf);
      strcpy(cMsg,".  Buffer length:  ");
      itoa(PixelBuffer->buflen,buf,16);
      strcat(cMsg,buf);
      TestErrMsg("PixelRead",cMsg,0);
      return(ERROR_RETURN);
   }
   return(k);

} /* End of PixelRead() */

int PixelWrite(PixelHandle,PixelBuffer,ComArea)
int       PixelHandle;
BUFFER   *PixelBuffer;
COM_AREA *ComArea;
{
   int k;
   char cMsg[100], buf[100];

   /* For all but the last group of blocks, DCT_ROW_COL rows of maxvsamp MDUs are
      acquired */
   k = write(PixelHandle, PixelBuffer->bufad,PixelBuffer->bufused);
   if (k == -1) {
      strcpy(cMsg,"Invalid write from pixel buffer, error:  ");
      itoa(errno,buf,16);
      strcat(cMsg,buf);
      strcpy(cMsg,".  Buffer length:  ");
      itoa(PixelBuffer->buflen,buf,16);
      strcat(cMsg,buf);
      TestErrMsg("PixelWrite",cMsg,0);
      return(ERROR_RETURN);
   }
   return (k);

} /* End of PixelWrite() */

/******************************************************************************/
/* TestErrMsg()                                                               */
/*      Notify users of errors                                                */
/******************************************************************************/

void  TestErrMsg(char *mod, char *mess, int rc)
{
   FILE *file_ptr;
   file_ptr=fopen("jpegerr.log","a");
   fprintf(file_ptr,"%s: RC=%u Error: %s\n",mod,rc,mess);
   fclose(file_ptr);
} /* End of TestErrMsg() */

