/*********************************************************************/
/*								     */
/*  INCLUDE NAME = eapidbas.cnc 				     */
/*								     */
/*  DESCRIPTIVE NAME = AAPI Database Structures and Constants	     */
/*								     */
/*  COPYRIGHT = (C) Copyright by IBM Corp. 1989 - 1991. 	     */
/*		All rights reserved.				     */
/*		Refer to "LICENSE.DOC" for information regarding     */
/*		the use of this file.				     */
/*								     */
/*  CHANGE ACTIVITY =  See Below				     */
/*								     */
/*	    Isolated changed areas will be marked with three	     */
/*	    character codes "XXX".  New areas will be marked with    */
/*	    only "XXXs" at the start and "XXXe" at the end.          */
/*								     */
/*		       12/07/89, AVC Release 1.02		     */
/*		       03/16/90, AVC Release 1.03		     *-103*/
/*				     Added MIDI audio type	     *-103*/
/*				     Added High quality music type   *-103*/
/*		       05/23/91, M-ACPA Release 2.00		     *-200*/
/*				     Changed Common Memory Structure *-200*/
/*				     Added RIFF WAVE support	     *-200*/
/*								     */
/*********************************************************************/
/*								     */
/********FILE ACCESS BLOCK STRUCTURE**********************************/
/*								     */
typedef struct FAB_STRUCT_T	       /* File Access Block Struct   */
{				       /*			     */
  unsigned short fabbit;	       /*  FAB status flag	     */
  unsigned short fabcnt;	       /*  FABO list count	     */
  unsigned short fabhdl;	       /*  Dbase access handle	     */
  unsigned short fabver;	       /*  Version/Mod		     */
  unsigned char fabgen; 	       /*  Relative generation number*/
    #define FAB_DGEN	      1        /*    Default generation #    */
  unsigned char fabold; 	       /*  Number of generations kept*/
    #define FAB_DGKP	      1        /*    Def generations to keep */
  unsigned short fabtyp;	       /*  AV file type 	     */
    #define FAB_AFILE	      0x0500   /*    Audio file type	     */
  unsigned long fabser; 	       /*  Dbase serial number	     */
  unsigned long fabvdf; 	       /*  VDF pointer		     */
  unsigned short fabcopy;	       /*  Copyright flag	     */
    #define DBAS_NAME	      64       /*   Maximum name length      */
  char	   fabnam[DBAS_NAME];	       /*  ASCII-z reference string  */
  unsigned char reserved[8];	       /*  Reserved		     */
  unsigned short fabstat;	       /*  FAB status flags	     */
    #define FAB_ODSK	   0x0080      /*    File has been committed */
} FAB_STRUCT;			       /* End Structure 	     */
/*								     */
/********FILE ACCESS BLOCK OBJECT STRUCTURE***************************/
/*								     */
typedef struct FILE_ACCESS_BLOCK_OBJ_T /* File Access Blk Obj Struct */
{				       /*			     */
  unsigned short  fostat;	       /*  Object status flags	     */
    #define FABO_EOPN	   0x2000      /*    Escape file open	     */
    #define FABO_HALC	   0x0200      /*    Header allocated	     */
    #define FABO_VALC	   0x0100      /*    Variable is allocated   */
    #define FABO_ODSK	   0x0080      /*    Object is on disk	     */
    #define FABO_HMEM	   0x0020      /*    Header is in memory     */
    #define FABO_HMOD	   0x0010      /*    Header modified	     */
    #define FABO_VMEM	   0x0002      /*    Variable is in memory   */
    #define FABO_VMOD	   0x0001      /*    Variable modified	     */
  unsigned short  fotype;	       /*  Object type code	     */
    #define FABO_AOBJ	   0x0500      /*    AUDIO Object	     */
    #define FABO_VOBJ	   0x0501      /*    AUDVOL Object	     */
    #define FABO_POBJ	   0x0502      /*    AUDPNTS Object	     */
    #define FABO_LOBJ	   0x0503      /*    AUDLABL Object	     */
    #define FABO_EOBJ	   0x8500      /*    ESCAPE Object	     */
  unsigned short  fosub;	       /*  Object subtype	     */
  unsigned short  fosizh;	       /*  Size of header sec  (mem) */
  unsigned long fosizv; 	       /*  Size of variable sec(mem) */
  unsigned long fouxads;	       /*  Addr of user exit	     */
  unsigned char *fopmptr;	       /*  Ptr to special parm list  */
  unsigned char *fohdptr;	       /*  Ptr to header sec  (mem)  */
} FABO_STRUCT;			       /* End Structure 	     */
/*								     */
/********COMMON OBJECT STRUCTURES*************************************/
/*								     */
typedef struct COMMON_MEMORY_T	       /* Common Memory Struct	     */
{				       /*			     */
  unsigned char *dataptr;	       /*  Ptr to start of data indx */
  unsigned char res_1[26];	       /*  (reserved -- 00h)	     *-200*/
  unsigned short  mem_id;	       /*  Memory-type id	     *-200*/
} COM_MEM_STRUCT;		       /* End Structure 	     */
/*								     */
typedef struct COMMON_PROLOGUE_T       /* Common Prologue Struct     */
{				       /*			     */
  char	       obj_ids[8];	       /*  Visual ID		     */
    #define COMP_VAUD  "AUDIO  "       /*    Audio Object            */
    #define COMP_VVOL  "AUDVOL "       /*    Volume Object           */
    #define COMP_VPNT  "AUDPNTS"       /*    Points Object           */
    #define COMP_VLAB  "AUDLABL"       /*    Label Object            */
    #define COMP_VESC  "ESCAPE "       /*    Escape Object           */
  unsigned short  obj_ver;	       /*  Version		     */
    #define COMP_VERS	       0       /*    First version	     */
  unsigned short  cmp_type;	       /*  Compression Type	     */
  unsigned char res_1[4];	       /*  (reserved -- 00h)	     */
} COM_PRO_STRUCT;		       /* End Structure 	     */
/*								     */
/********"AUDIO" OBJECT STRUCTURE*************************************/
/*								     */
typedef struct AUDIO_OBJECT_HDR_T      /* Audio Obj Header Struct    */
{				       /*			     */
  COM_MEM_STRUCT aud_cmem;	       /*  Common memory struct      */
  COM_PRO_STRUCT aud_cpro;	       /*  Common prologue	     */
  unsigned long  aud_time;	       /*  Length of track (ms)      */
  unsigned long  aud_end;	       /*  Offset to end of segm data*/
  unsigned short   aud_segm;	       /*  Length of segment (ms)    */
    #define AUDO_LT05	    100        /*    ADPCM/05K - .1 secs     */
    #define AUDO_LT11	    100        /*    ADPCM/11K - .1 secs     */
    #define AUDO_LT22	    100        /*    ADPCM/22K - .1 secs     */
    #define AUDO_LTFM	     50        /*    ADPCM/22K - .05 secs    *-103*/
    #define AUDO_LTAM	    100        /*    AVC MIDI  - .1 secs     *-103*/
  unsigned short   aud_segb;	       /*  Length of segment (bytes) */
    #define AUDO_LB05	    576        /*    ADPCM/05K -  5K sec     */
    #define AUDO_LB11	   1128        /*    ADPCM/11K - 11K sec     */
    #define AUDO_LB22	   2256        /*    ADPCM/22K - 22K stereo  */
    #define AUDO_LBFM	   1128        /*    ADPCM/22K - 22K mono    *-103*/
    #define AUDO_LBAM	   1024        /*    AVC MIDI - Variable len *-103*/
    #define AUDO_LBOF	      0        /*     Len fld offset in segm *-103*/
    #define AUDO_LBLL	      4        /*     Len fld length in segm *-103*/
  unsigned short   aud_dion;	       /*  # of segment indx entries */
  unsigned short   aud_dil;	       /*  Len segm indx entry(bytes)*/
    #define AUDO_LSMX	      4        /*   Maximum index length     */
    #define AUDO_LSI4	      4        /*   Generic 4-byte index     */
    #define AUDO_LSI3	      3        /*   Generic 3-byte index     */
    #define AUDO_LSM3	 0X00FFFFFF    /*    Max len for 3 byte index*/
    #define AUDO_LS05	      3        /*    ADPCM/05K - 3 byte indx */
    #define AUDO_LS11	      3        /*    ADPCM/11K - 3 byte indx */
    #define AUDO_LS22	      3        /*    ADPCM/22K - 3 byte indx */
  unsigned short   aud_blks;	       /*  Total # of physical segms */
  unsigned short   aud_grb;	       /*  Total uncollected free sgs*/
    #define AUDO_GRM3	   6000        /*    3 byte indx max entries */
  unsigned char  aud_fg1;	       /*  Format flag		     */
    #define AUDO_FFRG	   0x80        /*    Fragmented 	     */
    #define AUDO_FSEQ	   0x40        /*    Sequential 	     */
    #define AUDO_FSIL	   0x20        /*    Silence segm at start   */
  unsigned char  aud_fg2;	       /*  Coding type		     */
    #define AUDO_CFIX	   0x80        /*    Fixed rate coding	     */
    #define AUDO_CVAR	   0x40        /*    Variable rate coding    */
    #define AUDO_CVSS	   0x20        /*    Variable segment size   */
    #define AUDO_CVST	   0x10        /*    Variable segment time   */
  unsigned short   aud_comp;	       /* Compression method	     */
    #define AUDO_DEFT 0 	       /*   DEFAULT - ADPCM/SM/11K   */
    #define AUDO_SM11 1 	       /*   ADPCM/11K	  (music)    */
    #define AUDO_ML05 2 	       /*   ADPCM/5.5K	  (voice)    */
    #define AUDO_ML22 3 	       /*   ADPCM/22K	  (stereo)   */
    #define AUDO_FM22 4 	       /*   ADPCM/22K	  (HQ music) *-103*/
    #define AUDO_AVCM 100	       /*   AVC MIDI		     *-103*/
  unsigned short   aud_mcid;	       /* Microcode ID		     */
    #define AUDO_MC00	   0x00        /*    Microcode version 1.3   */
    #define AUDO_MC01	   0x01        /*    Microcode version 1.6   */
  unsigned char  res_1[22];	       /*  (reserved -- 00h)	     */
} AUDO_HDR_STRUCT;		       /* End Structure 	     */
/*								     */
/********"AUDVOL" OBJECT STRUCTURE************************************/
/*								     */
typedef struct AUDVOL_OBJECT_HDR_T     /* Audvol Obj Header Struct   */
{				       /*			     */
  COM_MEM_STRUCT aud_cmem;	       /*  Common memory struct      */
  COM_PRO_STRUCT aud_cpro;	       /*  Common prologue	     */
  unsigned short   aud_voln;	       /*  # of volume data entries  */
  unsigned char  res_1[14];	       /*  (reserved -- 00h)	     */
} VOLO_HDR_STRUCT;		       /* End Structure 	     */
/*								     */
typedef unsigned char  VOLO_VAR_TYPE;  /* Audvol Obj Var Sect Type   */
/*								     */
/*								     */
/********"AUDPNTS" OBJECT STRUCTURE***********************************/
/*								     */
typedef struct AUDPNTS_OBJECT_HDR_T    /* Audpnts Obj Header Struct  */
{				       /*			     */
  COM_MEM_STRUCT aud_cmem;	       /*  Common memory struct      */
  COM_PRO_STRUCT aud_cpro;	       /*  Common prologue	     */
  unsigned short   aud_plon;	       /*  # of point list entries   */
  unsigned char  res_1[14];	       /*  (reserved -- 00h)	     */
} PNTO_HDR_STRUCT;		       /* End Structure 	     */
/*								     */
#define PLB_LEN  6		       /* Length of: aud_plb	     */
#define PCM_LEN  41		       /* Length of: aud_pcm	     */
#define PPC_LEN  8		       /* Length of: aud_ppc	     */
#define PPL_LEN  5		       /* Length of: aud_ppl	     */
#define PPT_LEN  5		       /* Length of: aud_ppt	     */
#define RES_LEN  6		       /* Length of: aud_ppt	     */
/*								     */
typedef struct AUDPNTS_OBJECT_VAR_T    /* Audpnts Obj Variable Struct*/
{				       /*			     */
  unsigned long  aud_ptm;	       /*  Point position in time(ms)*/
  unsigned char  aud_plb[PLB_LEN];     /*  Label for point	     */
  unsigned char  aud_pcm[PCM_LEN];     /*  User annotation of point  */
  unsigned char  aud_ppc[PPC_LEN];     /*  Mix program - command     */
  unsigned char  aud_ppl[PPL_LEN];     /*  Mix program - level	     */
  unsigned char  aud_ppt[PPT_LEN];     /*  Mix program - time	     */
  unsigned char  aud_pf1;	       /*  Point flag		     */
    #define PNTO_ZPNT	   0x80        /*    Point before sound      */
  unsigned char  res_1[6];	       /*  (reserved -- 00h)	     */
} PNTO_VAR_STRUCT;		       /* End Structure 	     */
/*								     */
/*								     */
/********"AUDLABL" OBJECT STRUCTURE***********************************/
/*								     */
typedef struct AUDLABL_OBJECT_HDR_T    /* Audlabl Obj Header Struct  */
{				       /*			     */
  COM_MEM_STRUCT aud_cmem;	       /*  Common memory struct      */
  COM_PRO_STRUCT aud_cpro;	       /*  Common prologue	     */
  unsigned short   aud_lbln;	       /*  # of label entries	     */
  unsigned char  res_1[14];	       /*  (reserved -- 00h)	     */
} LABO_HDR_STRUCT;		       /* End Structure 	     */
/*								     */
typedef struct AUDLABL_OBJECT_VAR_T    /* Audlabl Obj Variable Struct*/
{				       /*			     */
  unsigned long  aud_ltm;	       /*  Point position in time(ms)*/
  unsigned char  aud_lbl[PLB_LEN];     /*  Label for point	     */
  unsigned char  res_1[2];	       /*  (reserved -- 00h)	     */
} LABO_VAR_STRUCT;		       /* End Structure 	     */
/*								     */
/********"ESCAPE" OBJECT STRUCTURE************************************/
/*								     */
typedef struct ESCAPE_OBJECT_HDR_T     /* Escape Obj Header Struct   */
{				       /*			     */
  COM_MEM_STRUCT aud_cmem;	       /*  Common memory struct      */
  COM_PRO_STRUCT aud_cpro;	       /*  Common prologue	     */
  unsigned short   esc_med;	       /*  Media flags		     */
  unsigned short   esc_sig;	       /*  Signature flag	     */
    #define ESCO_SSTD	   0x00        /*    Standard signature      */
    #define ESCO_SNON	   0x01        /*    No signature	     */
  unsigned long  esc_ser;	       /*  Dbase serial number	     */
  unsigned long  esc_vdf;	       /*  VDF pointer		     */
  unsigned char  esc_ref[DBAS_NAME];   /*  ASCII-z reference pointer */
  short 	   esc_hdl;	       /* Esc file handle (-1=closed */
  short 	   esc_thl;	       /* Temp esc file hd(-1=closed)*/
  unsigned char  res_1[16];	       /*  (reserved -- 00h)	     */
} ESCO_HDR_STRUCT;		       /* End Structure 	     */
/*								     */
#define ESCO_SLEN      8	       /*   Signature length	     */
/*								     */
typedef struct ESCAPE_SGN_HDR_T        /* Escape Signature Hdr Struct*/
{				       /*			     */
  unsigned char  sgn_sig[ESCO_SLEN];   /*  Signature ('+A+V+C+')     */
    #define ESC_FSIG  "+A+V+C+"        /*    Escape file signature   */
  unsigned short   sgn_ver;	       /*  Version/Mod (0000h)	     */
  unsigned short   sgn_type;	       /*  AV file type (80 00)      */
    #define ESC_AFILE	      0x8000   /*    Escape file type	     */
  unsigned long  sgn_ser;	       /*  Dbase serial number	     */
  unsigned long  sgn_vdf;	       /*  VDF pointer		     */
  unsigned char  res_1[12];	       /*  (reserved -- 00h)	     */
} ESCF_SGN_STRUCT;		       /* End Structure 	     */
/*								     */
typedef struct eiob		       /* Escape File I/O Block Str  */
{				       /*			     */
  unsigned char *mem_ptr;	       /*  Pointer to memory buffer  */
  unsigned short   emm_hdl;	       /*  EMM handle		     */
  unsigned short   emm_cnt;	       /*  EMM page count	     */
  unsigned short   mem_id;	       /*  Memory type id	     */
#define EIOB_MAIN      1	       /*   Main memory 	     */
} ESCF_EIOB_STRUCT;		       /* End Structure 	     */
/*								     */
/********AAPI FILE SUPPORT DECLARATIONS*******************************/
/*								     */
/*  The following are the external declarations for the AAPI	     */
/*  file support functions available to "C" language                 */
/*  source code.  See the AAPI documentation for full		     */
/*  function descriptions.					     */
/*								     */
/*********************************************************************/
/*								     */
extern short fab_type(char *,	       /* Determine type of audio    *-200*/
    unsigned short *);		       /*  file 		     *-200*/
				       /*			     *-200*/
    #define AAFB_NONE	      0        /*  File does not exist	     *-200*/
    #define AAFB_UKNW	      1        /*  Unknown type 	     *-200*/
    #define AAFB_AVCF	      2        /*  AVC			     *-200*/
    #define AAFB_WAVE	      4        /*  RIFF WAVE		     *-200*/
				       /*			     */
				       /*			     */
extern short fab_open(char *,	       /* Open an AVC audio file     */
    unsigned char, unsigned char,      /*			     */
    unsigned char, FAB_STRUCT * *,     /*			     */
    unsigned short, unsigned short,    /*			     */
    unsigned short, unsigned short);   /*			     */
				       /*			     */
    #define AAFB_CREA	      1        /*  Create the file only      */
    #define AAFB_OPEN	      2        /*  Open the file only	     */
    #define AAFB_CORO	      3        /*  Create or open file	     */
				       /*			     */
    #define AAFB_EXUR	   0x02        /*  Expand to requested size  */
    #define AAFB_EXMX	   0x01        /*  Expand to maximum size    */
    #define AAFB_EXNO	   0x00        /*  Use current size	     */
				       /*			     */
    #define AAFB_PVOL	   0x01        /*  Process volume object     */
    #define AAFB_PPNT	   0x02        /*  Process points object     */
    #define AAFB_PLAB	   0x04        /*  Process labels object     */
				       /*			     */
extern short fab_ropn(char *,	       /* Open a RIFF WAVE audio file*-200*/
    unsigned char,		       /*			     *-200*/
    FAB_STRUCT * *,		       /*			     *-200*/
    void *);			       /*			     *-200*/
				       /*			     *-200*/
    #define AAFB_SMIX "MSRCMIX$"       /*  Source Mix device name    *-200*/
				       /*			     */
extern short fab_save(FAB_STRUCT *,    /* Save an audio file	     */
	     unsigned short);	       /*			     */
				       /*			     */
extern short fab_close(FAB_STRUCT *);  /* Close an audio file	     */
/*								     */
/********AAPI FILE SUPPORT RETURN CODES*******************************/
/*								     */
#define AAFB_RC_00	   0	       /* Successful call	     */
#define AAFB_RC_01	3301	       /* File found on create	     */
#define AAFB_RC_02	3302	       /* File not found on open     */
#define AAFB_RC_03	3303	       /* I/O error on open/create   */
#define AAFB_RC_04	3304	       /* FAB allocation failed      */
#define AAFB_RC_05	3305	       /* Object allocation failed   */
#define AAFB_RC_06	3306	       /* Object read error	     */
#define AAFB_RC_07	3307	       /* Escape file open error     */
#define AAFB_RC_08	3308	       /* Object write error	     */
/*								     */
/********AAPI OBJECT SIZE DEFINITIONS*********************************/
/*								     */
#define  MAX_LEN_INX	     6000      /* Max audio length-index size*/
#define  MAX_LEN_LIN	      250      /* Max audio len-comment lines*/
/*								     */
#define  VOL_SIZ  (sizeof(VOLO_VAR_TYPE) * MAX_LEN_INX)
				       /* Volume Obj var section len */
#define  PNT_SIZ  (sizeof(PNTO_VAR_STRUCT) * MAX_LEN_LIN)
				       /* Points Obj var section len */
#define  LAB_SIZ  (sizeof(LABO_VAR_STRUCT) * MAX_LEN_LIN)
				       /* Labels Obj var section len */
/*								     */
/********AAPI FILE DIRECTORY STRUCTURES*******************************/
/*								     */
typedef struct DIR_HDR_T	       /* Directory Header	     */
{				       /*			     */
  unsigned char sig[8]; 	       /* Signature ("+A+V+C+")      */
  unsigned short  vers; 	       /* Version number of file     */
  unsigned short  ftyp; 	       /* Type of this file	     */
  unsigned long eod;		       /* End of data in file	     */
  unsigned char res_1[4];	       /*  (reserved -- 00h)	     */
  unsigned short  ents; 	       /* Max # of directory entries */
#define MAX_OBJ   20
  unsigned short  activ;	       /* # of active dir entries    */
  unsigned char res_2[12];	       /*  (reserved -- 00h)	     */
  unsigned char name[64];	       /* File name		     */
  unsigned char res_3[60];	       /*  (reserved -- 00h)	     */
} DIR_HDR_STRUCT;		       /*			     */
/*								     */
typedef struct DIR_T		       /* Directory Entry	     */
{				       /*			     */
  unsigned short  type; 	       /* Object type code	     */
  unsigned short  subtype;	       /* Object subtype	     */
  unsigned char res_1[2];	       /*  (reserved -- 00h)	     */
  unsigned short  sizh; 	       /* Size of object header/file */
  unsigned long sizv;		       /* Size of data section/file  */
  unsigned long size;		       /* Size of object in file     */
  unsigned char res_2[4];	       /*  (reserved -- 00h)	     */
  unsigned long offset; 	       /* Offset of object in file   */
  unsigned char res_3[8];	       /*  (reserved -- 00h)	     */
} DIR_STRUCT;			       /*			     */
/*********************************************************************/
