;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Memory bitmap glyph bltter.                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/15/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

incFont EQU     1

                INCLUDE COMMON.INC
                INCLUDE BITBLT.INC

_TEXT   SEGMENT PUBLIC WORD 'CODE'
.386

pDst            EQU     [bp + 20]
pDstSegmnt      EQU     [bp + 22]
pDstOffset      EQU     [bp + 20]
dyDst           EQU     [bp + 18]
cDstScanSeg     EQU     [bp + 16]
cDstFillBytes   EQU     [bp + 14]
lpFontInfo      EQU     [bp + 10]
lpGlyphInfo     EQU     [bp + 6]
count           EQU     [bp + 4]

GlyphHeight     EQU     [bp - 8]
GlyphByteCount  EQU     [bp - 12]
ScanCount       EQU     [bp - 14]
ScanOffset      EQU     [bp - 16]
cScan           EQU     [bp - 18]

memDrawGlyphs   PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 20
        push    esi
        push    edi
        push    es
        push    fs
        push    ds
;
; Get pointer to first scanline.
;
        xor     ax, ax                          ; Assume yPos = 0, xPos = 0
        bmScanAddrInc cDstScanSeg, dyDst, cScan, pDstSegmnt, pDstOffset
        mov     ds, dx
        mov     ScanOffset, ax
;
; Get string info.
;
        les     si, lpFontInfo
        mov     bx, count
        shl     bx, 2
        add     bx, lpGlyphInfo
        mov     fs, lpGlyphInfo + 2
        mov     dx, fs:[bx]                     ; Get Ending X coordinate
        add     dx, 7
        shr     dx, 3
        mov     GlyphByteCount, dx              ; Save BYTE size of string scanline
        xor     edx, edx
        mov     dx, es:[si][FONTINFO.dfPixHeight]
        mov     GlyphHeight, edx
        xor     dx, dx
ScanLoop:
        mov     ScanCount, dx
        mov     bx, WORD PTR lpGlyphInfo
        mov     cx, count
GlyphLoop:
        mov     di, fs:[bx]             ; Get X position
        mov     si, fs:[bx][2]          ; Get pointer to FontInfo
        add     bx, 4
        mov     ax, es:[si]             ; Get width in bytes
        or      ax, ax
        jz      NextGlyph
        add     ax, 7
        shr     ax, 3
        mov     esi, es:[si][2]         ; Get pointer to bits
        add     esi, edx                ; Add scanline offset
        push    cx
        mov     cx, di
        shr     di, 3                   ; Calc byte address
        add     di, ScanOffset
        and     cl, 7                   ; Calc alignment shift
        mov     dx, ax
RowLoop:
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      [di], ax
        inc     di
        add     esi, GlyphHeight
        dec     dx
        jnz     RowLoop
        mov     dx, ScanCount           ; Reload dx
        pop     cx
NextGlyph:
        dec     cx
        jnz     GlyphLoop
;
; Increment current scanline pointer.
;
        inc     dx
        cmp     dx, GlyphHeight
        jg      Exit
        mov     di, ScanOffset
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     ScanOffset, di
        jmp     ScanLoop
Exit:
        mov     ax, fs:[bx]
        pop     ds
        pop     fs
        pop     es
        pop     edi
        pop     esi
        leave
        ret     20

memDrawGlyphs   ENDP
_TEXT   ENDS

        END
