;----------------------------------------------------------------------------;
;                                                                            ;
; Function: PatBLT 1BPP pattern to 1BPP destination                          ;
;                                                                            ;
;       1BPP pattern BLT fills a rectangular region of a bitmap with a       ;
;       repeating pattern using a binary ROP.  This routine fills the region ;
;       on a scanline basis using a procudure table to apply the individual  ;
;       ROP functions.  The scanline BLT procedures are optimized to fill    ;
;       the destination with 32 bit operations.  DWORD alignment is          ;
;       calculated for each scanline.  ROPs that can be easily synthesized   ;
;       with other ROPs by altering the source pattern are implemented to    ;
;       conserve code space.                                                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/07/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

incDrawMode     EQU     1               ; Include DRAWMODE structure

                INCLUDE COMMON.INC           
                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD 'CODE'
.386

EXTERN LeftMask1  : BYTE
EXTERN RightMask1 : BYTE

pDst            EQU     [bp + 26]
pDstSegmnt      EQU     [bp + 28]
pDstOffset      EQU     [bp + 26]
dyDst           EQU     [bp + 24]
cDstScanSeg     EQU     [bp + 22]
cDstFillBytes   EQU     [bp + 20]
xDst            EQU     [bp + 18]
yDst            EQU     [bp + 16]
pPat            EQU     [bp + 12]
pPatSegmnt      EQU     [bp + 14]
pPatOffset      EQU     [bp + 12]
xSize           EQU     [bp + 10]
ySize           EQU     [bp + 8]
mode            EQU     [bp + 6]
rop             EQU     [bp + 4]

pDstScan        EQU     [bp - 2]
LastMask        EQU     [bp - 3]
RightMask       EQU     [bp - 4]
Masks           EQU     [bp - 4]
cDstByte        EQU     [bp - 6]
cScan           EQU     [bp - 8]
pfnScanBlt      EQU     [bp - 10]

mempBltPD11Tbl  DW      mempBltPD11r0, mempBltPD11r1, mempBltPD11r2, mempBltPD11r3
                DW      mempBltPD11r4, mempBltPD11r5, mempBltPD11r6, mempBltPD11r7
                DW      mempBltPD11r8, mempBltPD11r9, mempBltPD11rA, mempBltPD11rB
                DW      mempBltPD11rC, mempBltPD11rD, mempBltPD11rE, mempBltPD11rF

                DW      mempBltPD11r0, mempBltPD11r1, mempBltPD11r2, mempBltPD11r3
                DW      mempBltPD11r4, mempBltPD11r5, mempBltPD11r6, mempBltPD11r7
                DW      mempBltPD11r8, mempBltPD11r9, mempBltPD11rA, mempBltPD11rB
                DW      mempBltHD11rC, mempBltPD11rD, mempBltPD11rE, mempBltPD11rF

memBltPD_ToMono         PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 14
        push    ds
        push    es
        push    si
        push    di
;
; Load pattern segment.
;
        mov     es, pPatSegmnt
;
; Get pointer to first scanline.
;
        mov     ax, yDst
        bmScanAddrInc cDstScanSeg, dyDst, cScan, pDstSegmnt, pDstOffset
        mov     ds, dx
        mov     di, ax
;
; Calculate destination constants.
;
        mov     ax, xDst                ; ax = xDstLeft
        mov     bx, ax
        and     bx, 7                   ; bx = xDstLeft mod 8
        mov     dl, LeftMask1[bx]       ; dx = LeftMask
        mov     cx, ax
        shr     cx, 3                   ; cx = xDstLeft div 8
        add     ax, xSize
        dec     ax                      ; ax = xDstRight
        mov     bx, ax
        and     bx, 7                   ; bx = xDstRight mod 8
        mov     dh, RightMask1[bx]      ; bx = RightMask
        shr     ax, 3                   ; ax = xDstRight div 8
        sub     ax, cx
        jnz     @F
        and     dl, dh
;
; Save calculated constants.
;
@@:     mov     cDstByte, ax
        mov     Masks, dx
        add     di, cx                  ; ds:[di] = first word in scanline
        mov     pDstScan, di
;
; Translate rop2 into function pointer.
;
        mov     bx, rop 
        add     bx, bx
        mov     si, pPatOffset
        test    WORD PTR es:[si][BRUSH_FLAGS], 8        ; 8 = Hatch brush
        jz      @F
        cmp     WORD PTR mode, TRANSPARENT
        jne     @F
        add     bx, 32
@@:     mov     bx, mempBltPD11Tbl[bx]
        jmp     bx
memBltPD_ToMono         ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 0                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r0      PROC NEAR
        xor     eax, eax
ScanLoop:
;
; eax     = 0
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
@@:     mov     [di], bl
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop8
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop8:
        cmp     cx, 8
        jb      PatLoop1
        mov     [di], eax
        mov     [di + 4], eax
        add     di, 8
        sub     cx, 8
        jnz     PatLoop8
        jmp     StoreLast
PatLoop1:
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
@@:     mov     [di], bh
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r0      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 1                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r1      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        or      al, [di]
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        or      al, [di]
        not     al
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        or      ax, [di]
        not     ax
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        mov     eax, esi
        or      eax, [di]
        not     eax
        mov     [di], eax
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
        or      al, [di]
        not     al
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        mov     ax, si
        or      al, [di]
        not     al
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r1      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 2                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r2      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
        not     esi
        not     ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        and     al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, si
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        and     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        and     [di], si
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        and     [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
@@:     and     [di], al
        inc     di
        dec     cx
        jnz     @B
StoreLast:
        and     al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r2      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 3                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r3      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
        not     esi
        not     ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, si
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop8
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop8:
        cmp     cx, 8
        jb      PatLoop1
        mov     [di], esi
        mov     [di + 4], esi
        add     di, 8
        sub     cx, 8
        jnz     PatLoop8
        jmp     StoreLast
PatLoop1:
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r3      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 4                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r4      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        mov     dl, [di]
        not     dl
        and     al, dl
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        mov     dl, [di]
        not     dl
        and     al, dl
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        mov     ax, si
        mov     dx, [di]
        not     dx
        and     ax, dx
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        mov     eax, esi
        mov     edx, [di]
        not     edx
        and     eax, edx
        mov     [di], eax
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
        mov     dl, [di]
        not     dl
        and     al, dl
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        mov     ax, si
        mov     dl, [di]
        not     dl
        and     al, dl
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r4      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 5                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r5      PROC NEAR
ScanLoop:
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        xor     [di], bl
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        not     BYTE PTR [di]
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        not     WORD PTR [di]
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        not     DWORD PTR [di]
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        not     BYTE PTR [di]
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        xor     [di], bh
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r5      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 6                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r6      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        xor     al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        xor     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        xor     [di], si
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        xor     [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
@@:     xor     [di], al
        inc     di
        dec     cx
        jnz     @B
StoreLast:
        mov     ax, si
        xor     al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r6      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 7                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r7      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        and     al, [di]
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        and     al, [di]
        not     al
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        mov     ax, si
        and     ax, [di]
        not     ax
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        mov     eax, esi
        and     eax, [di]
        not     eax
        mov     [di], eax
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
        and     al, [di]
        not     al
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        mov     ax, si
        and     al, [di]
        not     al
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r7      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 8                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r8      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        and     al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, si
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        and     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        and     [di], si
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        and     [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
@@:     and     [di], al
        inc     di
        dec     cx
        jnz     @B
StoreLast:
        and     al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r8      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = 9                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11r9      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
        not     esi
        not     ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        xor     al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        xor     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        xor     [di], si
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        xor     [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
@@:     xor     [di], al
        inc     di
        dec     cx
        jnz     @B
StoreLast:
        mov     ax, si
        xor     al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11r9      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = A                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rA      PROC NEAR
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rA      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = B                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rB      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
        not     esi
        not     ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        or      al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        or      [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        or      [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        or      [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        or      [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        or      al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rB      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = C                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rC      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, si
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop8
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop8:
        cmp     cx, 8
        jb      PatLoop1
        mov     [di], esi
        mov     [di + 4], esi
        add     di, 8
        sub     cx, 8
        jnz     PatLoop8
        jmp     StoreLast
PatLoop1:
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rC      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = D                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rD      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        mov     dl, [di]
        not     dl
        or      al, dl
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        mov     dl, [di]
        not     dl
        or      al, dl
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h 
        jz      PatLoop4
        mov     ax, si
        mov     dx, [di]
        not     dx
        or      ax, dx
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        mov     eax, esi
        mov     edx, [di]
        not     edx
        or      eax, edx
        mov     [di], eax
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        mov     ax, si
        mov     dl, [di]
        not     dl
        or      al, dl
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        mov     ax, si
        mov     dl, [di]
        not     dl
        or      al, dl
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rD      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = E                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rE      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        ror     al, cl
        mov     ah, al
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        or      al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        mov     ax, si
        test    di, 01h
        jz      @F
        or      [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop4
        or      [di], ax
        add     di, 2
        sub     cx, 2
PatLoop4:
        cmp     cx, 4
        jb      PatLoop1
        or      [di], esi
        add     di, 4
        sub     cx, 4
        jnz     PatLoop4
        jmp     StoreLast
PatLoop1:
        or      [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        or      al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rE      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 1BPP, rop = F                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD11rF      PROC NEAR
        xor     eax, eax
        not     eax
ScanLoop:
;
; eax     = ~0
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of 0xFF's.
;
        or     [di], bl
        or      cx, cx
        jz      NextScan
        inc     di
        dec     cx
        jz      StoreLast
        test    di, 01h
        jz      @F
        mov     [di], al
        inc     di
        dec     cx
        jz      StoreLast
@@:     cmp     cx, 2
        jbe     PatLoop1
        test    di, 02h
        jz      PatLoop8
        mov     [di], ax
        add     di, 2
        sub     cx, 2
PatLoop8:
        cmp     cx, 8
        jb      PatLoop1
        mov     [di], eax
        mov     [di + 4], eax
        add     di, 8
        sub     cx, 8
        jnz     PatLoop8
        jmp     StoreLast
PatLoop1:
        mov     [di], al
        inc     di
        dec     cx
        jnz     PatLoop1
StoreLast:
        or      [di], bh
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD11rF      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                    Hatch BLT, 1BPP, rop = C                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltHD11rC    PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
ScanLoop:
;
; Load byte of brush and expand into a DWORD.
;
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        mov     cl, es:[si][BRUSH_X]
        and     cl, 7
        mov     al, es:[si][bx][BRUSH_MONO]
        mov     dl, es:[si][bx][BRUSH_PAT]
        ror     al, cl
        ror     dl, cl
        mov     ah, al
        mov     dh, dl
        mov     si, ax
        ror     esi, 16
        mov     si, ax
;
; ax      = pattern WORD
; bl      = LeftMask
; bh      = RightMask
; cx      = cDstByte
; dx      = raw pattern WORD
; esi     = pattern DWORD
; ds:[di] = destination
;
        mov     cx, cDstByte
        mov     bx, Masks
;
; BLT scanline of brush.
;
        cmp     ax, dx
        jne     InverseHatch
        or      al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, dx
        dec     cx
        jz      HStoreLast
HLoop:
        or      [di], al
        inc     di
        dec     cx
        jnz     HLoop
HStoreLast:
        or      al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
        ret
InverseHatch:
        not     dx
        mov     ax, dx
        and     al, [di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, [di]
        or      al, bl
@@:     mov     [di], al
        or      cx, cx
        jz      NextScan
        inc     di
        mov     ax, dx
        dec     cx
        jz      IHStoreLast
IHLoop:
        and     [di], al
        inc     di
        dec     cx
        jnz     IHLoop
IHStoreLast:
        and     al, [di]
        and     al, bh
        xor     bh, 0FFh
        jz      @F
        and     bh, [di]
        or      al, bh
@@:     mov     [di], al
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltHD11rC    ENDP

_TEXT           ENDS
                END
