.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: BitBLT 1BPP source and pattern to 1BPP destination bitmap        ;
;                                                                            ;
;       1BPP BitBLT combines a rectangular region of a source bitmap,        ;
;       pattern, and destination bitmap using a ternary ROP.  The ternary    ;
;       ROP is broken down into terms used to evaluate a polynomial that     ;
;       describes the ROP.  This procedure is written for functionality,     ;
;       not for performance.  Cases when only a pattern and destination or   ;
;       a source and destination are handled in other procedures using       ;
;       hard-coded routines for each ROP combination.  The theory being      ;
;       that calls using all three components of a ternary ROP are very      ;
;       rare and infrequent.                                                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/10/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE COMMON.INC
                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN LeftMask1  : BYTE
EXTERN RightMask1 : BYTE
EXTERN xlateRop   : BYTE

pDst            EQU     [bp + 38]
pDstSegmnt      EQU     [bp + 40]
pDstOffset      EQU     [bp + 38]
dyDst           EQU     [bp + 36]
cDstScanSeg     EQU     [bp + 34]
cDstFillBytes   EQU     [bp + 32]
xDst            EQU     [bp + 30]
yDst            EQU     [bp + 28]
pSrc            EQU     [bp + 24]
pSrcSegmnt      EQU     [bp + 26]
pSrcOffset      EQU     [bp + 24]
dySrc           EQU     [bp + 22]
cSrcScanSeg     EQU     [bp + 20]
cSrcFillBytes   EQU     [bp + 18]
xSrc            EQU     [bp + 16]
ySrc            EQU     [bp + 14]
pPat            EQU     [bp + 10]
pPatSegmnt      EQU     [bp + 12]
pPatOffset      EQU     [bp + 10]
xSize           EQU     [bp + 8]
ySize           EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
LastMask        EQU     [bp - 9]
FirstMask       EQU     [bp - 10]
Masks           EQU     [bp - 10]
cDstByte        EQU     [bp - 12]
xSrcRightDiv8   EQU     [bp - 14]
xDstRightDiv8   EQU     [bp - 16]
cLoop           EQU     [bp - 18]
Flags           EQU     [bp - 20]

memBltPSD_MonoToMono    PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 22
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pattern segment.
;
        mov     fs, pPatSegmnt
;
; Check vertical BLT direction.
;
CheckYDir:
        mov     ax, ySrc
        mov     bx, yDst
        cmp     ax, bx
        jb      @F
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     BYTE PTR Flags, bTopToBottom
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
        jmp     CalcConst
;
; BLT from bottom to top.
; Get pointer to first source scanline.
;
@@:     mov     BYTE PTR Flags, bBottomToTop
        mov     cx, ySize
        dec     cx
        add     ax, cx
        bmScanAddrDec cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        add     ax, cx
        mov     yDst, ax
        bmScanAddrDec cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; Calculate source constants.
;
CalcConst:
        mov     bx, xSrc                ; bx = xSrcLeft
        mov     ax, bx
        rol     eax, 16                 ; save in upper WORD of eax
        mov     ax, bx
        shr     ax, 3                   ; ax = xSrcLeft div 8
        mov     dx, xSize
        dec     dx
        add     bx, dx                  ; bx = xSrcRight
        mov     cx, bx
        and     cl, 7                   ; cl = xSrcRight mod 8
        shr     bx, 3                   ; bx = xSrcRight div 8
        mov     xSrcRightDiv8, bx
        cmp     bx, ax
        jne     @F
        or      BYTE PTR Flags, bOneFetch
;
; Calculate destination constants.
;
@@:     mov     bx, xDst                ; bx = xDstLeft
        mov     ax, bx
        rol     ebx, 16                 ; save in upper WORD of ebx
        mov     bx, ax
        shr     ax, 3                   ; ax = xDstLeft div 8
        add     bx, dx                  ; bx = xDstRight
        mov     dx, bx
        and     dl, 7                   ; dl = xDstRight mod 8
        mov     ch, dl                  ; cx = xSrcRight mod 8 & xDstRight mod 8
        shr     bx, 3                   ; bx = xDstRight div 8
        mov     xDstRightDiv8, bx
        sub     bx, ax                  ; bx = Dst BYTE count
        mov     cDstByte, bx
;
; Check x direction and do BLT.
;
CheckXDir:
        rol     eax, 16                 ; recover xSrc from eax
        rol     ebx, 16                 ; recover xDst from ebx
        cmp     ax, bx
        jae     XDirLR
        jmp     XDirRL
;
; BLT from left to right.
;
XDirLR:
;        or      BYTE PTR Flags, bLeftToRight
;
; Increment scanline pointer to first pixel WORD.
;
        mov     dx, ax
        shr     dx, 3
        add     si, dx
        mov     dx, bx
        shr     dx, 3
        add     di, dx
        and     al, 7
        and     bx, 7
        mov     ah, bl
;
; Get destination masks for first and last store.
;
; al = xSrcLeftMod8
; ah = xDstLeftMod8
; bx = xDstLeftMod8
; cl = xSrcRightMod8
; ch = xDstRightMod8
;
        mov     dl, LeftMask1[bx]
        mov     bl, ch
        mov     dh, RightMask1[bx]
        cmp     WORD PTR cDstByte, 0
        jnz     @F
        and     dl, dh
@@:     mov     Masks, dx
        mov     dl, Flags
        cmp     cl, ch
        ja      @F
        or      dl, bLastFetch
;
; Calculate rotation direction.
;
@@:     mov     cl, ah
        sub     cl, al
        jns     @F
        add     cl, 8
        or      dl, bPreFetch
;
; Correct left rotate count to a right rotate count by subtracting LeftRotate
; from 16 to get RightRotate.
;
@@:     mov     ch, cl
        mov     cl, 16
        sub     cl, ch
        cld
        jmp     ScanLoop
;
; BLT from right to left.
;
XDirRL:
;       or      BYTE PTR Flags, bRightToLeft    ; bRightToLeft == 0
;
; Increment scanline pointer to first pixel BYTE.
;
        add     si, xSrcRightDiv8
        add     di, xDstRightDiv8
        and     al, 7
        and     bx, 7
        mov     ah, bl
;
; Get destination masks for first and last store.
;
; al = xSrcLeftMod8
; ah = xDstLeftMod8
; bx = xDstLeftMod8
; cl = xSrcRightMod8
; ch = xDstRightMod8
;
        mov     dh, LeftMask1[bx]
        mov     bl, ch
        mov     dl, RightMask1[bx]
        cmp     WORD PTR cDstByte, 0
        jnz     @F
        and     dl, dh
@@:     mov     Masks, dx
        mov     dl, Flags
        cmp     al, ah
        jb      @F
        or      dl, bLastFetch
;
; Calculate rotation direction.
;
@@:     sub     cl, ch
        jns     @F
        add     cl, 8
        or      dl, bPreFetch
@@:     std
ScanLoop:
;
; Translate Rop3 into term list.
;
        mov     Flags, dl
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, rop
        mov     bl, xlateRop[bx]
        mov     rop, bx
        mov     bx, pPatOffset
        mov     ax, yDst
        sub     ax, fs:[bx][BRUSH_Y]
        and     ax, 7
        mov     yDst, ax
        mov     bx, ax
ScanLoopTop:
;
;bx      = current scanline
;cl      = LeftRotate
;dl      = Flags
;dh      = pattern
;ds:[si] = source
;es:[di] = destination
;
; Get scanline of pattern.
;
        add     bx, pPatOffset
        mov     dh, fs:[bx][BRUSH_MONO]
        mov     ch, cl
        mov     cl, fs:[bx][BRUSH_X]
        and     cl, 7
        ror     dh, cl
        mov     cl, ch
;
; BLT scanline.
;
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     ch, ah
        xor     ah, ah
        rol     ax, cl
        or      al, ch
StoreFirst:
        mov     bx, ax                          ; Save source bits
        rop3    bl, dh, BYTE PTR rop
        mov     ah, bh                          ; Restore old source bits
        mov     bl, FirstMask
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      ExitPS
        dec     bx
        jz      LoadLast
        mov     cLoop, bx
TopLoop:
        lodsb
        mov     ch, ah
        xor     ah, ah
        rol     ax, cl
        or      al, ch
        mov     bx, ax                          ; Save source bits
        rop3    bl, dh, BYTE PTR rop
        mov     ah, bh                          ; Restore old source bits
        stosb
BottomLoop:
        dec     WORD PTR cLoop
        jnz     TopLoop
LoadLast:
        test    BYTE PTR Flags, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        xor     bh, bh
        rol     bx, cl
        or      ah, bl
StoreLast:
        mov     bl, ah
        rop3    bl, dh, BYTE PTR rop
        mov     bl, LastMask
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     mov     es:[di], al
ExitPS:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bx, yDst
        mov     al, Flags
        test    al, bTopToBottom
        jz      @F
;
; Increment pointer to next source, pattern, and destination scanlines.
;
        inc     bx
        and     bx, 7
        mov     yDst, bx
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, al
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     dec     bx
        and     bx, 7
        mov     yDst, bx
        mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, al
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     38

memBltPSD_MonoToMono    ENDP


_TEXT           ENDS
                END
