.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: SrcBLT 1BPP source bitmap to 1BPP destination bitmap             ;
;                                                                            ;
;       1BPP source BLT copies a rectangular region of a source bitmap       ;
;       to a same sized rectangular region on a destiantion bitmap using     ;
;       a binary ROP to combine source pixels with destination pixels.       ;
;       The case of source and destination being the same is handled         ;
;       correclty by BLTting up or down, left or right.  The procedure uses  ;
;       a generic main loop that calls individual scanline BLT procedures    ;
;       based upon the ROP and the horizontal BLT direction.                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/07/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN LeftMask1  : BYTE
EXTERN RightMask1 : BYTE

pDst            EQU     [bp + 34]
pDstSegmnt      EQU     [bp + 36]
pDstOffset      EQU     [bp + 34]
dyDst           EQU     [bp + 32]
cDstScanSeg     EQU     [bp + 30]
cDstFillBytes   EQU     [bp + 28]
xDst            EQU     [bp + 26]
yDst            EQU     [bp + 24]
pSrc            EQU     [bp + 20]
pSrcSegmnt      EQU     [bp + 22]
pSrcOffset      EQU     [bp + 20]
dySrc           EQU     [bp + 18]
cSrcScanSeg     EQU     [bp + 16]
cSrcFillBytes   EQU     [bp + 14]
xSrc            EQU     [bp + 12]
ySrc            EQU     [bp + 10]
xSize           EQU     [bp + 8]
ySize           EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
LastMask        EQU     [bp - 9]
FirstMask       EQU     [bp - 10]
Masks           EQU     [bp - 10]
cDstByte        EQU     [bp - 12]
xSrcRightDiv8   EQU     [bp - 14]
xDstRightDiv8   EQU     [bp - 16]
pfnScanBlt      EQU     [bp - 18]
Flags           EQU     [bp - 20]

mempBltSD11Tbl  DW      0000h,        mempBltSD11r1, mempBltSD11r2, mempBltSD11r3
                DW      mempBltSD11r4, 0000h,        mempBltSD11r6, mempBltSD11r7
                DW      mempBltSD11r8, mempBltSD11r9, 0000h,        mempBltSD11rB
                DW      mempBltSD11rC, mempBltSD11rD, mempBltSD11rE, 0000h

memBltSD_MonoToMono     PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    si
        push    di
;
; Check vertical BLT direction.
;
CheckYDir:
        mov     ax, ySrc
        mov     bx, yDst
        cmp     ax, bx
        jb      @F
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     BYTE PTR Flags, bTopToBottom
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
        jmp     CalcConst
;
; BLT from bottom to top.
; Get pointer to first source scanline.
;
@@:     mov     BYTE PTR Flags, bBottomToTop
        mov     cx, ySize
        dec     cx
        add     ax, cx
        bmScanAddrDec cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        add     ax, cx
        bmScanAddrDec cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; Calculate source constants.
;
CalcConst:
        mov     bx, xSrc                ; bx = xSrcLeft
        mov     ax, bx
        rol     eax, 16                 ; save in upper WORD of eax
        mov     ax, bx
        shr     ax, 3                   ; ax = xSrcLeft div 8
        mov     dx, xSize
        dec     dx
        add     bx, dx                  ; bx = xSrcRight
        mov     cx, bx
        and     cl, 7                   ; cl = xSrcRight mod 8
        shr     bx, 3                   ; bx = xSrcRight div 8
        mov     xSrcRightDiv8, bx
        cmp     bx, ax
        jne     @F
        or      BYTE PTR Flags, bOneFetch
;
; Calculate destination constants.
;
@@:     mov     bx, xDst                ; bx = xDstLeft
        mov     ax, bx
        rol     ebx, 16                 ; save in upper WORD of ebx
        mov     bx, ax
        shr     ax, 3                   ; ax = xDstLeft div 8
        add     bx, dx                  ; bx = xDstRight
        mov     dx, bx
        and     dl, 7                   ; dl = xDstRight mod 8
        mov     ch, dl                  ; cx = xSrcRight mod 8 & xDstRight mod 8
        shr     bx, 3                   ; bx = xDstRight div 8
        mov     xDstRightDiv8, bx
        sub     bx, ax                  ; bx = Dst BYTE count
        mov     cDstByte, bx
;
; Check x direction and do BLT.
;
CheckXDir:
        rol     eax, 16                 ; recover xSrc from eax
        rol     ebx, 16                 ; recover xDst from ebx
        cmp     ax, bx
        jae     XDirLR
        jmp     XDirRL
;
; BLT from left to right.
;
XDirLR:
;        or      BYTE PTR Flags, bLeftToRight
;
; Increment scanline pointer to first pixel WORD.
;
        mov     dx, ax
        shr     dx, 3
        add     si, dx
        mov     dx, bx
        shr     dx, 3
        add     di, dx
        and     al, 7
        and     bx, 7
        mov     ah, bl
;
; Get destination masks for first and last store.
;
; al = xSrcLeftMod8
; ah = xDstLeftMod8
; bx = xDstLeftMod8
; cl = xSrcRightMod8
; ch = xDstRightMod8
;
        mov     dl, LeftMask1[bx]
        mov     bl, ch
        mov     dh, RightMask1[bx]
        cmp     WORD PTR cDstByte, 0
        jne     @F
        and     dl, dh
@@:     mov     Masks, dx
        mov     dl, Flags
        cmp     cl, ch
        ja      @F
        or      dl, bLastFetch
;
; Calculate rotation direction.
;
@@:     mov     cl, ah
        sub     cl, al
        jns     @F
        add     cl, 8
        or      dl, bPreFetch
;
; Correct left rotate count to a right rotate count by subtracting LeftRotate
; from 16 to get RightRotate.
;
@@:     mov     ch, cl
        mov     cl, 16
        sub     cl, ch
        jmp     RopFunc
;
; BLT from right to left.
;
XDirRL:
;       or      BYTE PTR Flags, bRightToLeft    ; bRightToLeft == 0
;
; Increment scanline pointer to first pixel WORD.
;
        mov     dx, xSrcRightDiv8
        add     si, dx
        mov     dx, xDstRightDiv8
        add     di, dx
        and     al, 7
        and     bx, 7
        mov     ah, bl
;
; Get destination masks for first and last store.
;
; al = xSrcLeftMod8
; ah = xDstLeftMod8
; bx = xDstLeftMod8
; cl = xSrcRightMod8
; ch = xDstRightMod8
;
        mov     dh, LeftMask1[bx]
        mov     bl, ch
        mov     dl, RightMask1[bx]
        cmp     WORD PTR cDstByte, 0
        jne     @F
        and     dl, dh
@@:     mov     Masks, dx
        mov     dl, Flags
;
; Calculate rotation direction.
;
        sub     cl, ch
        jns     @F
        add     cl, 8
        or      dl, bPreFetch
@@:     cmp     al, ah
        jb      @F
        or      dl, bLastFetch
@@:     std
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;bx = rop
;cl = RightShift
;ch = LeftShift
;dl = Flags
;si = pSrcScan
;di = pDstScan
;
RopFunc:
        mov     Flags, dl
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, rop
        add     bx, bx
        mov     rop, bx
        mov     bx, mempBltSD11Tbl[bx]
        jmp     bx
memBltSD_MonoToMono     ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 1                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r1   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        mov     dh, es:[di]
        or      al, dh
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        mov     dh, es:[di]
        or      al, dh
        not     al
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        mov     dh, es:[di]
        or      ah, dh
        not     ah
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r1   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 2                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r2   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:         
        not     al
        and     al, es:[di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        not     al
        and     al, es:[di]
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        not     ah
        and     ah, es:[di]
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r2   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 3                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r3   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        not     al
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        not     ah
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r3   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 4                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r4   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        mov     dh, es:[di]
        not     dh
        and     al, dh
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        mov     dh, es:[di]
        not     dh
        and     al, dh
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        mov     dh, es:[di]
        not     dh
        and     ah, dh
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r4   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 6                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r6   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        xor     al, es:[di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        xor     al, es:[di]
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        xor     ah, es:[di]
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r6   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 7                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r7   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        and     al, es:[di]
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        and     al, es:[di]
        not     al
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        and     ah, es:[di]
        not     ah
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r7   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 8                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r8   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        and     al, es:[di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        and     al, es:[di]
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        and     ah, es:[di]
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r8   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = 9                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11r9   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        xor     al, es:[di]
        not     al
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        xor     al, es:[di]
        not     al
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        xor     ah, es:[di]
        not     ah
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11r9   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = B                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11rB   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        not     al
        or      al, es:[di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        not     al
        or      al, es:[di]
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        not     ah
        or      ah, es:[di]
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11rB   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = C                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11rC   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11rC   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = D                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11rD   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        mov     dh, es:[di]
        not     dh
        or      al, dh
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        mov     dh, es:[di]
        not     dh
        or      al, dh
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        mov     dh, es:[di]
        not     dh
        or      ah, dh
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11rD   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          BitBLT   1BPP, rop = E                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD11rE   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanLoopTop:
        mov     bx, Masks
        mov     ch, bh
        xor     ah, ah
        test    dl, bPreFetch
        jz      LoadFirst
        lodsb
        rol     ax, cl
        test    dl, bOneFetch
        jnz     @F
LoadFirst:
        lodsb
@@:     mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
StoreFirst:
        or      al, es:[di]
        and     al, bl
        xor     bl, 0FFh
        jz      @F
        and     bl, es:[di]
        or      al, bl
@@:     stosb
        mov     bx, cDstByte
        or      bx, bx
        jz      NextScan
        dec     bx
        jz      LoadLast
TopLoop:
        lodsb
        mov     dh, ah
        xor     ah, ah
        rol     ax, cl
        or      al, dh
        or      al, es:[di]
        stosb
BottomLoop:
        dec     bx
        jnz     TopLoop
LoadLast:
        test    dl, bLastFetch
        jz      StoreLast
        test    dl, bOneFetch
        jnz     StoreLast
        mov     bl, [si]
        rol     bx, cl
        or      ah, bl
StoreLast:
        or      ah, es:[di]
        and     ah, ch
        xor     ch, 0FFh
        jz      @F
        and     ch, es:[di]
        or      ah, ch
@@:     mov     es:[di], ah
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        mov     bl, dl
        test    bl, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     dl, bl
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD11rE   ENDP

_TEXT           ENDS
                END
