        INCLUDE COMMON.INC
        INCLUDE IV1.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _devpStatus          : DWORD
EXTERN  _devXlateTbl         : BYTE
EXTERN  _devUpdateColorsTbl  : DWORD
EXTERN  _agr_ioport          : WORD
EXTERN  _ioport              : WORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  Ring3ToRing0         : DWORD
EXTERN  Ring0ToRing3         : DWORD

public Rop2XlateTable	
Rop2XlateTable	label	byte

        db      00h     ;Rop2=1         DDx
        db      08h     ;Rop2=2         DPon
        db      04h     ;Rop2=3         DPna
        db      0ch     ;Rop2=4         Pn
        db      02h     ;Rop2=5         PDna
        db      0ah     ;Rop2=6         Dn
        db      06h     ;Rop2=7         DPx
        db      0eh     ;Rop2=8         DPan
        db      01h     ;Rop2=9         DPa
        db      09h     ;Rop2=10        DPxn
        db      05h     ;Rop2=11        D
        db      0dh     ;Rop2=12        DPno
        db      03h     ;Rop2=13        P
        db      0bh     ;Rop2=14        PDno
        db      07h     ;Rop2=15        DPo
        db      0fh     ;Rop2=16        DDxn


_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 32]
yDst            EQU [bp + 30]
lpSrcBits       EQU [bp + 26]
cSrcWidthBytes  EQU [bp + 24]
cSrcWidthBytes_32       EQU [ebp + 24]
cSrcSegScan     EQU [bp + 22]
cSrcSegScan_32  EQU [ebp + 22]
cSrcFillBytes   EQU [bp + 20]
cSrcFillBytes_32        EQU [ebp + 20]
xSrc            EQU [bp + 18]
ySrc            EQU [bp + 16]
xSize           EQU [bp + 14]
xSize_32        EQU [ebp + 14]
ySize           EQU [bp + 12]
ySize_32        EQU [ebp + 12]
clrBack         EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]

pSrcScan        EQU     [bp - 2]
pSrcScan_32     EQU     [ebp - 2]
cSrcScan        EQU     [bp - 4]
cSrcScan_32     EQU     [ebp - 4]
LocXlateTbl     EQU     [bp - 8]        ; DWORD LOCAL XLATE TBL
LocXlateTblSeg  EQU     [bp - 6]
LocXlateTblOff  EQU     [bp - 8]
LocRop          EQU     [bp - 10]
LocConfigPort   EQU     [bp - 12]
LocBurstPort    EQU     [bp - 14]
dmacount        EQU     [bp - 16]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltSD_Color  PROC NEAR       

        push    bp
        mov     bp, sp
        sub     sp, 36

        push    esi
        push    edi
        push    gs
        push    es
        push    fs
        push    ds


        mov     ax, ds
        mov     es, ax




	mov     di,WORD PTR es:_agr_ioport
	shl     di,1
	mov     dx,WORD PTR es:_ioport[di]
        mov     cx,dx                           ;save base port

	add	dx, IV1CONFIG_PORT
        mov     LocConfigPort, dx

        mov     dx, cx                          ;get base port
	add	dx, IV1CFGSTRING_IO_PORT
        mov     LocBurstPort, dx


        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     cx,cx
        mov     cl,al
        mov     LocRop, cx

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]


;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        sub	eax,eax
        mov     gs:[bx][FINISHFLAG0], eax
        mov     WORD PTR gs:[bx][GE_FINISH0], 0
@@:     test    BYTE PTR gs:[bx][FINISHFLAG0], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking


        cmp     WORD PTR LocRop, LO_SOURCECOPY
        jz      BltRopSet

;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking


BltRopSet:

;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        lds     si,lpSrcBits
        bmScanAddrInc cSrcSegScan, cSrcWidthBytes, cSrcScan, ds, si
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        add     si, xSrc
        add     si, xSrc
        add     si, xSrc
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pSrcScan, si
;
; Wait until IV1 idle.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
;
; At this point 
;       ds:si : Starting Pixel Bits
;       gs:bx IV1 GRP Pointer
; 

@@:

    ;
    ; Clear the FINISH1 flag
    ;
        sub	eax,eax
        mov     gs:[bx][FINISHFLAG1], eax
    ;
    ; Wait for GE FIFO to become available.
    ;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
    ;
    ; Send down BitBLT token.
    ;
        mov     WORD PTR gs:[bx][GE_WIN_BITBLT], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], 0;upacmode = 0 (unpacked pixels)
                                                ;packedmode = 3
        mov     ax, xDst
        mov     gs:[bx][FIFO16_OFF], ax         ;starting x
        mov     ax, xSize
        mov     gs:[bx][FIFO16_OFF], ax         ;x size
        mov     ax, yDst
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
	sub	dx, ax                          ;get translated Y
        mov     gs:[bx][FIFO16_OFF], dx         ;starting y
    ;
    ; now we need to send down a "no interrupts" flag
    ;
	mov	ax, IV1BLTDONE                  ;-1(for no interrupts, usethe done flag)
	mov	gs:[bx][FIFO16_OFF], ax

        mov     ax, ySize
        mov     gs:[bx][FIFO16_OFF], ax         ;y length
        mov     ax, IV1BLTDONE
        mov     gs:[bx][FIFO16_OFF], ax         ;done flag
    ;
    ; Wait for microcode to be ready (FINISH1 flag set)
    ;
@@:     test    BYTE PTR gs:[bx][FINISHFLAG1], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking
    ;
    ; Clear the FINISH1 flag
    ;
        sub	eax,eax
        mov     gs:[bx][FINISHFLAG1], eax
    ;
    ; Turn on "string burst" mode
    ;
        mov     dx, LocConfigPort
	in	ax, dx
	or	ax, IV1CFGSTRN_BURST
	out	dx, ax
    ;
    ; Get DMA Port
    ;
        mov     cx, LocBurstPort
        cld


;;;;;;

	movzx	ebp,bp	    
		

	cmp	word ptr es:Ring3ToRing0+2,0
	jz	short @f

	call	es:Ring3ToRing0		;preserves ds, es, ecx, esi, edi, ebp
        mov     dx, cx                  ; get back burst port
@@:


BltYLoop:
        mov     cx,xSize_32
        xor     eax,eax

BltXLoop:
        mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        out     dx,eax
        add     si,3
        dec     cx
        jnz     BltXloop

YContinue:
        dec     WORD PTR ySize_32
        jz      ExitBlt
;
; Increment to next scanline.
;
        mov     si, pSrcScan_32
        bmScanInc si, ds, cSrcSegScan_32, cSrcWidthBytes_32, WORD PTR cSrcScan_32, cSrcFillBytes_32
        mov     pSrcScan_32, si
        jmp     BltYLoop


ExitBlt:
;---------------------------------------------------------------------
; Switch back to Ring 3.
;---------------------------------------------------------------------

	cmp	word ptr es:Ring0ToRing3+2,0
	jz	short @f

	call	es:Ring0ToRing3		;preserves ds, es, ecx, esi, edi, ebp
@@:
   ;
   ;Must Delay before turning off stringburst mode
   ;IV1 HARDWARE BUG
   ;

        mov     cx,IV1HWBUGLOOP         ;do 30 in's from port 84 for delay

IV_DELAYLOOP:
        mov     dx,084h
        in      ax,dx
        loop    IV_DELAYLOOP

   ;
   ;At this point we can turn off stringburst mode
   ;

        mov     dx, LocConfigPort

	in	ax, dx
	and	ax, NOT IV1CFGSTRN_BURST
	out	dx, ax


Exit:
        cmp     WORD PTR LocRop, LO_SOURCECOPY
        jz      BltRopSetBack

;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;


BltRopSetBack:


        pop     ds
        pop     fs
        pop     es
        pop     gs
        pop     edi
        pop     esi


        leave
        ret     30

devBltSD_Color  ENDP


_TEXT   ENDS

        END





