        INCLUDE COMMON.INC
        INCLUDE IV1.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD

EXTERN  Rop2XlateTable       : BYTE 





public BitRTable
BitRTable       label   byte
        db	00h
        db	080h
        db	040h
        db	0c0h
        db	020h
        db	0a0h
        db	060h
        db	0e0h
        db	010h
        db	090h
        db	050h
        db	0d0h
        db	030h
        db	0b0h
        db	070h
        db	0f0h
        db	08h
        db	088h
        db	048h
        db	0c8h
        db	028h
        db	0a8h
        db	068h
        db	0e8h
        db	018h
        db	098h
        db	058h
        db	0d8h
        db	038h
        db	0b8h
        db	078h
        db	0f8h
        db	04h
        db	084h
        db	044h
        db	0c4h
        db	024h
        db	0a4h
        db	064h
        db	0e4h
        db	014h
        db	094h
        db	054h
        db	0d4h
        db	034h
        db	0b4h
        db	074h
        db	0f4h
        db	0ch
        db	08ch
        db	04ch
        db	0cch
        db	02ch
        db	0ach
        db	06ch
        db	0ech
        db	01ch
        db	09ch
        db	05ch
        db	0dch
        db	03ch
        db	0bch
        db	07ch
        db	0fch
        db	02h
        db	082h
        db	042h
        db	0c2h
        db	022h
        db	0a2h
        db	062h
        db	0e2h
        db	012h
        db	092h
        db	052h
        db	0d2h
        db	032h
        db	0b2h
        db	072h
        db	0f2h
        db	0ah
        db	08ah
        db	04ah
        db	0cah
        db	02ah
        db	0aah
        db	06ah
        db	0eah
        db	01ah
        db	09ah
        db	05ah
        db	0dah
        db	03ah
        db	0bah
        db	07ah
        db	0fah
        db	06h
        db	086h
        db	046h
        db	0c6h
        db	026h
        db	0a6h
        db	066h
        db	0e6h
        db	016h
        db	096h
        db	056h
        db	0d6h
        db	036h
        db	0b6h
        db	076h
        db	0f6h
        db	0eh
        db	08eh
        db	04eh
        db	0ceh
        db	02eh
        db	0aeh
        db	06eh
        db	0eeh
        db	01eh
        db	09eh
        db	05eh
        db	0deh
        db	03eh
        db	0beh
        db	07eh
        db	0feh
        db	01h
        db	081h
        db	041h
        db	0c1h
        db	021h
        db	0a1h
        db	061h
        db	0e1h
        db	011h
        db	091h
        db	051h
        db	0d1h
        db	031h
        db	0b1h
        db	071h
        db	0f1h
        db	09h
        db	089h
        db	049h
        db	0c9h
        db	029h
        db	0a9h
        db	069h
        db	0e9h
        db	019h
        db	099h
        db	059h
        db	0d9h
        db	039h
        db	0b9h
        db	079h
        db	0f9h
        db	05h
        db	085h
        db	045h
        db	0c5h
        db	025h
        db	0a5h
        db	065h
        db	0e5h
        db	015h
        db	095h
        db	055h
        db	0d5h
        db	035h
        db	0b5h
        db	075h
        db	0f5h
        db	0dh
        db	08dh
        db	04dh
        db	0cdh
        db	02dh
        db	0adh
        db	06dh
        db	0edh
        db	01dh
        db	09dh
        db	05dh
        db	0ddh
        db	03dh
        db	0bdh
        db	07dh
        db	0fdh
        db	03h
        db	083h
        db	043h
        db	0c3h
        db	023h
        db	0a3h
        db	063h
        db	0e3h
        db	013h
        db	093h
        db	053h
        db	0d3h
        db	033h
        db	0b3h
        db	073h
        db	0f3h
        db	0bh
        db	08bh
        db	04bh
        db	0cbh
        db	02bh
        db	0abh
        db	06bh
        db	0ebh
        db	01bh
        db	09bh
        db	05bh
        db	0dbh
        db	03bh
        db	0bbh
        db	07bh
        db	0fbh
        db	07h
        db	087h
        db	047h
        db	0c7h
        db	027h
        db	0a7h
        db	067h
        db	0e7h
        db	017h
        db	097h
        db	057h
        db	0d7h
        db	037h
        db	0b7h
        db	077h
        db	0f7h
        db	0fh
        db	08fh
        db	04fh
        db	0cfh
        db	02fh
        db	0afh
        db	06fh
        db	0efh
        db	01fh
        db	09fh
        db	05fh
        db	0dfh
        db	03fh
        db	0bfh
        db	07fh
        db	0ffh



_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 36]
yDst            EQU [bp + 34]
lpSrcBits       EQU [bp + 30]
cSrcWidthBytes  EQU [bp + 28]
cSrcSegScan     EQU [bp + 26]
cSrcFillBytes   EQU [bp + 24]
xSrc            EQU [bp + 22]
ySrc            EQU [bp + 20]
xSize           EQU [bp + 18]
ySize           EQU [bp + 16]
clrFore         EQU [bp + 12]
colorBack       EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]



pSrcScan        EQU     [bp - 2]
cSrcScan        EQU     [bp - 4]
LocRop          EQU     [bp - 6]


_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING


devBltSD_Mono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 40
        push    esi
        push    edi
        push    gs
        push    es
        push    ds

        mov     ax, ds
        mov     es, ax

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;
; Set Clip Rectangle
;

        mov     WORD PTR gs:[di][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[di][FIFO16_OFF], 1
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, yDst
        add     ax, ySize
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[di][FIFO16_OFF], dx     
        mov     ax, xDst
        add     ax, xSize
        dec     ax
        mov     gs:[di][FIFO16_OFF], ax     
        sub     cx, yDst
        mov     gs:[di][FIFO16_OFF], cx         ; Ytranslation-starty


   ;
   ; Clipped in X and Y
   ;
;
; Done Setting Clip
;

        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     cx,cx
        mov     cl,al


        mov     LocRop, cx

        cmp     WORD PTR LocRop, LO_SOURCECOPY
        jz      BltRopSet

;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     gs:[di][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

BltRopSet:

;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        lds     si,lpSrcBits
        bmScanAddrInc cSrcSegScan, cSrcWidthBytes, cSrcScan, ds, si
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment


        mov     ds, dx
        mov     si, ax

        mov     ax, xSrc                
        shr     ax, 3                           ; convert to bytes
        add     si, ax                          ; increment bit pointer to start




;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;

        mov     pSrcScan, si


   ;
   ; cx = rop
   ; special case source copy

        cmp     cx,LO_SOURCECOPY
        jnz     NOTSourceCopy

   ; 
   ; at this point, we know its a source copy so do it in 2 passes 
   ; special cased
   ;



        mov     ebx, clrFore

        mov     WORD PTR gs:[di][GE_RGBCOLOR], 0
        mov     eax, ebx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[di][FIFO16_OFF],ax          ; red color data
        mov     al, bh
        mov     gs:[di][FIFO16_OFF],ax          ; green color data
        mov     al, bl                  
        mov     gs:[di][FIFO16_OFF],ax          ; blue color data




        mov     dx, es:_Y_TRANSLATION

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[di][GE_SOLIDBRUSH], 0
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     

        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ;Y translated start 
        
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax


        mov     ax, xSrc
        and     ax, 07h
        add     xSize, ax
        sub     xDst, ax



    ; 
    ; Now do Background SourceCopy
    ;


        mov     ebx, colorBack

        mov     WORD PTR gs:[di][GE_RGBCOLOR], 0
        mov     eax, ebx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[di][FIFO16_OFF],ax          ; red color data
        mov     al, bh
        mov     gs:[di][FIFO16_OFF],ax          ; green color data
        mov     al, bl                  
        mov     gs:[di][FIFO16_OFF],ax          ; blue color data




        mov     dx, xSize
        add     dx,0fh
        shr     dx,4
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[di][GE_MONOPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst

        cwde    
        mov     gs:[di][FIFO_OFF], eax     


        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin




BltYLoop:
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     cx,xSize

        sub     cx, 16
        js      WordLeft
BltXLoop16:
        test    WORD PTR si,FIFOLIMIT AND 0feh
        jnz     NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NoCheck:

        mov     ax,word ptr ds:[si]
        xchg    ah,al                           ; NOT BIG ENDIAN
        mov     gs:[di][FIFO16_OFF], ax     
        or      cx, cx
        jz      YContinue
        add     si, 2
        sub     cx,16
        jae     BltXLoop16
;
; Guaranteed to have less than 16 pixels left here.
;

WordLeft:
        add     cx, 16
        cmp     cx, 8
        jle     @F
        sub     cx, cx                  ;Set Zero Flag
                                        ;and do one more WORD
        jmp     BltXLoop16      
@@:
        mov     ah, BYTE PTR ds:[si]    ;ah not al cause big endian
        cmp     cx, 9
        jl      BltXLast
        mov     al, BYTE PTR ds:[si][1]
BltXLast:
        mov     gs:[di][FIFO16_OFF], ax     


YContinue:
        dec     WORD PTR ySize
        jz      Exit



        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     BltYLoop

NOTSourceCopy:

        mov     ax, xSrc
        and     ax, 07h
        add     xSize, ax
        sub     xDst, ax

        push    cSrcSegScan
        push    ySize
        push    ds                              ; save offset & seg to bits
        push    si

;;;;

        mov     ebx, clrFore

        mov     WORD PTR gs:[di][GE_RGBCOLOR], 0
        mov     eax, ebx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[di][FIFO16_OFF],ax          ; red color data
        mov     al, bh
        mov     gs:[di][FIFO16_OFF],ax          ; green color data
        mov     al, bl                  
        mov     gs:[di][FIFO16_OFF],ax          ; blue color data


;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking


        mov     bx, OFFSET es:BitRTable



        mov     dx, xSize
        add     dx,0fh
        shr     dx,4                            ; calc shorts per row

        mov     WORD PTR gs:[di][GE_ROPPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst

        cwde    
        mov     gs:[di][FIFO_OFF], eax     

        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin




NSC_FORE_BltYLoop:
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     cx,xSize

        sub     cx, 16
        js      NSC_FORE_Word_Left
NSC_FORE_BltXLoop16:
        test    WORD PTR si,FIFOLIMIT AND 0feh
        jnz     NSC_FORE_NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NSC_FORE_NoCheck:

        mov     ax,word ptr ds:[si]
        xlatb   es:[bx]
        xchg    ah,al                           ; NOT BIG ENDIAN
        xlatb   es:[bx]
        xchg    ah,al                           ; NOT BIG ENDIAN
        not     ax
        mov     gs:[di][FIFO16_OFF], ax     
        or      cx, cx
        jz      NSC_FORE_YContinue
        add     si, 2
        sub     cx,16
        jae     NSC_FORE_BltXLoop16
;
; Guaranteed to have less than 16 pixels left here.
;

NSC_FORE_Word_Left:
        add     cx, 16
        cmp     cx, 8
        jle     @F
        sub     cx, cx                  ;Set Zero Flag
                                        ;and do one more WORD
        jmp     NSC_FORE_BltXLoop16      
@@:
        mov     al, BYTE PTR ds:[si]
        xlatb   es:[bx]
        mov     ah, al                  ;ah not al cause big endian
        cmp     cx, 9
        jl      NSC_FORE_BltXLast
        mov     al, BYTE PTR ds:[si][1]
        xlatb   es:[bx]
NSC_FORE_BltXLast:
xchg    ah,al                           ; NOT BIG ENDIAN
        not     ax
        mov     gs:[di][FIFO16_OFF], ax     


NSC_FORE_YContinue:
        dec     WORD PTR ySize
        jz      NSC_FORE_Done



        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     NSC_FORE_BltYLoop


NSC_FORE_Done:
    ; 
    ; Now do Background NOT SourceCopy
    ;
        pop     si                              ; restore offset & seg to bits
        pop     ds
        pop     ax
        mov     ySize,ax
        mov     pSrcScan, si
        pop     ax
        mov     cSrcScan,ax





        mov     ebx, colorBack

        mov     WORD PTR gs:[di][GE_RGBCOLOR], 0
        mov     eax, ebx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[di][FIFO16_OFF],ax          ; red color data
        mov     al, bh
        mov     gs:[di][FIFO16_OFF],ax          ; green color data
        mov     al, bl                  
        mov     gs:[di][FIFO16_OFF],ax          ; blue color data


        mov     bx, OFFSET es:BitRTable


;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking





        mov     dx, xSize
        add     dx,0fh
        shr     dx,4                            ; calc shorts per row

        mov     WORD PTR gs:[di][GE_ROPPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst
        cwde    
        mov     gs:[di][FIFO_OFF], eax     

        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin




NSC_BACK_BltYLoop:
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     cx,xSize

        sub     cx, 16
        js      NSC_BACK_Word_Left
NSC_BACK_BltXLoop16:
        test    WORD PTR si,FIFOLIMIT AND 0feh
        jnz     NSC_BACK_NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NSC_BACK_NoCheck:
        mov     ax,word ptr ds:[si]

        xlatb   es:[bx]
        xchg    ah,al                           ; NOT BIG ENDIAN
        xlatb   es:[bx]
        xchg    ah,al                           ; NOT BIG ENDIAN
        mov     gs:[di][FIFO16_OFF], ax     
        or      cx, cx
        jz      NSC_BACK_YContinue
        add     si, 2
        sub     cx,16
        jae     NSC_BACK_BltXLoop16
;
; Guaranteed to have less than 16 pixels left here.
;

NSC_BACK_Word_Left:
        add     cx, 16
        cmp     cx, 8
        jle     @F
        sub     cx, cx                  ;Set Zero Flag
                                        ;and do one more WORD
        jmp     NSC_BACK_BltXLoop16      
@@:
        mov     al, BYTE PTR ds:[si]    
        xlatb   es:[bx]
        mov     ah, al                  ;ah not al cause big endian
        cmp     cx, 9
        jl      NSC_BACK_BltXLast
        mov     al, BYTE PTR ds:[si][1]
        xlatb   es:[bx]

NSC_BACK_BltXLast:
xchg    ah,al                           ; NOT BIG ENDIAN
        mov     gs:[di][FIFO16_OFF], ax     


NSC_BACK_YContinue:
        dec     WORD PTR ySize
        jz      NSC_BACK_Done



        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     NSC_BACK_BltYLoop


NSC_BACK_Done:
Exit:

;
; Wait until IV1 idle.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
;
; Reset Clip plane to FULL SCREEN
;

        mov     WORD PTR gs:[di][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[di][FIFO16_OFF], 1
        mov     ax, 0
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, es:_GLOB_Y_Size
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[di][FIFO16_OFF], dx     
        mov     ax, es:_GLOB_X_Size
        dec     ax
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Resetting Clip
;


;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        cmp     WORD PTR LocRop, LO_SOURCECOPY
        jz      BltRopSetBack
;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;


BltRopSetBack:

        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi

        leave
        ret     34


devBltSD_Mono   ENDP




_TEXT   ENDS

        END


