        INCLUDE COMMON.INC
        INCLUDE IV1.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;       07/02/93 Dave Schmenk - added pattern alignment                      ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD

EXTERN  Rop2XlateTable       : BYTE 

EXTERN  BitRTable            : BYTE


_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 16]
yDst            EQU [bp + 14]
lpPat           EQU [bp + 10]
xSize           EQU [bp + 8]
ySize           EQU [bp + 6]
rop             EQU [bp + 4]

xPat            EQU [bp - 2]
IVoffset        EQU [bp - 6]
yIV1Loop        EQU [bp - 8]
IVmode          EQU [bp - 10]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING


devBltPD_Color  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 20
        push    esi
        push    edi
        push    gs
        push    ds
        push    es
        mov     ax, ds
        mov     es, ax
;
; Get IV1 GRP PTR
;
        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
        mov     IVoffset, di
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        lds     si,lpPat
        mov     di, xDst
        sub     di, [si][BRUSH_X]
        and     di, 7
        mov     xPat, di
        mov     di, yDst
        sub     di, [si][BRUSH_Y]
        and     di, 7
        xor     cx, cx
        mov     bx, rop                         ; rop is in al, ah reserved
        mov     cl, es:Rop2XlateTable[bx]
        mov     WORD PTR IVmode, 0
;        
; setting IV1 ROP
;
        mov     bx,IVoffset
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
GotUPAC:
        mov     bx, IVoffset
        mov     WORD PTR gs:[bx][GE_SCRMASK], 0
;
;  Need a Y translation first then, a reversal of start y and end y
;  because IV is looking for coords in lly first and coming in as uly
;  first, etc  
;
        mov     WORD PTR gs:[bx][FIFO16_OFF], 1
        mov     ax, xDst                     ; rectLeft
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, yDst
        add     ax, ySize                       ; rectBottom
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[bx][FIFO16_OFF], dx     
        mov     ax, xDst                        ; rectRight
        add     ax, xSize
        dec     ax
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     ax, yDst                        ; rectTop
        sub     cx, ax
        mov     gs:[bx][FIFO16_OFF], cx         ; Ytranslation-starty
;
; Done Setting Clip
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
        mov     WORD PTR gs:[bx][GE_COLORBRUSHLOAD], 0
;        mov     ax,IVmode
        mov     WORD PTR gs:[bx][FIFO16_OFF], 0  ;upacmode = 3 (packed pixels)
                                                 ;           0 unpacked
        mov     ch, 8
BltYLoop:
;
; Get current scanline of brush into ebx:esi (8 pixels worth).
; di = current pattern scanline.
;
        mov     si, lpPat
        mov     ax, di
        imul    ax, 24
        add     si, ax
        mov     dx, xPat
        add     si, dx
        add     si, dx
        add     si, dx
        add     si, BRUSH_COLOR
        mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
        add     si, 3
        inc     dx
        and     dx, 7
        jnz     @F
        sub     si, 24
@@:     mov     al, [si]
        shl     eax, 16
        mov     ah, [si + 1]
        mov     al, [si + 2]
        mov     DWORD PTR gs:[bx][FIFO_OFF], eax
YContinue:
        inc     di                                      ;outer counter
	and	di, 7
        dec     ch
        jnz     BltYLoop
;
; Send BRUSH_FILL token.
;
        mov     di, IVoffset
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     cx,IVmode
        mov     WORD PTR gs:[di][GE_COLORBRUSH], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], cx        ; upacmode
        mov     ax, xDst
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     ax, yDst
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
	sub	dx, ax                          ;get translated Y
        mov     gs:[di][FIFO16_OFF], dx         ;starting y
	mov	bx, xSize
	mov	cx, ySize
        add     bx, 7
        add     cx, 7
        shr     bx, 3
        shr     cx, 3                   ; calculate number of x and ybrushes
        mov     gs:[di][FIFO16_OFF], bx        
        mov     gs:[di][FIFO16_OFF], cx        
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
        cmp     WORD PTR rop, 0Ch
        je      BltRopSetBack
;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[di][FIFO16_OFF], ax     
;
; Wait until IV1 idle.
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
BltRopSetBack:
;
; Reset Clip plane to FULL SCREEN
;
        mov     WORD PTR gs:[di][GE_SCRMASK], 0
;
;  Need a Y translation first then, a reversal of start y and end y
;  because IV is looking for coords in lly first and coming in as uly
;  first, etc  
;
        mov     WORD PTR gs:[di][FIFO16_OFF], 1
        mov     ax, 0
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, es:_GLOB_Y_Size
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[di][FIFO16_OFF], dx     
        mov     ax, es:_GLOB_X_Size
        dec     ax
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], cx         ; Ytranslation-starty
;
; Done Resetting Clip
;
Exit:
        pop     es
        pop     ds
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     14
devBltPD_Color  ENDP

_TEXT   ENDS

        END

