.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV1.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Screen to Screen Bitblt.                                         ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/14/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN  _GRP                 : DWORD
EXTERN Rop2XlateTable : BYTE
EXTERN  _Y_TRANSLATION       : WORD

.CODE
.386

devBltSD_DevToDev     PROC NEAR USES gs                    \
        xDst  : WORD,                   \
        yDst  : WORD,                   \
        xSrc  : WORD,                   \
        ySrc  : WORD,                   \
        xSize : WORD,                   \
        ySize : WORD,                   \
        clrBack : DWORD,                \
        modeBack: WORD,                 \  
        rop   : WORD




        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     cx,cx
        mov     cl,al

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[bx][GE_READSOURCE], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], RW_FBUFFER_28     ; full 28bit fb



        cmp     cx, LO_SOURCECOPY
        jz      BltRopSet
;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

BltRopSet:

        mov     dx, ds:_Y_TRANSLATION           ;Glob Ysize-1
        mov     WORD PTR gs:[bx][GE_RECTCOPY], 0
        mov     ax, ySrc
        add     ax, ySize
        dec     ax
        sub     dx, ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], dx
        mov     ax, yDst
        add     ax, ySize
        dec     ax
        mov     dx, ds:_Y_TRANSLATION           ;Glob Ysize-1
        sub     dx, ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], dx
        mov     ax, ySize
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     ax, xSrc
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     ax, xDst
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     ax, xSize
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax


;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        cmp     cx, LO_SOURCECOPY
        jz      BltRopSetBack
;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;

BltRopSetBack:

        ret
devBltSD_DevToDev       ENDP


        END


