.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Match color to logical or physical color.                        ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/28/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN  _devSystemPalette : DWORD
EXTERN  _devColorToMono   : BYTE

.CODE
.386

;
; Match a logical color to the nearest representable physical color.
;
devMatchPhysicalColor   PROC NEAR USES esi edi, clr : DWORD

        mov     al, BYTE PTR clr + 2
        mov     ah, BYTE PTR clr + 1
        mov     dl, BYTE PTR clr
        mov     dh, 0ffh
        ret
devMatchPhysicalColor   ENDP

;
; Match a physical color to the nearest representable logical color.
; Return physical color if not in the system palette (i.e. palette managed).
;
devColorMatchLogicalColor       PROC NEAR clr : DWORD

        mov     al, BYTE PTR clr + 2
        mov     ah, BYTE PTR clr + 1
        mov     dl, BYTE PTR clr
        xor     dh,dh
        ret
devColorMatchLogicalColor       ENDP

;
; Match a physical color to the nearest representable logical color.
; Return physical color if not in the system palette (i.e. palette managed).
;
devMonoMatchLogicalColor        PROC NEAR clr : DWORD

        RGB2Mono clr
        sbb     ax, ax
        mov     dl, al
        xor     dh, dh
        ret
devMonoMatchLogicalColor        ENDP
        END

