.386
                INCLUDE WINDEFS.INC
                INCLUDE IV1.INC

_DATA	        SEGMENT WORD PUBLIC USE16 'DATA'


EXTERN  _GRP                 : DWORD

EXTERN  _GlobCursXPos        : WORD
EXTERN  _GlobCursYPos        : WORD
EXTERN  _GlobCursXHotSpot    : WORD
EXTERN  _GlobCursYHotSpot    : WORD
EXTERN  _iv_curs_xoff        : WORD
EXTERN  _iv_curs_yoff        : WORD

_DATA	        ENDS
CONST	        SEGMENT WORD PUBLIC USE16 'CONST'
CONST	        ENDS
_BSS	        SEGMENT WORD PUBLIC USE16 'BSS'
_BSS	        ENDS
DGROUP	        GROUP CONST, _BSS, _DATA


tmpX            EQU [bp - 4]
tmpY            EQU [bp - 6]

_TEXT           SEGMENT WORD PUBLIC USE16 'CODE'

        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

;
; CheckCursor is called at timer interrupt time so its entrypoint is in 
; assembly. It is called as:
;
;       CheckCursor();
;

CHECKCURSOR     PROC FAR

;
; Since we assume a hardware cursor, this should be a NOOP.
;
        ret

CHECKCURSOR     ENDP

;
; MoveCursor is called at mouse interrupt time so its entrypoint is in 
; assembly. It is called as:
;
;       MoveCursor(wAbsX, wAbsY);
;

wAbsX   EQU     [bp + 8]
wAbsY   EQU     [bp + 6]


MOVECURSOR      PROC FAR
        push    bp
        mov     bp, sp
        sub     sp, 8
        push    gs
        push    ds
        push    dx
        push    eax
        push    ebx
        push    ecx


        mov     ax, DGROUP
        mov     ds, ax
;
; Do MoveCursor processing.
;
        EnterCrit


;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]

        mov     ax,wAbsX
        mov     _GlobCursXPos,ax
        add     ax,_iv_curs_xoff
        sub     ax,_GlobCursXHotSpot
        mov     tmpX,ax


        mov     ax,wAbsY
        mov     _GlobCursYPos,ax
        add     ax,_iv_curs_yoff
        sub     ax,_GlobCursYHotSpot
        mov     tmpY,ax

        HQMMSB_SET

        ;
        ; Write Address Reg
        ;
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG0], CURS_XLO
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG1], CURS_XLO

        ;
        ; Curs Chip address reg auto increments

        xor     eax,eax
        mov     ax,tmpX
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax

        xor     eax,eax
        mov     ax,tmpY
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax

        ;
        ; Now Cursor 1
        ;
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG0], CURS_XLO
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG1], CURS_XLO


        ;
        ; Curs Chip address reg auto increments

        xor     eax,eax
        mov     ax,tmpX
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax

        xor     eax,eax
        mov     ax,tmpY
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax


        HQMMSB_CLR

        LeaveCrit

    
        pop     ecx
        pop     ebx
        pop     eax
        pop     dx
        pop     ds
        pop     gs
        leave
        ret     4

MOVECURSOR      ENDP





lpCursorShape   EQU     [bp + 6]

SETCURSOR      PROC FAR
        push    bp
        mov     bp, sp
        sub     sp, 8
        push    si
        push    di
        push    gs
        push    es
        push    ds
        push    eax
        push    ebx
        push    ecx
        push    edx


        mov     ax, DGROUP
        mov     ds, ax
        mov     es, ax

        EnterCrit


;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]

;
; Call Disable Cursor(dx=0)
;
        mov     cx,0
        call    IV1DISPLAYENABLECURSOR 



        HQMMSB_SET                              ; HQMMSB_WR(1)

        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG0], 0
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG1], 0


        cmp     dword ptr lpCursorShape,0
        jz      SetCursorExit

        lds     si,lpCursorShape
        mov     di,si
        add     di,sizeof cursorShape                   ;di points at cursor bits


        mov     cx,[si + cursorShape.csHeight]
        cmp     cx,0
        jz      SetCursorExit
        xor     edx,edx
AndMaskLoop:
        mov     eax,[di]
        add     di,4
        not     eax
        
        mov     dl,al
        shr     eax,8



        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], edx

        mov     dl,al
        shr     eax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], edx

        mov     dl,al
        shr     eax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], edx

        mov     dl,al
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], edx


        xor     eax,eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax


        dec     cx
        jnz     AndMaskLoop


        mov     cx,32
        sub     cx,[si + cursorShape.csHeight]

        jz      FinishedAndMask
        xor     eax,eax

FinishAndLoop:
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_GLYPH], eax

        dec     cx
        jnz     FinishAndLoop
FinishedAndMask:

        ;
        ; Load cursor glyph #1 
        ;

        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG0], 0
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG1], 0




        mov     cx,[si + cursorShape.csHeight]
        xor     edx,edx
DoXOrMask:

        mov     eax,[di]
        add     di,4
        mov     dl,al
        shr     eax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], edx

        mov     dl,al
        shr     eax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], edx

        mov     dl,al
        shr     eax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], edx

        mov     dl,al
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], edx


        xor     eax,eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax

        dec     cx
        jnz     DoXOrMask


        mov     cx,32
        sub     cx,[si + cursorShape.csHeight]
        jz      FinishedXORMask

        xor     eax,eax

FinishXORLoop:
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_GLYPH], eax

        dec     cx
        jnz     FinishXORLoop

FinishedXORMask:

        mov     ax,[si + cursorShape.csHotX]
        mov     dx,[si + cursorShape.csHotY]
        mov     es:_GlobCursXHotSpot,ax
        mov     es:_GlobCursYHotSpot,dx



        ;
        ; Now set the the new position(hot spot changed) 
        ;

        mov     ax,es:_GlobCursXPos
        add     ax,es:_iv_curs_xoff
        sub     ax,es:_GlobCursXHotSpot
        mov     tmpX,ax


        mov     ax,es:_GlobCursYPos
        add     ax,es:_iv_curs_yoff
        sub     ax,es:_GlobCursYHotSpot
        mov     tmpY,ax

        ;
        ; Write Address Reg
        ;
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG0], CURS_XLO
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG1], CURS_XLO

        ;
        ; Curs Chip address reg auto increments

        xor     eax,eax
        mov     ax,tmpX
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax

        xor     eax,eax
        mov     ax,tmpY
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax

        ;
        ; Now Cursor 1
        ;
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG0], CURS_XLO
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG1], CURS_XLO


        ;
        ; Curs Chip address reg auto increments

        xor     eax,eax
        mov     ax,tmpX
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax

        xor     eax,eax
        mov     ax,tmpY
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax
        shr     ax,8
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax


        HQMMSB_CLR



        mov     cx,1                                    ; 
                                                        ; enable cursor
                                                        ; 
        call    IV1DISPLAYENABLECURSOR 

SetCursorExit:
        LeaveCrit

        pop     edx
        pop     ecx
        pop     ebx
        pop     eax
        pop     ds
        pop     es
        pop     gs
        pop     di
        pop     si
        leave
        ret     4
SETCURSOR      ENDP


; IV1DisplayEnableCursor
;
; cx = 1 enable
; cx = 0 disable
; gs:bx = IV1 segment
;
IV1DISPLAYENABLECURSOR          PROC NEAR


        HQMMSB_SET
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG0], CURS_CMD
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_AREG1], CURS_CMD

        mov     eax, CURS_5TO1MUX

        cmp     cx,1
        jnz     SetCurs                    ; jump to SetCurs which will
                                           ; disable IV1 cursor
EnableCurs:
        or      eax, CURS_BLOCK
SetCurs:
        mov     DWORD PTR gs:[bx][CURS0_OFF OR CURS_CR], eax

        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG0], CURS_CMD
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_AREG1], CURS_CMD
        mov     DWORD PTR gs:[bx][CURS1_OFF OR CURS_CR], eax

        HQMMSB_CLR

        ret

IV1DISPLAYENABLECURSOR          ENDP

_TEXT           ENDS
                END

