/****************************************************************************\
*                                                                            *
* Function: Device initialization entrypoints                                *
*                                                                            *
*       Initialize device specific fields in the GDIINFO and DEVICE          *
*       structures.  Init and uninit graphics hardware.                      *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/19/93 Dave Schmenk - wrote it.                                    *
*       06/09/93 Dwight Diercks - Added IV2 Init stuff                       *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1993 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "iv1.h"

#define WIN_DRIVER 1
#define AGR 1

#include "invent.h"
#include "gfxboard.h"
#include "ge5_glob.h"
#include "re.h"
#include "gecmds.h"
#include "iv_ucode.h"
#include "externs.h"
#include "protos.h"
#include "atsubr.h"


//
//External function references
//

#ifdef DEBUGINIT
VOID test_routine(VOID);
#endif

VOID PASCAL SetMultiResSetting(VOID);
VOID devpColor(DWORD );
VOID devpBlock(DWORD, DWORD , DWORD ,DWORD ,DWORD );
VOID WINAPI SetPalette(WORD,WORD,LPRGBQUAD);
VOID hook_int_2fh(VOID);
VOID PASCAL devInitProtIO(VOID);

//
// Global Variables
//

int GLOB_X_Size=1024;
int GLOB_Y_Size=768;
int GLOB_Sync=0;




//
// Used to determine if IV1 should be shut off when disable is called.
//

int IV1Off=1;

//
// External Variables 
//

extern DWORD devSystemPalette[];
extern DWORD devPalette[];
extern BYTE  devXlateTbl[];
extern BYTE  devUnxlateTbl[];
extern devpStatus;


int iv_init(VOID);
int far iv_save_state(void);

void iv_setscrnmode(long mode);

WORD PASCAL devEnableHW
(
    VOID
)
{
    WORD ii;

    DBGMSG("devEnableHW\n\r");


    if (!(iv_init()))
        return(FALSE);

    //
    // Load up device palette.
    //
                   
    for (ii = 0; ii < 10; ii++)
    {
        devPalette[ii] = devSystemPalette[ii] & 0x00FFFFFFL;
        devPalette[ii + 246] = devSystemPalette[ii + 10] & 0x00FFFFFFL;
    }
    for (ii = 10; ii < 246; ii++)
        devPalette[ii] = 0;

    SetPalette(0,10,(LPRGBQUAD)&devPalette[0]);
    SetPalette(246,10,(LPRGBQUAD)&devPalette[246]);

    //
    // Set identity for palette translation tables.
    //

    for (ii = 0; ii < 256; ii++)
    {
        devXlateTbl[ii]   = (BYTE)ii;
        devUnxlateTbl[ii] = (BYTE)ii;
    }

    hook_int_2fh();


    devInitProtIO();

    //
    // Indicate success.
    //

    return(TRUE);
}



WORD FAR PASCAL devEnableHWFAR
(
    VOID
)
{
    return(devEnableHW());
}





#define MAXFNAMELEN             64

VOID PASCAL SetMultiResSetting
(
VOID
)
{
    char    RetString[MAXFNAMELEN];

    GetPrivateProfileString( "IV1TC.DRV", "NumColors",
                             "Low",(LPSTR)RetString, 
                             MAXFNAMELEN, "SYSTEM.INI" );
    switch (*RetString)
    {
        case 'l'    :
        case 'L'    :
            //
            // "Low" : This is the default - works with most apps.
            //

            break;
        case 'h'    :
        case 'H'    :
            //
            // "High" : This may be needed to work with some "true color" apps.
            //

            devpStatus |= MULTICOLOR_64K;
        default     :
            break;
    }

    GetPrivateProfileString( "IV1TC.DRV", "ResourceSize",
                             "Large",(LPSTR)RetString, 
                             MAXFNAMELEN, "SYSTEM.INI" );
    switch (*RetString) {

        case 's'    :
        case 'S'    :
            devpStatus |= MULTIRES_96DPI;
            break;
        case 'l'    :
        case 'L'    :
        default     :
            break;
    }

    GetPrivateProfileString( "IV1TC.DRV", "Resolution",
                             "Low",(LPSTR)RetString, 
                             MAXFNAMELEN, "SYSTEM.INI" );
    switch (*RetString) {

        case 'h'    :
        case 'H'    :
            GLOB_X_Size = 1280;
            GLOB_Y_Size = 1024;
            break;
        case 'l'    :
        case 'L'    :
        default     :
            GLOB_X_Size = 1024;
            GLOB_Y_Size = 768;
            break;
    }

    GetPrivateProfileString( "IV1TC.DRV", "SeparateSync",
                             "No",(LPSTR)RetString, 
                             MAXFNAMELEN, "SYSTEM.INI" );
    switch (*RetString) {

        case 'y'    :
        case 'Y'    :
            GLOB_Sync = 1;
            break;
        case 'n'    :
        case 'N'    :
        default     :
            GLOB_Sync = 0;
            break;
    }
}


VOID PASCAL devDisableHW
(
    VOID
)
{
    DBGMSG("devDisableHW\n\r");

    iv_setscrnmode(SCMD_VGAMODE);
    if (IV1Off)
        outp(ioport[agr_ioport] + CONFIG_PORT, 1);
}

//
// This routine is called from INT2f function only.
//

VOID FAR PASCAL devDisableHWFAR
(
    VOID
)
{
    //
    // Save Cursor Color Table  and glyph
    //
   
    iv_save_state();

    IV1Off = 0;
    devDisableHW();
    IV1Off = 1;
}

VOID PASCAL devGdiInfo
(
    GDIINFO * pGdiInfo
)
{
    DBGMSG("devGdiInfo\n\r");

    pGdiInfo->dpHorzSize      = 280;
    pGdiInfo->dpVertSize      = 210;
    pGdiInfo->dpBitsPixel     = 24;
    pGdiInfo->dpNumPalReg     = 256;
    pGdiInfo->dpPalReserved   = 20;

    //
    // Although MS claims these fields should be 0xFFFF for true color
    // devices, in practice it is better to leave these similar to most
    // other Windows boards i.e. 16, 20 or 256.  Using a profile string
    // to set this allows fixing certain apps in the field without a
    // new driver.
    //
    //       Dave.
    //

    if (devpStatus & MULTICOLOR_64K)
    {
        pGdiInfo->dpNumColors     = 0xFFFF;
        pGdiInfo->dpNumPens       = 0xFFFF;
        pGdiInfo->dpNumBrushes    = 0xFFFF;
    }
    else
    {
        pGdiInfo->dpNumColors     = 20;
        pGdiInfo->dpNumPens       = 20;
        pGdiInfo->dpNumBrushes    = 20;
    }
    pGdiInfo->dpMLoWin.xcoord = 2800;
    pGdiInfo->dpMLoWin.ycoord = 2100;
    pGdiInfo->dpMHiWin.xcoord = 28000;
    pGdiInfo->dpMHiWin.ycoord = 21000;
    pGdiInfo->dpELoWin.xcoord = 4375;
    pGdiInfo->dpELoWin.ycoord = 4375;
    pGdiInfo->dpEHiWin.xcoord = 21875;
    pGdiInfo->dpEHiWin.ycoord = 21875;
    pGdiInfo->dpTwpWin.xcoord = 7875;
    pGdiInfo->dpTwpWin.ycoord = 7875;
    if (devpStatus & MULTIRES_96DPI)
    {
        pGdiInfo->dpLogPixelsX    = 96;
        pGdiInfo->dpLogPixelsY    = 96;
    }
    else
    {
        pGdiInfo->dpLogPixelsX    = 120;
        pGdiInfo->dpLogPixelsY    = 120;
    }

    if (GLOB_X_Size == 1024)
    {
        //
        // 1024 x 768
        //

        pGdiInfo->dpHorzRes       = 1024;
        pGdiInfo->dpVertRes       = 768;
        pGdiInfo->dpMLoVpt.xcoord = 1024;
        pGdiInfo->dpMLoVpt.ycoord = -768;
        pGdiInfo->dpMHiVpt.xcoord = 1024;
        pGdiInfo->dpMHiVpt.ycoord = -768;
        pGdiInfo->dpELoVpt.xcoord = 4064;
        pGdiInfo->dpELoVpt.ycoord = -4064;
        pGdiInfo->dpEHiVpt.xcoord = 2032;
        pGdiInfo->dpEHiVpt.ycoord = -2032;
        pGdiInfo->dpTwpVpt.xcoord = 508;
        pGdiInfo->dpTwpVpt.ycoord = -508;
    }
    else
    {
        //
        // 1280 x 1024 
        //

        pGdiInfo->dpHorzRes       = 1280;
        pGdiInfo->dpVertRes       = 1024;
        pGdiInfo->dpMLoVpt.xcoord = 1280;
        pGdiInfo->dpMLoVpt.ycoord = -1024;
        pGdiInfo->dpMHiVpt.xcoord = 1280;
        pGdiInfo->dpMHiVpt.ycoord = -1024;
        pGdiInfo->dpELoVpt.xcoord = 5080;
        pGdiInfo->dpELoVpt.ycoord = -5419;
        pGdiInfo->dpEHiVpt.xcoord = 2540;
        pGdiInfo->dpEHiVpt.ycoord = -2709;
        pGdiInfo->dpTwpVpt.xcoord = 635;
        pGdiInfo->dpTwpVpt.ycoord = -677;
    }
}

VOID PASCAL devDevInfo
(
    LPDEVICE lpDev
)
{
    DBGMSG("devDevInfo\n\r");

    lpDev->devType = 0x6900;
    if (GLOB_X_Size == 1024)
    {
        lpDev->devWidth      = 1024;
        lpDev->devHeight     = 768;
    }
    else
    {
        lpDev->devWidth      = 1280;
        lpDev->devHeight     = 1024;
    }
    lpDev->devWidthBytes = 0x69;
    lpDev->devBitsPixel  = 24;
    lpDev->devPlanes     = 1;
}

#ifdef DEBUGINIT



void 
BoxDraw(unsigned int x1
       ,unsigned int y1
       ,unsigned int x2
       ,unsigned int y2)  
{
   GRPsetup;

   GEWAIT;
   FIFO_WR(GE_SOLIDBRUSH, 0);
   FIFO_WR(GE_DATA, (unsigned long) x1);
   FIFO_WR(GE_DATA, (unsigned long) (768 - y1));
   FIFO_WR(GE_DATA, (unsigned long) x2);
   /* don't translate y2, cause its a length for special box call for windows */
   FIFO_WR(GE_DATA, (unsigned long) y2);
}

VOID FAR test_pdsolidfar(SHORT, SHORT, SHORT, SHORT, DWORD, USHORT);

VOID test_routine()
{
    WORD i;
   GRPsetup;


   for (i=0; i<10; i++) {

//        test_pdsolidfar( 40+i*40,100,  80+i*40,700,(DWORD)i,0xc);
        GEWAIT;
        FIFO_WR(GE_COLOR, 0);
        FIFO_WR(GE_DATA, i);
        BoxDraw(40+i*40,100,  80+i*40,700);
   }


   for (i=246; i<256; i++) {
//        test_pdsolidfar( 40+(10+(i-246))*40,100,  80+(10+(i-246))*40,700,(DWORD)i,0xc);
        GEWAIT;
        FIFO_WR(GE_COLOR, 0);
        FIFO_WR(GE_DATA, i);
        BoxDraw( 40+(10+(i-246))*40,100,  80+(10+(i-246))*40,700);

   }

}

#endif

