#ifndef  __SYS_INVENT_H__
#define  __SYS_INVENT_H__

/**************************************************************************
 *									  *
 * 		 Copyright (C) 1988, Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *									  *
 **************************************************************************/

/* #ident "$Revision: 1.2 $" */

/*
 * sys/invent.h --  Kernel Hardware Inventory
 *
 * Kernel Hardware Inventory
 *
 * As the system boots, a list of recognized devices is assembled.
 * This list can then be accessed through syssgi() by user-level programs
 * so that they can learn about available peripherals and the system's
 * hardware configuration.
 *
 * The data is organized into a linked list of structures that are composed
 * of an inventory item class and a class-specific type.  Each instance may
 * also specify a 32-bit "state" which might be size, readiness, or
 * anything else that's relevant.
 *
 * In the next major release, the inv_-prefixed, C++ member names of the
 * inventory entry structure will be used by the C language version, and
 * inv_controller and inv_unit will change from char to short type.
 *
 *
 * $Revision: 1.2 $
 *
 * Copyright 1988-1990, Silicon Graphics, Inc. 
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
 * the contents of this file may not be disclosed to third parties, copied or 
 * duplicated in any form, in whole or in part, without the prior written 
 * permission of Silicon Graphics, Inc.
 *
 * RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions 
 * as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
 * and Computer Software clause at DFARS 252.227-7013, and/or in similar or 
 * successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished - 
 * rights reserved under the Copyright Laws of the United States.
 */


typedef struct inventory_s {
#ifdef _LANGUAGE_C_PLUS_PLUS
	struct	inventory_s *inv_next;	/* next inventory record in list */
	int	inv_class;		/* class of object */
	int	inv_type;		/* class sub-type of object */
	char	inv_controller;		/* object major identifier */
	char	inv_unit;		/* object minor identifier */
	long	inv_state;		/* information specific to object or
					   class */
#else
	struct inventory_s *next;	/* next inventory record in list */
	int class;			/* class of object */
	int type;			/* class sub-type of object */
	char controller;		/* object major identifier */
	char unit;			/* object minor identifier */
	long state;			/* information specific to object or
					   class */
#endif
} inventory_t;

/* Inventory Classes */
#define INV_PROCESSOR	1
#define INV_DISK	2
#define INV_MEMORY	3
#define INV_SERIAL	4
#define INV_PARALLEL	5
#define INV_TAPE	6
#define INV_GRAPHICS	7
#define INV_NETWORK	8
#define INV_SCSI	9	/* SCSI devices other than disk and tape */

/* types for class processor */
#define INV_CPUBOARD	1
#define INV_CPUCHIP	2
#define INV_FPUCHIP	3

/* states for cpu and fpu chips are revision numbers */

/* cpuboard states */
#define INV_R2300BOARD	1
#define INV_IP4BOARD	2
#define INV_IP5BOARD	3
#define INV_IP6BOARD	4
#define INV_IP7BOARD	5
#define INV_IP9BOARD	6
#define INV_IP12BOARD	7

/* types for class disk */
/* NB: types MUST be unique within a class.
   Please check this if adding new types. */

#define INV_SCSICONTROL	1
#define INV_SCSIDRIVE	2
#define INV_DKIPCONTROL	3	/* generic: only if not recognised as specific
				   type. Defines for recognised types follow. */
#define INV_DKIPDRIVE	4
#define INV_SCSIFLOPPY	5	/* really any removable scsi disk; includes
				   cdroms, optical disks, etc. */

/* class disk types for specific types of Interphase controllers. */

#define INV_DKIP3200	6
#define INV_DKIP3201	7
#define INV_DKIP4200	8
#define INV_DKIP4201	9
#define INV_DKIP4400	10
#define INV_DKIP4460	14

/* class disk types for specific types of Xylogics controllers. */

#define INV_XYL714	11
#define INV_XYL754	12
#define INV_XYL7800	15

/* class disk type for drives on Xylogics controllers */

#define INV_XYLDRIVE	13

/* class SCSI controller chip state; indicate which chip */
#define INV_WD93	0	/* WD 33C93  */
#define INV_WD93A	1	/* WD 33C93A */

/* END OF CLASS DISK TYPES */

/* types for class memory */
/* NB. the states for class memory are sizes in bytes */
#define INV_MAIN	1
#define INV_PROM	2
#define INV_DCACHE	3
#define INV_ICACHE	4
#define INV_WBUFFER	5

/* types for class serial */
#define INV_CDSIO	1	/* Central Data serial board */
#define INV_T3270	2	/* T3270 emulation */
#define INV_GSE		3	/* SpectraGraphics Gerbil coax cable */
#define INV_SI		4	/* SNA SDLC controller */
#define INV_XYLSIO 	5	/* Xylogics 16 Port Serial I/o board */
#define	INV_M333X25 	6	/* X.25 controller */
#define INV_CDSIO_E	7	/* Central Data serial board on E space */

/* types for class parallel */
#define INV_IKC		1	/* Ikon parallel board  */
#define INV_GPIB	2	/* National Instrument GPIB board */
#define INV_GPIB_E	3	/* National Instrument GPIB board on E space*/

/* types for class tape */
#define INV_SCSIQIC	1	/* Any SCSI tape, not just QIC{24,150}... */
#define INV_XM		2	/* Xylogics 772 1/2 " tape controller */
#define INV_ISIQIC	3	/* QIC-02 interface cartridge tapes */

/* sub types for type INV_SCSIQIC (in state) */
#define TPUNKNOWN	0	/* type not known */
#define CIPHER540	1	/* cipher QIC24 */
#define TANDBERG3660	2	/* TANDBERG 3660 QIC150 */
#define VIPER150	3	/* VIPER 150 QIC150 */
#define KENNEDY96X2	4	/* Kennedy 96[16]2 1/2" 9 track */
#define EXABYTE8200	5	/* Exabyte EXB-8200 8mm cartridge tape */
#define VIPER60		6	/* VIPER 60 QIC24 */
#define DATTAPE		7	/* Digital Audio Tape */

/* types for class graphics */
#define INV_GR1BOARD	1	/* GR1 Eclipse graphics */
#define INV_GR1BP	2	/* OBSOLETE - use INV_GR1BIT24 instead */
#define INV_GR1ZBUFFER	3	/* OBSOLETE - use INV_GR1ZBUF24 instead */
#define INV_GRODEV	4	/* Clover1 graphics */
#define INV_GMDEV	5	/* GT graphics */
#define INV_CG2		6	/* CG2 composite video/genlock board */
#define INV_VMUXBOARD	7	/* VMUX video mux board */
#define	INV_VGX		8	/* VGX (PowerVision) graphics */

/* states for class graphics */

/* states for type INV_GR1BOARD; these are bit flags, they can be 
 * combined (ex. RE2 & turbo) */
#define INV_GR1REMASK	0x7	/* Allow 8 different RE versions */
#define INV_GR1REUNK	0x0	/* RE version unknown */
#define INV_GR1RE1	0x1	/* Eclipse graphics w/ RE1 */
#define INV_GR1RE2	0x2	/* Eclipse graphics w/ RE2 */
#define INV_GR1RE2_2	0x3	/* Eclipse graphics w/ RE2.2 */
#define INV_GR1BUSMASK	0x38	/* Allow 8 different bus versions of GR1
				 * architecture */
#define INV_GR1PB	0x00	/* GR1 board - has Eclipse private bus
				 * interface */
#define INV_GR1PBVME	0x08	/* VGR2 board - has VME and private bus
				 * interfaces */
#define INV_GR1TURBO	0x40	/* Turbo option installed */
#define INV_GR1BIT24  	0x80    /* Bitplane expansion option installed */
#define INV_GR1ZBUF24 	0x100   /* Z-buffer option installed */
#define INV_GR1SMALLMON 0x200   /* Using medium-res monitor */
#define INV_GR1SMALLMAP 0x400   /* Only a 256 entry color map */
#define INV_GR1NOGAMMA	0x400	/* DAC's don't have a gamma ramp; always true 
				 * when there's a 256 entry color map, so we
				 * reuse the bit */
#define INV_GR1AUX4 	0x800   /* Auxilary/wid  planes option installed */
#define INV_GR1CURS2	0x1000	/* 2nd cursor chip installed 
				 * XXX new for Cypress; take out when
				 * converting to graphics info */


/* types for class network */
#define INV_NET_ETHER	0	/* 10Mb Ethernet */
#define INV_NET_HYPER	1	/* HyperNet */
#define	INV_NET_CRAYIOS	2	/* Cray Input/Ouput Subsystem */
#define	INV_NET_FDDI	3	/* FDDI */

/* controllers for network types, unique within class network */
#define INV_ETHER_EC	0	/* IP6 integral controller */
#define INV_ETHER_ENP	1	/* CMC board */
#define INV_ETHER_ET	2	/* IP5 integral controller */
#define INV_HYPER_HY	3	/* HyperNet controller */
#define	INV_CRAYIOS_CFEI3 4	/* Cray Front End Interface, v3 */
#define	INV_FDDI_IMF	5	/* Interphase/Martin 3211 FDDI */
#define INV_ETHER_EGL	6	/* Interphase V/4207 Eagle */
#define INV_ETHER_FXP	7	/* CMC C/130 FXP */
#define INV_FDDI_IPG	8	/* Interphase/SGI 4211 Peregrine FDDI */

/* types for class INV_SCSI; should be the same as the device
 * type code returned by the inquiry command.  Note: the
 * lun is encoded in bits 8-15 of the state.  The
 * state field low 3 bits contains the information from the inquiry
 * cmd that  indicates ANSI SCSI 1,2, etc. compliance, and bit 7
 * contains the inquiry info that indicates whether the media is
 * removable. */
#define INV_PRINTER	2	/* SCSI printer */
#define INV_CPU		3	/* SCSI CPU device */
#define INV_WORM	4	/* write-once-read-many (e.g. optical disks) */
#define INV_CDROM	5	/* CD-ROM  */
#define INV_SCANNER	6	/* scanners */
#define INV_OPTICAL	7	/* optical disks (read-write) */
#define INV_CHANGER	8	/* jukebox's for CDROMS, for example */
#define INV_COMM	9	/* Communications device */

/* bit definitions for state field for class INV_SCSI */
#define INV_REMOVE	0x80	/* has removable media */
#define INV_SCSI_MASK	7	/* to which ANSI SCSI standard device conforms*/


#ifdef _KERNEL

extern void	    add_to_inventory(int, int, char, char, long);
extern void	    *get_next_inventory(void *);
extern inventory_t  *find_inventory(inventory_t *, int, int, char, char, long);
extern int	    scaninvent(int (*)(), void *);

#endif /* _KERNEL */
#endif /* !__SYS_INVENT_H__ */
