;
; IV1 ROP DEFINES
;
LO_SOURCECOPY      equ  3
LO_XOR             equ  6
LO_XNOR            equ  9

;
; IV1 OFFSETS
;
CURS0_OFF          equ  0560h               ; Cursor Chip 0 
CURS1_OFF          equ  0580h               ; Cursor Chip 1
FIFO_OFF           equ  800h
FIFO16_OFF         equ  1800h
FINISHFLAG0        equ  2000h
FINISHFLAG1        equ  2004h
HQMMSB_OFF         equ  0e00h


CURS_AREG0         equ  (0 SHL 2)           ;Cursor op: RW addr reg 0 
CURS_AREG1         equ  (01h SHL 2)         ; Cursor op: RW addr reg 1 
CURS_BLOCK         equ  040h                ; block cursor 
CURS_CMD           equ  0
CURS_CR            equ  (03h SHL 2)         ; Cursor op: RW control reg 
CURS_GLYPH         equ  (02h SHL 2)         ; Cursor op: RW glyph RAM 
CURS_5TO1MUX       equ  08h                 ; use 5:1 multiplexing 
CURS_XLO           equ  1




HQ_ON              equ  (HQMMSB_OFF OR (1 SHL 2))
HQ_OFF             equ  (HQMMSB_OFF OR (0 SHL 2))
IV1BUSY            equ  4020h
RW_FBUFFER_28      equ  6

;
; GE commands
;
GE_AUXWRITEMASK    equ  (FIFO16_OFF OR (10 SHL 2))
GE_COLOR           equ  (FIFO16_OFF OR (12 SHL 2))
GE_COLORBRUSH      equ  (FIFO16_OFF OR (211 SHL 2))
GE_COLORBRUSHLOAD  equ  (FIFO16_OFF OR (213 SHL 2))
GE_FLINE           equ  (FIFO16_OFF OR (179 SHL 2))
GE_FINISH0         equ  (FIFO16_OFF OR (21 SHL 2))
GE_SCRMASK         equ  (FIFO16_OFF OR (180 SHL 2))
GE_MONOPATTERN     equ  (FIFO16_OFF OR (212 SHL 2))
GE_RASTEROP        equ  (FIFO16_OFF OR (184 SHL 2))
GE_READBLOCK_R     equ  (FIFO16_OFF OR (209 SHL 2))
GE_READSOURCE      equ  (FIFO16_OFF OR (49 SHL 2))
GE_RECTCOPY        equ  (FIFO16_OFF OR (35 SHL 2))
GE_RGBCOLOR        equ  (FIFO16_OFF OR (36 SHL 2))
GE_ROPPATTERN      equ  (FIFO16_OFF OR (215 SHL 2))
GE_RWMODE          equ  (FIFO16_OFF OR (38 SHL 2))
GE_SCRMASK         equ  (FIFO16_OFF OR (180 SHL 2))
GE_SOLIDBRUSH      equ  (FIFO16_OFF OR (207 SHL 2))
GE_WIN_BITBLT      equ  (FIFO16_OFF OR (208 SHL 2))



;
; IV1 CFG PORT BITS AND VALUES
;

IV1BLTDONE              equ  -1
IV1CONFIG_PORT          equ  4
IV1CFGSTRING_IO_PORT    equ  8
IV1CFGSTRN_BURST        equ  4
;IV1HWBUGLOOP            equ  30
IV1HWBUGLOOP            equ  5
FIFOLIMIT               equ  15

INV_GR1ZBUF24           equ  0100h
;
; DEVPSTATUS bits
;

PALETTETRANS    EQU     000000000000000000000000000000001b
MULTIRES_96DPI  EQU     000000000000000000000000000000010b


;----------------------------------------------------------------------------;
; MACRO HQMMSB_SET                                                           ;
;                                                                            ;
; Entry: gs:[bx] = pointer to IV1                                            ;
;                                                                            ;
; Exit: trashes ax, and dx                                                   ;
;                                                                            ;
;----------------------------------------------------------------------------;

HQMMSB_SET     MACRO value
        
        mov     DWORD PTR gs:[bx][HQ_ON], 0
;        mov     dx, 084h                    ; Do delay for IV1
;        in      ax, dx

                ENDM

;----------------------------------------------------------------------------;
; MACRO HQMMSB_CLR                                                           ;
;                                                                            ;
; Entry: gs:[bx] = pointer to IV1                                            ;
;                                                                            ;
; Exit: trashes ax, and dx                                                   ;
;                                                                            ;
;----------------------------------------------------------------------------;

HQMMSB_CLR     MACRO value
        
        mov     DWORD PTR gs:[bx][HQ_OFF], 0
;        mov     dx, 084h                    ; Do delay for IV1
;        in      ax, dx

                ENDM

