#define AGR 1
#define WIN_DRIVER 1
/**************************************************************************
 *                                                                 *
 *                Copyright (C) 1992, Pellucid, Inc.                       *
 *                                                                 *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Pellucid, Inc., and         *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Pellucid, Inc.         *
 *                                                                 *
 **************************************************************************/
#include <common.h>
#include "invent.h"
#include "gfxboard.h"
#include "externs.h"
#include "iv1.h"


extern int ivhw_state;
extern int iv_dispinit;
extern short iv_curs_xoff, iv_curs_yoff;

int cursor_x_size;
int cursor_y_size;
int x_hot_spot;
int y_hot_spot;

int curs_flag = 1;

short curs_x, curs_y;


/*
 * iv_setcursor()
 *
 *  This function loads the cursor glyph with a pattern supplied by the
 *  "CURSORSHAPE" structure pointed to by the "argp" parameter.
 */
void far
iv_setcursor(CURSORSHAPE far *argp)
{
    GRPsetup;
    register unsigned char far *glyphp;
    register unsigned char glyphdata;
    register int i, j;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */


    if (curs_flag == 0)
       return;

    curs_flag = 0;

    intr_flgs = EnterCrit();  /* this should disable interrupts */

    HQMMSB_WR(1);
#if 0
    hqmmsb_set();  /* HQMMSB_WR(1); */
#endif
    /*
     *  Load cursor glyph #0 with the one's compliment of the "AND"
     *  mask part of the Windows cursor.  This is a hack to deal with
     *  the fact that we don't want to read the bitplanes to set the
     *  IRISVISION cursor.  Instead of using zeros to force the background
     *  to black we use ones to select the cursor color black.
     */
    CURS_A0WR(CURS0_OFF, 0);
    CURS_A1WR(CURS0_OFF, 0);
    glyphp = (unsigned char far *)argp;
    glyphp += sizeof(CURSORSHAPE);
//    glyphp = &(argp->csBits[0]);
    for (i = argp->csHeight; i; i--) {
       for (j = 0; j < 8; j++) {
           if (j < argp->csWidthBytes) {
              glyphdata = *glyphp++;
              glyphdata = (unsigned char)~glyphdata;
           } else {
              glyphdata = 0x00;
           }
           CURS_GLYPHWR(CURS0_OFF, glyphdata);
       }
    }


    /* Load cursor glyph #1 */
    CURS_A0WR(CURS1_OFF, 0);
    CURS_A1WR(CURS1_OFF, 0);
    /*
     *  The second glyph is right after the first so just keep on
     *  incrementing.  This is the XOR glyph so let's use it the
     *  way we get it.
     */
    for (i = argp->csHeight; i; i--) {
       for (j = 0; j < 8; j++) {
           if (j < argp->csWidthBytes) {
              glyphdata = *glyphp++;
           } else {
              glyphdata = 0x00;
           }
           CURS_GLYPHWR(CURS1_OFF, glyphdata);
       }
    }




    HQMMSB_WR(0);
#if 0
    hqmmsb_clr();  /* HQMMSB_WR(0); */
#endif

    x_hot_spot = argp->csHotX;
    y_hot_spot = argp->csHotY;
    cursor_x_size = argp->csWidth;
    cursor_y_size = argp->csHeight;

    curs_flag = 1;
    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}



/*
 * iv_mapcurscolor()
 */
void far
iv_mapcurscolor(unsigned long index, unsigned long red,
       unsigned long green, unsigned long blue)
{
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
    GRPsetup;


    if (curs_flag == 0)
       return;

    curs_flag = 0;

    intr_flgs = EnterCrit();  /* this should disable interrupts */
    HQMMSB_WR(1);
#if 0
    hqmmsb_set();  /* HQMMSB_WR(1); */
#endif

    if (ivhw_state & INV_GR1BIT24) {
       DAC_AWR(DACR_OFF, index);
       DAC_AWR(DACG_OFF, index);
       DAC_AWR(DACB_OFF, index);
       DAC_OVRLAYWR(DACR_OFF, red);
       DAC_OVRLAYWR(DACG_OFF, green);
       DAC_OVRLAYWR(DACB_OFF, blue);
    } else {
       DAC_AWR(DACRGB_OFF, index);
       DAC_OVRLAYWR(DACRGB_OFF, red);
       DAC_OVRLAYWR(DACRGB_OFF, green);
       DAC_OVRLAYWR(DACRGB_OFF, blue);
    }
    HQMMSB_WR(0);
#if 0
    hqmmsb_clr();  /* HQMMSB_WR(0); */
#endif
    curs_flag = 1;
    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}



/*
 * iv_readcurscolors()
 */
void far
iv_readcurscolors(CURSSTATE *CursorState) 
{
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
    unsigned int cursindex;
    GRPsetup;


    intr_flgs = EnterCrit();  /* this should disable interrupts */
    HQMMSB_WR(1);

    if (ivhw_state & INV_GR1BIT24) {
       for (cursindex=1;cursindex<4;cursindex++) {
            DAC_AWR(DACR_OFF, cursindex);
            DAC_AWR(DACG_OFF, cursindex);
            DAC_AWR(DACB_OFF, cursindex);
            DAC_OVRLAYRD(DACR_OFF, CursorState->CursColors[cursindex-1].Red);
            DAC_OVRLAYRD(DACG_OFF, CursorState->CursColors[cursindex-1].Green);
            DAC_OVRLAYRD(DACB_OFF, CursorState->CursColors[cursindex-1].Blue);
       }
    } else {
       for (cursindex=1;cursindex<4;cursindex++) {
            DAC_AWR(DACRGB_OFF, cursindex);

            DAC_OVRLAYRD(DACRGB_OFF, CursorState->CursColors[cursindex-1].Red);
            DAC_OVRLAYRD(DACRGB_OFF, CursorState->CursColors[cursindex-1].Green);
            DAC_OVRLAYRD(DACRGB_OFF, CursorState->CursColors[cursindex-1].Blue);

       }
    }
    HQMMSB_WR(0);

    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}


void far
iv_readcursglyph(CURSSTATE *CursorState) 
{

    GRPsetup;
    register int i;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */


    intr_flgs = EnterCrit();  /* this should disable interrupts */

    HQMMSB_WR(1);
    /*
     *  Load cursor glyph #0 with the one's compliment of the "AND"
     *  mask part of the Windows cursor.  This is a hack to deal with
     *  the fact that we don't want to read the bitplanes to set the
     *  IRISVISION cursor.  Instead of using zeros to force the background
     *  to black we use ones to select the cursor color black.
     */
    CURS_A0WR(CURS0_OFF, 0);
    CURS_A1WR(CURS0_OFF, 0);
    for (i = CURS_GLYPH_SIZE; i; i--) {
       CURS_GLYPHRD(CURS0_OFF, CursorState->CursGlyph[0][i-1]);
    }




    /* Load cursor glyph #1 */
    CURS_A0WR(CURS1_OFF, 0);
    CURS_A1WR(CURS1_OFF, 0);
    /*
     *  The second glyph is right after the first so just keep on
     *  incrementing.  This is the XOR glyph so let's use it the
     *  way we get it.
     */
    for (i = CURS_GLYPH_SIZE; i; i--) {
       CURS_GLYPHRD(CURS1_OFF, CursorState->CursGlyph[1][i-1]);
    }


    HQMMSB_WR(0);

    LeaveCrit(intr_flgs);  /* this should enable interrupts */

}



void far
iv_setcursglyph(CURSSTATE *CursorState) 
{

    GRPsetup;
    register int i;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */


    intr_flgs = EnterCrit();  /* this should disable interrupts */

    HQMMSB_WR(1);
    /*
     *  Load cursor glyph #0 with the one's compliment of the "AND"
     *  mask part of the Windows cursor.  This is a hack to deal with
     *  the fact that we don't want to read the bitplanes to set the
     *  IRISVISION cursor.  Instead of using zeros to force the background
     *  to black we use ones to select the cursor color black.
     */
    CURS_A0WR(CURS0_OFF, 0);
    CURS_A1WR(CURS0_OFF, 0);
    for (i = CURS_GLYPH_SIZE; i; i--) {
       CURS_GLYPHWR(CURS0_OFF, CursorState->CursGlyph[0][i-1]);
    }




    /* Load cursor glyph #1 */
    CURS_A0WR(CURS1_OFF, 0);
    CURS_A1WR(CURS1_OFF, 0);
    /*
     *  The second glyph is right after the first so just keep on
     *  incrementing.  This is the XOR glyph so let's use it the
     *  way we get it.
     */
    for (i = CURS_GLYPH_SIZE; i; i--) {
       CURS_GLYPHWR(CURS1_OFF, CursorState->CursGlyph[1][i-1]);
    }


    HQMMSB_WR(0);

    LeaveCrit(intr_flgs);  /* this should enable interrupts */

}




/*
 * iv_setcurscolors()
 */
void far
iv_setcurscolors(CURSSTATE *CursorState) 
{
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
    unsigned int cursindex;
    GRPsetup;


    intr_flgs = EnterCrit();  /* this should disable interrupts */
    HQMMSB_WR(1);

    if (ivhw_state & INV_GR1BIT24) {
       for (cursindex=1;cursindex<4;cursindex++) {
            DAC_AWR(DACR_OFF, cursindex);
            DAC_AWR(DACG_OFF, cursindex);
            DAC_AWR(DACB_OFF, cursindex);
            DAC_OVRLAYWR(DACR_OFF, CursorState->CursColors[cursindex-1].Red);
            DAC_OVRLAYWR(DACG_OFF, CursorState->CursColors[cursindex-1].Green);
            DAC_OVRLAYWR(DACB_OFF, CursorState->CursColors[cursindex-1].Blue);
       }
    } else {
       for (cursindex=1;cursindex<4;cursindex++) {
            DAC_AWR(DACRGB_OFF, cursindex);

            DAC_OVRLAYWR(DACRGB_OFF, CursorState->CursColors[cursindex-1].Red);
            DAC_OVRLAYWR(DACRGB_OFF, CursorState->CursColors[cursindex-1].Green);
            DAC_OVRLAYWR(DACRGB_OFF, CursorState->CursColors[cursindex-1].Blue);

       }
    }
    HQMMSB_WR(0);

    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}



/*
 * iv_poscursor()
 *
 *  Updates the cursor position.
 *
 */
void far
iv_poscursor(register short x, register short y)
{
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
    GRPsetup;


    if (curs_flag == 0)
       return;

    intr_flgs = EnterCrit();  /* this should disable interrupts */
    
    /*
     *  Y direction in Windows and cursor chip are the same
     *  (i.e. increasing from top down).
     */
    curs_x = x + iv_curs_xoff - x_hot_spot;
    curs_y = y + iv_curs_yoff - y_hot_spot;

    HQMMSB_WR(1);
#if 0
    hqmmsb_set();  /* HQMMSB_WR(1); */
#endif

    /* set up cursor 0 */
    CURS_A0WR(CURS0_OFF, CURS_XLO); /* Write address reg */
    CURS_A1WR(CURS0_OFF, CURS_XLO);
    /* Cursor chip address reg. auto increments */
    CURS_CRWR(CURS0_OFF, curs_x & 0xFF);       /* x low */
    CURS_CRWR(CURS0_OFF, (curs_x >> 8) & 0xF);       /* x high */
    CURS_CRWR(CURS0_OFF, curs_y & 0xFF);       /* y low */
    CURS_CRWR(CURS0_OFF, (curs_y >> 8) & 0xF);       /* y high */

    /* now do cursor 1 */
    CURS_A0WR(CURS1_OFF, CURS_XLO); /* Write address reg */
    CURS_A1WR(CURS1_OFF, CURS_XLO);
    /* Cursor chip address reg. auto increments */
    CURS_CRWR(CURS1_OFF, curs_x & 0xFF);       /* x low */
    CURS_CRWR(CURS1_OFF, (curs_x >> 8) & 0xF);       /* x high */
    CURS_CRWR(CURS1_OFF, curs_y & 0xFF);       /* y low */
    CURS_CRWR(CURS1_OFF, (curs_y >> 8) & 0xF);       /* y high */

    HQMMSB_WR(0);
#if 0
    hqmmsb_clr();  /* HQMMSB_WR(0); */
#endif

    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}


/*
 * iv_cursdisplay()
 *
 *  This function enables or disables the cursor based on the "curson"
 *  flag that is passed to it.
 */
void far
iv_cursdisplay(short curson)
{
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
    GRPsetup;

    intr_flgs = EnterCrit();  /* this should disable interrupts */
    HQMMSB_WR(1);
#if 0
    hqmmsb_set();  /* HQMMSB_WR(1); */
#endif

    CURS_A0WR(CURS0_OFF, CURS_CMD);
    CURS_A1WR(CURS0_OFF, CURS_CMD);
    if (curson) {
       CURS_CRWR(CURS0_OFF, CURS_BLOCK | CURS_5TO1MUX);
    } else {
       CURS_CRWR(CURS0_OFF, CURS_5TO1MUX);
    }

    CURS_A0WR(CURS1_OFF, CURS_CMD);
    CURS_A1WR(CURS1_OFF, CURS_CMD);
    if (curson) {
       CURS_CRWR(CURS1_OFF, CURS_BLOCK | CURS_5TO1MUX);
    } else {
       CURS_CRWR(CURS1_OFF, CURS_5TO1MUX);
    }

    HQMMSB_WR(0);
#if 0
    hqmmsb_clr();  /* HQMMSB_WR(0); */
#endif
    LeaveCrit(intr_flgs);  /* this should enable interrupts */
}
