/**************************************************************************
 *                                               *
 *            Copyright (C) 1992, pellucid, inc.                       *
 *                                               *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of pellucid, inc., and          *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of pellucid, inc.          *
 *                                               *
 **************************************************************************/
#define WIN_DRIVER 1
#define AGR 1
#include "common.h"

#include "iv_dreg.h"
#include "invent.h"
//#include "conio.h"

#include "gecmds.h"
#include "re.h"
#include "gfxboard.h"

#ifdef AGR
#include "atsubr.h"
#endif
#ifdef NGR
#include "necsubr.h"
#endif

#include "externs.h"

/* This variable is for old version IV board */
static int vgapassthru = IV_HVSYNC;

extern int ivhw_state;

/*
 * iv_setmonitor()
 */
void 
iv_setmonitor(iv_setmonitor_t *argp)
{
    GRPsetup;
    int monitor_type, tmp2;
    unsigned char dregdata, dregdata2;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
           
    switch (argp->monitortype) {
	case DREG_MONITOR60HZ:
	case DREG_MONITOR30HZ:
#ifndef NGR     /* Not Available */
	case DREG_MONITORSTEREO:
#endif
	    if (ivhw_state & INV_GR1SMALLMON) {
		 tmp2 = TOPSCAN_MIDRES_2;
	    } else {
	         tmp2 = TOPSCAN_HIRES_2;
	    }
	    break;
	case DREG_MONITORNTSC:
	    tmp2 = TOPSCAN_NTSC_2;
	    break;
	case DREG_MONITORPAL:
	    tmp2 = TOPSCAN_PAL_2;
	    break;
	case DREG_MONITORMEDRES:
	    tmp2 = TOPSCAN_MIDRES_2;
	    break;
#ifdef NGR
	case DREG_MONITORMEDRES_X:          /* 1024X768 interlaced */
	    tmp2 = TOPSCAN_MIDRES_2;
	    break;
	case DREG_MONITORMEDRES_NEC:      /* 1120X750 non-interlaced */
	case DREG_MONITORMEDRES_NEC_X:     /* 1120X750 interlaced */
	    tmp2 = TOPSCAN_MIDRES_NEC_2;
	    break;
#endif
	default:
	    tmp2 = TOPSCAN_HIRES_2;
	    break;
    }

#ifndef NGR
    if (argp->monitortype != DREG_MONITORMEDRES) {
     monitor_type = argp->monitortype;
    }
    else if ((argp->flag & IV_SYNCGRN) || (argp->flag & IV_COMPSYNC)) {
     monitor_type = argp->monitortype;
    }
    else {
     monitor_type = DREG_MONITORMEDRES_HVSYNC;
    }
#else
    monitor_type = argp->monitortype;
#endif

    /*
     * The RE TOPSCAN reg value changes when monitor type changes.
     * Send it down pipe on behalf of GL proc.
     * Also checks that monitor type is valid.
     */
    GEWAIT;
    FIFO_WR(GE_LOADRE, 0);
    FIFO_WR(GE_DATA, RE_TOPSCAN);

    FIFO_WR(GE_DATA, tmp2);

vert_miss:
    VRINTWAIT; 
    intr_flgs = EnterCrit();
    HQMMSB_WR(1);
    if ( (GFXINTR & GFX_INT_VR) && !(GFXCTRL0 & GFX_VRSTAT)) {
     VRWAIT;

     DREG_RD_XPC(DREG1_OFF, dregdata);
     DREG_RD_XPC(DREG4_OFF, dregdata2);

     DREG_WR(DREG4_OFF, dregdata2 & ~(DREG_SCLKEN));
     DREG_WR(DREG4_OFF, dregdata2 & ~(DREG_SCLKEN|DREG_ACLKEN));

     /* set the bit for 4 or 5 (0) or 3 (1) BNCS */
     if (argp->flag & IV_SYNCGRN) {
         dregdata &= 0xfb;
         vgapassthru = IV_SYNCGRN;
     } else {
         dregdata |= 0x04;
         if (argp->flag & IV_HVSYNC)
          vgapassthru = IV_HVSYNC;
         else
          vgapassthru = IV_COMPSYNC;
     }

     DREG_WR(DREG1_OFF, (dregdata & 0xfd) |
         (unsigned char)((monitor_type & 0x0004) >> 1));

     DREG_WR(DREG4_OFF, (unsigned char)(monitor_type & 0x03) | 0x08);
     DREG_WR(DREG4_OFF, (unsigned char)(monitor_type & 0x03) |
         0x08 | DREG_ACLKEN);
     DREG_WR(DREG4_OFF, (unsigned char)(monitor_type & 0x03) |
         0x08 | DREG_ACLKEN | DREG_SCLKEN);

     DREG_WR(DREG3_OFF, 0);
     /*
      *  must take MONSET bit low and then high to reload monitor
      *  timing table into Xilinx chip
      */
     DREG_WR(DREG3_OFF, DREG_MONITORRESET);
    } else {
     LeaveCrit(intr_flgs);
     goto vert_miss;
    }
/* turn on interrupts */
    HQMMSB_WR(0);     /* Kernel must always set mid addr reg MSB back to 0 */
    LeaveCrit(intr_flgs);
}

/*
 * iv_getmonitor()
 */
void 
iv_getmonitor(iv_setmonitor_t *argp)
{
    GRPsetup;
    unsigned char dregdata, dregdata2, dregdata3;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */

    intr_flgs = EnterCrit();
    HQMMSB_WR(1);
    DREG_RD_XPC(DREG1_OFF, dregdata);
    DREG_RD_XPC(DREG4_OFF, dregdata2);
    HQMMSB_WR(0);
    LeaveCrit(intr_flgs);

    dregdata2 &= 0x3;
    dregdata3 = (unsigned char)((dregdata << 1) | (dregdata2 & 0x02));

    switch (dregdata3) {
     case DREG_MONITOR60HZ:
          argp->monitortype = DREG_MONITOR60HZ;
             break;
     case DREG_MONITORNTSC:
          argp->monitortype = DREG_MONITORNTSC;
          break;
     case DREG_MONITORPAL:
          argp->monitortype = DREG_MONITORPAL;
          break;
     case DREG_MONITORMEDRES:
          argp->monitortype = DREG_MONITORMEDRES;
           break;
#ifndef NGR
     case DREG_MONITORSTEREO:
          argp->monitortype = DREG_MONITORSTEREO;
          break;
     case DREG_MONITORMEDRES_HVSYNC:
          argp->monitortype = DREG_MONITORMEDRES;
           break;
#else
     case DREG_MONITORMEDRES_X:
          argp->monitortype = DREG_MONITORMEDRES_X;
           break;
     case DREG_MONITORMEDRES_NEC:
          argp->monitortype = DREG_MONITORMEDRES_NEC;
           break;
     case DREG_MONITORMEDRES_NEC_X:
          argp->monitortype = DREG_MONITORMEDRES_NEC_X;
           break;
#endif
     default:
          argp->monitortype = DREG_MONITOR60HZ;
           break;
    }
#ifndef NGR
    if (dregdata3 == DREG_MONITORMEDRES_HVSYNC)
     argp->flag = IV_HVSYNC;
    else if (dregdata & 0x04)
          if (argp->monitortype == DREG_MONITOR60HZ)
              argp->flag = IV_HVSYNC;
          else
              argp->flag = IV_COMPSYNC;
    else
     argp->flag = IV_SYNCGRN;
#else
    if ((argp->monitortype == DREG_MONITORNTSC) ||
      (argp->monitortype == DREG_MONITORPAL))
     if (dregdata & 0x04)
         argp->flag = IV_COMPSYNC;
     else
         argp->flag = IV_SYNCGRN;
    else
         argp->flag = IV_HVSYNC;
#endif
}


/*
 * iv_getscrnmode()
 */
void 
iv_getscrnmode(long *argp)
{
    GRPsetup;
    unsigned char dregdata;
#ifdef MGR
    unsigned short intr_flgs;  /* for saving flags during critcal sections */
#endif

#ifdef AGR
    dregdata = (unsigned char)inp(ioport[agr_ioport] + MAGIC_ADDRLO);
    dregdata &= 0x01;     /* bit 0 is screen mode */
#endif
#ifdef NGR
    dregdata = inp(ioport[ngr_ioport] + HIRES_SWITCH_PORT);
#endif
#ifdef MGR
    intr_flgs = EnterCrit();
    HQMMSB_WR(1);
    DREG_RD_XPC(DREG4_OFF, dregdata);
    dregdata &= 0x08;     /* dreg4 bit 3, will change to CONSTANT */
    HQMMSB_WR(0);     /* Kernel must always set mid addr reg MSB back to 0 */
    LeaveCrit(intr_flgs);
#endif

    if (dregdata)
     *argp = SCMD_IVMODE;
    else
     *argp = SCMD_VGAMODE;
}
   
/*
 * iv_setscrnmode()
 */
void 
iv_setscrnmode(long mode)
{
    GRPsetup;
    unsigned char dregdata;
    unsigned short intr_flgs;  /* for saving flags during critcal sections */

    /* for backward compatible, old version board alway to set 4BNCs */
    if (mode == SCMD_VGAMODE) {
     intr_flgs = EnterCrit();
     HQMMSB_WR(1);
     DREG_RD_XPC(DREG1_OFF, dregdata);
     /* set the bit for 4 (0) or 5 (1) BNCS VGA pass through */
     if (vgapassthru == IV_HVSYNC)
         dregdata |= 0x4;
     else
         dregdata &= 0xfb;
     DREG_WR(DREG1_OFF, dregdata & ~(DREG_SCLKEN));
     HQMMSB_WR(0);     /* Kernel must always set mid addr reg MSB back to 0 */
     LeaveCrit(intr_flgs);
    }

#ifdef AGR
    outp(ioport[agr_ioport] + HIRES_SWITCH_PORT, mode ? 0x1 : 0x0);
#endif
#ifdef NGR
    outp(ioport[ngr_ioport] + HIRES_SWITCH_PORT, mode ? 0x1 : 0x0);
#endif
#ifdef MGR
    unsigned char dregdata2;

    intr_flgs = EnterCrit();
    HQMMSB_WR(1);
    DREG_RD_XPC(DREG4_OFF, dregdata);
    HQMMSB_WR(0);     /* Kernel must always set mid addr reg MSB back to 0 */
    LeaveCrit(intr_flgs);

    if (mode == SCMD_IVMODE)
     dregdata2 = dregdata | 0x08;  /* dreg4 bit 3, will change to CONSTANT */
    else
     dregdata2 = dregdata & 0xf7;

vert_miss:
    VRINTWAIT; 
    intr_flgs = EnterCrit();
    if ( (GFXINTR & GFX_INT_VR) && !(GFXCTRL0 & GFX_VRSTAT)) {
         HQMMSB_WR(1);
         VRWAIT;

         DREG_WR(DREG4_OFF, dregdata & ~(DREG_SCLKEN));
         DREG_WR(DREG4_OFF, dregdata & ~(DREG_SCLKEN|DREG_ACLKEN));


         DREG_WR(DREG4_OFF, dregdata2 & ~(DREG_SCLKEN|DREG_ACLKEN));
         DREG_WR(DREG4_OFF, dregdata2 & ~(DREG_SCLKEN) | DREG_ACLKEN);
         DREG_WR(DREG4_OFF, dregdata2 | DREG_SCLKEN | DREG_ACLKEN);

    } else {
         LeaveCrit(intr_flgs);
         goto vert_miss;
    }
/* turn on interrupts */
    HQMMSB_WR(0);     /* Kernel must always set mid addr reg MSB back to 0 */
    LeaveCrit(intr_flgs);
#endif
}
