#ifndef	__GL_MSDOSDLL_H__
#define	__GL_MSDOSDLL_H__
/* 
 * msdosdll.h
 *
 * $Revision: 1.2 $
 */

#define DLL_FILENAME	"GL.DYN"

#define	DLL_FORMAT	1	/* by definition, changing the DLL format
				 * number makes the library incompatible with 
				 * earlier and later versions */

#define	DLL_MAGIC	0x5347444c     /* 'SGDL' */

#define DLL_ANY		255	/* wildcard value that always matches a 
				 * release number; this is for use by 
				 * developers that build without envvar 
				 * RELEASE being set */

#define	IFTBL_MAGIC	0x444c4954     /* 'DLIT' */
#define	IFTBL_FORMAT	18	/* by definition, changing the interface
				 * table format number makes the code 
				 * resource incompatible with earlier 
				 * and later versions */

#define VERS_RELE_FMT	"Version %u.%u/Release %u.%02u"
				/* offical way to printf version and release
				 * numbers */

/*
 * NB. RC doesn't know how to handle arthimetic expressions
 */

/* 
 * Resource types and names can only be changed when the DLL format number 
 * is changed.  The header must always be resource #1 of type #256; it can 
 * NEVER change!! 
 */

/* Resource types (i.e. formats) */
/* types 1->255 are reserved by MS Windows */
#define RT_HEADER	256
#define RT_REX_DI	257		/* device independent code in PharLap 
					 * .REX format */
#define RT_REX_DD	258		/* device dependent code in PharLap 
					 * .REX format */
#define RT_REX_RM	259		/* device independent real mode code in
					 * PharLap .REX format */
#define	RT_UCODE	260		/* microcode (format in gr1_ucod.h) */
#define RT_FONT_SGI	261		/* font in SGI format */
#define RT_FONT_SNF2	262		/* font in SNF (padding=2) format */
#if 0
#define RT_FONT_MSW	263		/* font in MS Windows format */
#endif

/* 
 * Within each type, resource names must be unique.  They must start from 1.
 * WARNING: RC 3.00 doesn't warn of duplicate resource names !!
 */

/* Resources of type RT_HEADER */
#define RN_HEADER	1		
					 

/* Resources of type RT_REX_DI */
#define RN_BOOT		0		/* if 0, then boot code resource
					 * doesn't exist */
#if 0
#define RN_DEVICE	2		/* device (event) library */
#define RN_NURBS	3		/* NURBS library (board-indepedent) */
#define RN_UTIL		4		/* utility library (board-indepedent) */
#endif

/* Resources of type RT_REX_DD */
#define RN_IV_ALL_AT	1		/* complete GL code for IRISVISION/AT */
#define RN_IV_ALL_MC	2		/* complete GL code for IRISVISION/MC */
#define RN_IV_ADI_AT	3		/* GL for "sgiadi" for IRISVISION/AT */
#define RN_IV_ADI_MC	4		/* GL for "sgiadi" for IRISVISION/MC */
#define RN_IV_BASE_AT	5		/* base GL code for IRISVISION/AT */
#define RN_IV_BASE_MC	6		/* base GL code for IRISVISION/MC */
#define RN_IV_4DC_AT	7		/* 4d compat lib for IRISVISION/AT */
#define RN_IV_4DC_MC	8		/* 4d compat lib for IRISVISION/MC */
#define RN_IV_GRO_AT	9		/* gfx output driver for IRISVISION/AT*/
#define RN_IV_GRO_MC	10		/* gfx output driver for IRISVISION/MC*/	

#define RN_IV_ALL_NEC	100		/* complete GL code for IRISVISION/NEC 9800 */

/* Resources of type RT_REX_RM */
#define RN_IV_REALMODE	1		/* IRISVISION real mode code */

/* Resources of type RT_FONT_SGI */
#define RN_DEFFONT	1		/* the default font for the GL */

/* Resources of type RT_UCODE */
#ifdef WIN_DRIVER
#define RN_IV_UCODE	6969		/* microcode for IRISVISION (GE5/RE2) 
#endif
#ifndef WIN_DRIVER
#define RN_IV_UCODE	1		/* microcode for IRISVISION (GE5/RE2) 
					 * (same for AT and MC) */
#endif

#if !(defined(RC_INVOKED) || defined(WIN_DRIVER))
#if  0
typedef Vfptr *ftab_t;
typedef Udptr dtab_t;
#endif

#ifndef	_LANGUAGE_ASSEMBLY
//#include <stdio.h>		/* for FILE */
#endif

#define	MDH_VERSION	1   /* for mdh_hdr_vers */

struct msdos_dll_header {
    unsigned long   mdh_magic;	    /* 'SGDL' */
    unsigned short  mdh_hdr_vers;   /* version number of this header */
    unsigned short  mdh_format;	    /* DLL format number -- changing this
			     	        forces incompatibility */
    unsigned char   mdh_ver_maj;    /* library API version */
    unsigned char   mdh_ver_min;
    unsigned char   mdh_rel_maj;    /* library release # (from build group) */
    unsigned char   mdh_rel_min;
    unsigned char   mdh_rel_seq;    /* for reference only -- no checking
    				        done on this*/
    char   mdh_debug;	    /* if TRUE, then compiled without -DNDEBUG */
    unsigned short  mdh_oem_id;     /* reserved for OEM use
    				     *  -- always 0 from SGI */
    unsigned short  mdh_boot_rt;    /* resource type of boot code */
    unsigned short  mdh_boot_rn;    /* resource num of boot code;
    					is 0 if none */
    unsigned long  mdh_serial_nr;  /* currently unused */
#ifndef	_LANGUAGE_ASSEMBLY
    unsigned char   mdh_unused[512-6*4]; /* resource alignment is 512, so
    					     might as well claim all of it */
#else
    mdh_unused DB (512-6*4) dup(?)
#endif
};

/* 
 * NB. The script in dynonly/makefile that creates msdosdll.ah assumes a
 * certain form of these structures' definition.
 */
struct _GL_dyna_hdr {
	unsigned long	magic;
	unsigned long	format;

	unsigned long	start_gdata;
	unsigned long	end_gdata;

	unsigned long	start_ccalls;
	unsigned long	end_ccalls;

	unsigned long	start_glfuncs;
	unsigned long	end_glfuncs;
};

struct _rm_dyna_hdr {
	unsigned long	rm_magic;
	unsigned long	rm_format;

	unsigned long	rm_start_gdata;
	unsigned long	rm_end_gdata;
};



#if 0
struct section_tabs {
	Vfptr *public_ftab;
	Udptr public_dtab; 
	Vfptr *intra_ftab;
	Udptr intra_dtab;
};
#endif

#ifndef	_LANGUAGE_ASSEMBLY
typedef struct _GL_dyna_hdr GL_dyna_hdr;

extern char *_gl_findlib(void);
extern int _gl_find_file(const char *, char[/* _MAX_PATH */]);
#endif	/* !_LANGUAGE_ASSEMBLY */

#endif	/* !(RC_INVOKED || WIN_DRIVER) */

#ifdef WIN_DRIVER
int access_resource(unsigned short, unsigned short);
#endif /* WIN_DRIVER */

#endif	/* !__GL_MSDOSDLL_H__ */
