#ifndef	__NEWEXE_H__
#define	__NEWEXE_H__

/*
 * newexe.h
 *	- a partial implementation
 */

#define EMAGIC	0x5a4d
#define ENEWEXE 0x40		/* value of e_lfarlc that flags new exe fmt */
#define ENEWHDR	0x003c

#define	NEMAGIC	0x454e



struct exe_hdr {
/* 0x00 */  unsigned short  e_magic;	    /* magic number */
	    char _pad1[0x18-0x02];	   
/* 0x18 */  unsigned short  e_lfarlc;	    /* = 0x40 for new exe format */
	    char _pad2[0x3c-0x1a];	   
/* 0x3c */  unsigned long   e_lfanew;	    /* file address of new exe header */
};

#define NERESBYTES  9

struct new_exe {
/* 0x00 */  unsigned short  ne_magic;	    /* magic number */
/* 0x02 */  unsigned char   ne_versmaj;	    /* linker major version nr */
/* 0x03 */  unsigned char   ne_versmin;	    /* linker minor version nr */
	    char _pad1[0x0c-0x04];
/* 0x0c */  unsigned short  ne_flags;	    /* flags */
	    char _pad2[0x24-0x0e];
/* 0x24 */  unsigned short  ne_rsrctab;	    /* offset of resource table */
	    char _pad3[0x34-0x26];
/* 0x34 */  unsigned short  ne_cres;	    /* cnt of resource table entries 
					     * XXX always zero ?? */
/* 0x36 */  unsigned char   ne_exetyp;	    /* target operating system */
/* 0x37 */  char	    ne_res[NERESBYTES]; /* pad */
};

/* values for ne_exetyp */
#define	NE_UNKNOWN	0x0
#define NE_OS2		0x1
#define NE_WINDOWS	0x2
#define NE_DOS4		0x3

/* resource type or name string */
struct rsrc_string {
    char rs_len;		    /* number of bytes in string */
    char rs_string[1];		    /* text of string */    
};


/* resource type information block */
struct rsrc_typeinfo {
    unsigned short  rt_id;
    unsigned short  rt_nres;
#if 1
    char	    _pad1[4];
#else
    long	    rt_proc;
#endif
};

/* resource name information block */
struct rsrc_nameinfo {
    /* 
     * The following two fields must be shifted left by the value of the
     * rs_align field to compute their actual value.  This allows resources
     * to be larger than 64k, but they do not need to be aligned on 512-byte
     * boundiaries, the way segments are.
     */
    unsigned short  rn_offset;	    /* file offset of resource data */ 
    unsigned short  rn_size;	    /* length of resource data */
    unsigned short  rn_flags;	    /* resource flags */
    unsigned short  rn_id;	    /* resource name id */
#if 1
    char	    _pad1[4];
#else
    unsigned short  rn_handle;	    /* if loaded, then global handle */
    unsigned short  rn_usage;	    /* number of times the handle for this
				     * resource has been given out; initially 
				     * zero */
#endif
};

/* bits in rn_flags */
#define RNMOVE		0x0010	    /* moveable resource */
#define RNPURE		0x0020	    /* pure (read-only => shareable) resource */
#define RNPRELOAD	0x0040	    /* preloaded resource */
#define RNDISCARD	0xf000	    /* discard priority level for resource */

/* how to interpret rt_id and rn_id */
#define RSORDID		0x8000	    /* if high bit of ID set then integer ID;
				     * otherwise, ID is offset of string from
				     * beginning of the resource table */


/* resource table */
struct new_rsrc {
    unsigned short  rs_align;	    /* alignment shift count for resources */
    struct rsrc_typeinfo rs_typeinfo;    
};

#endif	/* !__NEWEXE_H__ */
