;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and get individual pixels.                                   ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/02/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV1.INC

.DATA

EXTERN Rop2XlateTable : BYTE
EXTERN  _GRP                 : DWORD
EXTERN  _devpStatus          : DWORD
EXTERN  _devXlateTbl         : BYTE
EXTERN  _devColorToMono      : BYTE
EXTERN  _devUpdateColorsTbl  : DWORD
EXTERN  _agr_ioport          : WORD
EXTERN  _ioport              : WORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD


.CODE
.386

devSetPixel     PROC NEAR USES gs                       \
                        xPos  : WORD,                   \
                        yPos  : WORD,                   \
                        color : DWORD,                  \
                        rop   : WORD


;
; Get IV1 version of rop.
;
        xor     cx, cx
        mov     bx, rop
        mov     cl, Rop2XlateTable[bx]
;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
        mov     dx, _Y_TRANSLATION
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking




        mov     ecx, color
        mov     WORD PTR gs:[bx][GE_RGBCOLOR], 0
        mov     eax, ecx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[bx][FIFO16_OFF],ax          ; red color data
        mov     al, ch
        mov     gs:[bx][FIFO16_OFF],ax          ; green color data
        mov     al, cl                  
        mov     gs:[bx][FIFO16_OFF],ax          ; blue color data


@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
                        

        mov     dx, _Y_TRANSLATION
        mov     ax, yPos
        sub     dx, ax   
        mov     ax, xPos
        mov     WORD PTR gs:[bx][GE_FLINE], 0
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     gs:[bx][FIFO16_OFF], dx     
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     gs:[bx][FIFO16_OFF], dx     
     
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     ax, 3
        mov     gs:[bx][FIFO16_OFF], ax
        mov     ax, -1
IVEndRopBack:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;


        ret
devSetPixel     ENDP

devGetPixel     PROC NEAR USES gs es di                 \
                        xPos  : WORD,                   \
                        yPos  : WORD



        mov     ax, ds
        mov     es, ax


;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        sub	eax,eax
        mov     gs:[di][FINISHFLAG0], eax
        mov     WORD PTR gs:[di][GE_FINISH0], 0
@@:     test    BYTE PTR gs:[di][FINISHFLAG0], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking


        mov     WORD PTR gs:[di][GE_READSOURCE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], RW_FBUFFER_28     ; full 28bit fb
    ;
    ; Clear the FINISH1 flag
    ;
    ;
    ; Clear the FINISH1 flag.  The microcode will set this flag to indicate
    ; it has received DMA token and is ready to START DMA.
    ;
        sub     eax,eax
        mov     gs:[di][FINISHFLAG1], eax


        mov     WORD PTR gs:[di][GE_READBLOCK_R], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0 ;dummy upacmode 
        mov     ax, xPos
        mov     gs:[di][FIFO16_OFF], ax         ;starting x
        mov     ax, 1
        mov     gs:[di][FIFO16_OFF], ax         ;x size
        mov     ax, yPos
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
	sub	dx, ax                          ;get translated Y
        mov     gs:[di][FIFO16_OFF], dx         ;starting y
    ;
    ; now we need to send down a "no interrupts" flag
    ;
	mov	ax, IV1BLTDONE                  ;-1(for no interrupts, usethe done flag)
	mov	gs:[di][FIFO16_OFF], ax

        mov     ax, 1                           ; must send down Y size of 1
                                                ; cause of IV1 UCode
        mov     gs:[di][FIFO16_OFF], ax         ;y length
        mov     ax, IV1BLTDONE
        mov     gs:[di][FIFO16_OFF], ax         ;done flag
    ;
    ; Wait for microcode to be ready (FINISH1 flag set)
    ;
@@:     test    BYTE PTR gs:[di][FINISHFLAG1], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking

    ;
    ; Turn on "string burst" mode
    ;
	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
        mov     cx,dx                           ;save base port

	add	dx, IV1CONFIG_PORT
	in	ax, dx
	or	ax, IV1CFGSTRN_BURST
	out	dx, ax
    ;
    ; Get DMA Port
    ;
        mov     dx, cx                          ;get base port
	add	dx, IV1CFGSTRING_IO_PORT
BltXLoop:
        in      eax,dx
        push    eax                             ;save returned pixel value

   ;
   ;Must Delay before turning off stringburst mode
   ;IV1 HARDWARE BUG
   ;

        mov     cx,IV1HWBUGLOOP         ;do 30 in's from port 84 for delay

IV_DELAYLOOP:
        mov     dx,084h
        in      ax,dx
        loop    IV_DELAYLOOP

   ;
   ;At this point we can turn off stringburst mode
   ;

	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
	add	dx, IV1CONFIG_PORT

	in	ax, dx
	and	ax, NOT IV1CFGSTRN_BURST
	out	dx, ax

    ;
    ; Clear the FINISH1 flag
    ;
        sub	eax,eax
        mov     gs:[di][FINISHFLAG1], eax

        pop     eax                     ;get pix value
;
; Force returned pixel into physical format.
;
        mov     edx, eax
        shr     edx, 16
        xchg    al, dl
        mov     dh, 0FFh
Exit:
        ret
devGetPixel     ENDP

devClippedLine  PROC NEAR USES gs es di si              \
                        x1     : WORD,                  \
                        y1     : WORD,                  \
                        x2     : WORD,                  \
                        y2     : WORD,                  \
                        lpRect : DWORD,                 \
                        color  : DWORD,                 \
                        rop    : WORD


;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]
        les     si, lpRect

;
; Wait for GE FIFO to become available.
;
        mov     dx, _Y_TRANSLATION
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        mov     WORD PTR gs:[bx][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[bx][FIFO16_OFF], 1
        mov     ax, es:[si]                     ; rectLeft
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     dx, _Y_TRANSLATION
        mov     cx, dx

        mov     ax, es:[si][6]                  ; rectBottom
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[bx][FIFO16_OFF], dx     

        mov     ax, es:[si][4]                  ; rectRight
        dec     ax
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     ax, es:[si][2]                  ; rectTop
        sub     cx, ax
        mov     gs:[bx][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Setting Clip
;

        mov     di, rop
        mov     cl, Rop2XlateTable[di]
        xor     ch, ch


;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        mov     ecx, color
        mov     WORD PTR gs:[bx][GE_RGBCOLOR], 0
        mov     eax, ecx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[bx][FIFO16_OFF],ax          ; red color data
        mov     al, ch
        mov     gs:[bx][FIFO16_OFF],ax          ; green color data
        mov     al, cl                  
        mov     gs:[bx][FIFO16_OFF],ax          ; blue color data


@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        mov     dx, _Y_TRANSLATION
        mov     ax, y1
        sub     dx, ax   
        mov     cx, _Y_TRANSLATION
        mov     ax, y2
        sub     cx, ax

        mov     WORD PTR gs:[bx][GE_FLINE], 0
        mov     ax, x1
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], dx
        mov     ax, x2
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], cx     
     
Exit:



;
; Wait until IV1 idle.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
;
; Reset Clip plane to FULL SCREEN
;

        mov     WORD PTR gs:[bx][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[bx][FIFO16_OFF], 1
        mov     ax, 0
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     dx, _Y_TRANSLATION
        mov     cx, dx
        mov     ax, _GLOB_Y_Size
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[bx][FIFO16_OFF], dx     
        mov     ax, _GLOB_X_Size
        dec     ax
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     gs:[bx][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Resetting Clip
;


;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;


        ret
devClippedLine  ENDP

devLine         PROC NEAR USES gs di                    \
                        x1     : WORD,                  \
                        y1     : WORD,                  \
                        x2     : WORD,                  \
                        y2     : WORD,                  \
                        color  : DWORD,                 \
                        rop    : WORD




;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]

;
; Wait for GE FIFO to become available.
;
        mov     dx, _Y_TRANSLATION
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        mov     di, rop
        mov     cl, Rop2XlateTable[di]
        xor     ch, ch


;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     gs:[bx][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        mov     ecx, color
        mov     WORD PTR gs:[bx][GE_RGBCOLOR], 0
        mov     eax, ecx
        shr     eax, 16
        xor     ah, ah
        mov     gs:[bx][FIFO16_OFF],ax          ; red color data
        mov     al, ch
        mov     gs:[bx][FIFO16_OFF],ax          ; green color data
        mov     al, cl                  
        mov     gs:[bx][FIFO16_OFF],ax          ; blue color data


@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


        mov     dx, _Y_TRANSLATION
        mov     ax, y1
        sub     dx, ax   
        mov     cx, _Y_TRANSLATION
        mov     ax, y2
        sub     cx, ax

        mov     WORD PTR gs:[bx][GE_FLINE], 0
        mov     ax, x1
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], dx
        mov     ax, x2
        mov     WORD PTR gs:[bx][FIFO16_OFF], ax
        mov     WORD PTR gs:[bx][FIFO16_OFF], cx     
     
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

Exit:



;
; Wait until IV1 idle.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[bx][GE_RASTEROP], 0
        mov     WORD PTR gs:[bx][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[bx][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;



        ret        
devLine         ENDP

        END




